/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.DuplicateContactCollectFolderRemoverTask;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public final class FolderAddIndex4SharedFolderSearch
extends UpdateTaskAdapter {
    private static final String[] DEPENDENCIES = new String[]{DuplicateContactCollectFolderRemoverTask.class.getName()};

    @Override
    public int addedWithVersion() {
        return 100;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGH.priority;
    }

    @Override
    public String[] getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            con.setAutoCommit(false);
            org.apache.commons.logging.Log log = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(FolderAddIndex4SharedFolderSearch.class));
            String[] tables = new String[]{"oxfolder_tree", "del_oxfolder_tree"};
            this.createIndexes(con, tables, new String[]{"cid", "parent"}, "parentIndex", log);
            this.createIndexes(con, tables, new String[]{"cid", "type"}, "typeIndex", log);
            this.createIndexes(con, tables, new String[]{"cid", "module"}, "moduleIndex", log);
            tables = new String[]{"oxfolder_permissions", "del_oxfolder_permissions"};
            this.createIndexes(con, tables, new String[]{"cid", "permission_id", "fuid"}, "principal", log);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
    }

    private void createIndexes(Connection con, String[] tables, String[] fieldNames, String name, org.apache.commons.logging.Log log) {
        StringBuilder sb = new StringBuilder(64);
        for (String table : tables) {
            try {
                int i;
                String indexName = Tools.existsIndex(con, table, fieldNames);
                if (null == indexName) {
                    if (log.isInfoEnabled()) {
                        sb.setLength(0);
                        sb.append("Creating new index named \"");
                        sb.append(name);
                        sb.append("\" with columns (");
                        sb.append(fieldNames[0]);
                        for (i = 1; i < fieldNames.length; ++i) {
                            sb.append(',').append(fieldNames[i]);
                        }
                        sb.append(") on table ");
                        sb.append(table);
                        sb.append('.');
                        log.info((Object)sb.toString());
                    }
                    Tools.createIndex(con, table, name, fieldNames, false);
                    continue;
                }
                if (!log.isInfoEnabled()) continue;
                sb.setLength(0);
                sb.append("New index named \"");
                sb.append(indexName);
                sb.append("\" with columns (");
                sb.append(fieldNames[0]);
                for (i = 1; i < fieldNames.length; ++i) {
                    sb.append(',').append(fieldNames[i]);
                }
                sb.append(") already exists on table ");
                sb.append(table);
                sb.append('.');
                log.info((Object)sb.toString());
            }
            catch (SQLException e) {
                log.error((Object)("Problem adding index " + name + " on table " + table + '.'), (Throwable)e);
            }
        }
    }
}

