/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class DefaultConfirmStatusUpdateTask
implements UpdateTask {
    private static final String TABLE = "user_setting_server";
    private static final String COLUMN_PRIVATE = "defaultStatusPrivate";
    private static final String COLUMN_PUBLIC = "defaultStatusPublic";
    private static final String ALTER_PRIVATE = "ALTER TABLE user_setting_server ADD defaultStatusPrivate INT4 UNSIGNED DEFAULT 0";
    private static final String ALTER_PUBLIC = "ALTER TABLE user_setting_server ADD defaultStatusPublic INT4 UNSIGNED DEFAULT 0";
    private static final Map<String, String> STATEMENTS = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(DefaultConfirmStatusUpdateTask.COLUMN_PRIVATE, DefaultConfirmStatusUpdateTask.ALTER_PRIVATE);
            this.put(DefaultConfirmStatusUpdateTask.COLUMN_PUBLIC, DefaultConfirmStatusUpdateTask.ALTER_PUBLIC);
        }
    };

    @Override
    public int addedWithVersion() {
        return 70;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            con.setAutoCommit(false);
            for (String column : STATEMENTS.keySet()) {
                if (Tools.columnExists(con, TABLE, column)) continue;
                PreparedStatement stmt = con.prepareStatement(STATEMENTS.get(column));
                stmt.execute();
                stmt.close();
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw OXCalendarExceptionCodes.UPDATE_EXCEPTION.create(e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
    }
}

