/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.search.SearchObject;
import com.openexchange.groupware.search.TaskSearchObject;
import com.openexchange.groupware.tasks.Mapper;
import com.openexchange.groupware.tasks.Mapping;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.java.Autoboxing;
import com.openexchange.tools.sql.DBUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public final class SQL {
    private static final String ALL_FIELDS;
    static final String COUNT_TASKS_IN_CONTEXT = "SELECT count(id) FROM task WHERE cid=?";
    public static final Map<StorageType, String> TASK_TABLES;
    static final Map<StorageType, String> PARTS_TABLES;
    static final Map<StorageType, String> EPARTS_TABLES;
    static final Map<StorageType, String> FOLDER_TABLES;
    static final Map<StorageType, String> SEARCH_USER_TASKS;
    static final Map<StorageType, String> INSERT_PARTS;
    static final Map<StorageType, String> SELECT_PARTS;
    static final Map<StorageType, String> UPDATE_PARTS;
    static final Map<StorageType, String> DELETE_PARTS;
    static final Map<StorageType, String> FIND_PARTICIPANT;
    static final Map<StorageType, String> FIND_GROUP;
    static final Map<StorageType, String> INSERT_EXTERNAL;
    static final Map<StorageType, String> SELECT_EXTERNAL;
    static final Map<StorageType, String> DELETE_EXTERNAL;
    static final Map<StorageType, String> INSERT_FOLDER;
    static final Map<StorageType, String> DELETE_FOLDER;
    static final Map<StorageType, String> SELECT_FOLDER;
    static final Map<StorageType, String> FOLDER_BY_USER;
    static final Map<StorageType, String> FOLDER_BY_ID;
    static final Map<StorageType, String> TASK_IN_FOLDER;
    static final Map<StorageType, String> SEARCH_FOLDER_BY_USER;

    private SQL() {
    }

    static String getAllFields() {
        return ALL_FIELDS;
    }

    static String getFields(int[] columns, boolean folder) throws OXException {
        StringBuilder sql = new StringBuilder();
        block4: for (int i : columns) {
            Mapper<?> mapper = Mapping.getMapping(i);
            if (null == mapper) {
                switch (i) {
                    case 105: 
                    case 204: 
                    case 220: 
                    case 221: {
                        continue block4;
                    }
                    case 20: {
                        if (!folder) continue block4;
                        sql.append("folder,");
                        continue block4;
                    }
                    default: {
                        throw TaskExceptionCode.UNKNOWN_ATTRIBUTE.create(Autoboxing.I((int)i));
                    }
                }
            }
            sql.append(mapper.getDBColumnName());
            sql.append(',');
        }
        sql.setLength(sql.length() - 1);
        return sql.toString();
    }

    static String allFoldersWhere(List<Integer> all, List<Integer> own, List<Integer> shared) {
        StringBuilder sql = new StringBuilder();
        if (all.size() + own.size() + shared.size() > 0) {
            int i;
            sql.append('(');
            if (all.size() > 0) {
                sql.append("(folder in (");
                for (i = 0; i < all.size(); ++i) {
                    sql.append("?,");
                }
                sql.setLength(sql.length() - 1);
                sql.append("))");
            }
            if (own.size() > 0) {
                if (sql.length() > 1) {
                    sql.append(" OR ");
                }
                sql.append("(folder in (");
                for (i = 0; i < own.size(); ++i) {
                    sql.append("?,");
                }
                sql.setLength(sql.length() - 1);
                sql.append(") AND created_from=?)");
            }
            if (shared.size() > 0) {
                if (sql.length() > 1) {
                    sql.append(" OR ");
                }
                sql.append("(folder in (");
                for (i = 0; i < shared.size(); ++i) {
                    sql.append("?,");
                }
                sql.setLength(sql.length() - 1);
                sql.append(") AND private=false)");
            }
            sql.append(')');
        } else {
            sql.append("false");
        }
        return sql.toString();
    }

    static String getRangeWhere(TaskSearchObject search) throws OXException {
        StringBuilder sql = new StringBuilder();
        Date[] range = search.getRange();
        if (null != range) {
            if (range.length < 1 || range.length > 2) {
                throw TaskExceptionCode.WRONG_DATE_RANGE.create(range.length);
            }
            if (range.length >= 1) {
                sql.append("(end >= ?");
            }
            if (range.length == 2) {
                sql.append(" AND end < ?");
            }
            sql.append(')');
        }
        return sql.toString();
    }

    static String getPatternWhere(TaskSearchObject search) {
        StringBuilder sql = new StringBuilder();
        if (SearchObject.NO_PATTERN != search.getPattern()) {
            sql.append('(');
            sql.append(Mapping.getMapping(200).getDBColumnName());
            sql.append(" LIKE ? OR ");
            sql.append(Mapping.getMapping(203).getDBColumnName());
            sql.append(" LIKE ? OR ");
            sql.append(Mapping.getMapping(100).getDBColumnName());
            sql.append(" LIKE ?)");
        }
        return sql.toString();
    }

    static String getOnlyOwn(String table) {
        StringBuilder sql = new StringBuilder();
        sql.append(table);
        sql.append(".created_from=?");
        return sql.toString();
    }

    static String getNoPrivate(String table) {
        StringBuilder sql = new StringBuilder();
        sql.append(table);
        sql.append(".private=false");
        return sql.toString();
    }

    static String getOrder(int orderBy, Order order) {
        StringBuilder sql = new StringBuilder();
        if (0 != orderBy && !Order.NO_ORDER.equals((Object)order)) {
            sql.append(" ORDER BY ");
            sql.append(Mapping.getMapping(orderBy).getDBColumnName());
            sql.append(' ');
            sql.append(DBUtils.forSQLCommand(order));
        }
        return sql.toString();
    }

    static String getLimit(int from, int to) {
        StringBuilder sql = new StringBuilder();
        if (-1 != to) {
            sql.append(" LIMIT ");
            sql.append(from);
            sql.append(',');
            sql.append(to - from);
        }
        return sql.toString();
    }

    public static Mapper<?>[] findTruncated(String[] fields) {
        ArrayList<Mapper<? extends Object>> tmp = new ArrayList<Mapper<? extends Object>>();
        block0: for (String field : fields) {
            for (Mapper<? extends Object> mapper : Mapping.MAPPERS) {
                if (!mapper.getDBColumnName().equals(field)) continue;
                tmp.add(mapper);
                continue block0;
            }
        }
        return tmp.toArray(new Mapper[tmp.size()]);
    }

    static {
        TASK_TABLES = new EnumMap<StorageType, String>(StorageType.class);
        PARTS_TABLES = new EnumMap<StorageType, String>(StorageType.class);
        EPARTS_TABLES = new EnumMap<StorageType, String>(StorageType.class);
        FOLDER_TABLES = new EnumMap<StorageType, String>(StorageType.class);
        SEARCH_USER_TASKS = new EnumMap<StorageType, String>(StorageType.class);
        INSERT_PARTS = new EnumMap<StorageType, String>(StorageType.class);
        SELECT_PARTS = new EnumMap<StorageType, String>(StorageType.class);
        UPDATE_PARTS = new EnumMap<StorageType, String>(StorageType.class);
        DELETE_PARTS = new EnumMap<StorageType, String>(StorageType.class);
        FIND_PARTICIPANT = new EnumMap<StorageType, String>(StorageType.class);
        FIND_GROUP = new EnumMap<StorageType, String>(StorageType.class);
        INSERT_EXTERNAL = new EnumMap<StorageType, String>(StorageType.class);
        SELECT_EXTERNAL = new EnumMap<StorageType, String>(StorageType.class);
        DELETE_EXTERNAL = new EnumMap<StorageType, String>(StorageType.class);
        INSERT_FOLDER = new EnumMap<StorageType, String>(StorageType.class);
        DELETE_FOLDER = new EnumMap<StorageType, String>(StorageType.class);
        SELECT_FOLDER = new EnumMap<StorageType, String>(StorageType.class);
        FOLDER_BY_USER = new EnumMap<StorageType, String>(StorageType.class);
        FOLDER_BY_ID = new EnumMap<StorageType, String>(StorageType.class);
        TASK_IN_FOLDER = new EnumMap<StorageType, String>(StorageType.class);
        SEARCH_FOLDER_BY_USER = new EnumMap<StorageType, String>(StorageType.class);
        StringBuilder selectAll = new StringBuilder();
        for (Mapper<? extends Object> mapper : Mapping.MAPPERS) {
            selectAll.append(mapper.getDBColumnName());
            selectAll.append(',');
        }
        selectAll.setLength(selectAll.length() - 1);
        ALL_FIELDS = selectAll.toString();
        StorageType[] activeDelete = new StorageType[]{StorageType.ACTIVE, StorageType.DELETED};
        String tableName = "@tableName@";
        TASK_TABLES.put(StorageType.ACTIVE, "task");
        TASK_TABLES.put(StorageType.DELETED, "del_task");
        PARTS_TABLES.put(StorageType.ACTIVE, "task_participant");
        PARTS_TABLES.put(StorageType.REMOVED, "task_removedparticipant");
        PARTS_TABLES.put(StorageType.DELETED, "del_task_participant");
        EPARTS_TABLES.put(StorageType.ACTIVE, "task_eparticipant");
        EPARTS_TABLES.put(StorageType.DELETED, "del_task_eparticipant");
        FOLDER_TABLES.put(StorageType.ACTIVE, "task_folder");
        FOLDER_TABLES.put(StorageType.DELETED, "del_task_folder");
        String sql = "SELECT id FROM @taskTable@ LEFT JOIN @participantTable@ ON @taskTable@.cid=@participantTable@.cid AND @taskTable@.id=@participantTable@.task WHERE @taskTable@.cid=? AND (@taskTable@.created_from=? OR @taskTable@.changed_from=?)";
        for (StorageType type : activeDelete) {
            SEARCH_USER_TASKS.put(type, sql.replace("@taskTable@", TASK_TABLES.get((Object)type)).replace("@participantTable@", PARTS_TABLES.get((Object)type)));
        }
        sql = "INSERT INTO @tableName@ (cid,task,user,group_id,accepted,description) VALUES (?,?,?,?,?,?)";
        for (StorageType type : activeDelete) {
            INSERT_PARTS.put(type, sql.replace("@tableName@", PARTS_TABLES.get((Object)type)));
        }
        INSERT_PARTS.put(StorageType.REMOVED, "INSERT INTO task_removedparticipant (cid,task,user,group_id,accepted,description,folder) VALUES (?,?,?,?,?,?,?)");
        SELECT_PARTS.put(StorageType.ACTIVE, "SELECT task,user,group_id,accepted,description FROM task_participant WHERE cid=? AND task IN (");
        SELECT_PARTS.put(StorageType.REMOVED, "SELECT task,user,group_id,accepted,description,folder FROM task_removedparticipant WHERE cid=? AND task IN (");
        SELECT_PARTS.put(StorageType.DELETED, "SELECT task,user,group_id,accepted,description FROM del_task_participant WHERE cid=? AND task IN (");
        sql = "UPDATE @tableName@ SET group_id=?, accepted=?, description=? WHERE cid=? AND task=? AND user=?";
        for (StorageType type : StorageType.values()) {
            UPDATE_PARTS.put(type, sql.replace("@tableName@", PARTS_TABLES.get((Object)type)));
        }
        sql = "DELETE FROM @tableName@ WHERE cid=? AND task=? AND user IN (";
        for (StorageType type : StorageType.values()) {
            DELETE_PARTS.put(type, sql.replace("@tableName@", PARTS_TABLES.get((Object)type)));
        }
        sql = "SELECT task FROM @tableName@ WHERE cid=? AND user=?";
        for (StorageType type : StorageType.values()) {
            FIND_PARTICIPANT.put(type, sql.replace("@tableName@", PARTS_TABLES.get((Object)type)));
        }
        sql = "SELECT task FROM @tableName@ WHERE cid=? AND group_id=?";
        for (StorageType type : StorageType.values()) {
            FIND_GROUP.put(type, sql.replace("@tableName@", PARTS_TABLES.get((Object)type)));
        }
        sql = "INSERT INTO @tableName@ (cid,task,mail,display_name) VALUES (?,?,?,?)";
        for (StorageType type : activeDelete) {
            INSERT_EXTERNAL.put(type, sql.replace("@tableName@", EPARTS_TABLES.get((Object)type)));
        }
        sql = "DELETE FROM @tableName@ WHERE cid=? AND task=? AND mail IN (";
        for (StorageType type : activeDelete) {
            DELETE_EXTERNAL.put(type, sql.replace("@tableName@", EPARTS_TABLES.get((Object)type)));
        }
        sql = "SELECT task,mail,display_name FROM @tableName@ WHERE cid=? AND task IN (";
        for (StorageType type : activeDelete) {
            SELECT_EXTERNAL.put(type, sql.replace("@tableName@", EPARTS_TABLES.get((Object)type)));
        }
        sql = "INSERT INTO @tableName@ (cid, id, folder, user) VALUES (?,?,?,?)";
        for (StorageType type : activeDelete) {
            INSERT_FOLDER.put(type, sql.replace("@tableName@", FOLDER_TABLES.get((Object)type)));
        }
        sql = "DELETE FROM @tableName@ WHERE cid=? AND id=? AND folder IN (";
        for (StorageType type : activeDelete) {
            DELETE_FOLDER.put(type, sql.replace("@tableName@", FOLDER_TABLES.get((Object)type)));
        }
        sql = "SELECT folder,user FROM @tableName@ WHERE cid=? AND id=?";
        for (StorageType type : activeDelete) {
            SELECT_FOLDER.put(type, sql.replace("@tableName@", FOLDER_TABLES.get((Object)type)));
        }
        sql = "SELECT folder FROM @tableName@ WHERE cid=? AND id=? AND user=?";
        for (StorageType type : activeDelete) {
            FOLDER_BY_USER.put(type, sql.replace("@tableName@", FOLDER_TABLES.get((Object)type)));
        }
        sql = "SELECT user FROM @tableName@ WHERE cid=? AND id=? AND folder=?";
        for (StorageType type : activeDelete) {
            FOLDER_BY_ID.put(type, sql.replace("@tableName@", FOLDER_TABLES.get((Object)type)));
        }
        sql = "SELECT id FROM @tableName@ WHERE cid=? AND folder=?";
        for (StorageType type : activeDelete) {
            TASK_IN_FOLDER.put(type, sql.replace("@tableName@", FOLDER_TABLES.get((Object)type)));
        }
        sql = "SELECT folder,id FROM @tableName@ WHERE cid=? AND user=?";
        for (StorageType type : activeDelete) {
            SEARCH_FOLDER_BY_USER.put(type, sql.replace("@tableName@", FOLDER_TABLES.get((Object)type)));
        }
    }
}

