/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree;

import com.openexchange.config.ConfigTools;
import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.ReadOnlyValue;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;

public class CookieLifetime
implements PreferencesItemService {
    private static final String NAME = "cookielifetime";

    @Override
    public String[] getPath() {
        return new String[]{NAME};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new ReadOnlyValue(){

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return true;
            }

            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
                if (null != service && service.getBoolProperty("com.openexchange.sessiond.autologin", false)) {
                    int maxAge = ConfigTools.parseTimespanSecs((String)service.getProperty("com.openexchange.cookie.ttl", "1W"));
                    setting.setSingleValue(maxAge);
                } else {
                    setting.setSingleValue(-1);
                }
            }
        };
    }
}

