/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.impl;

import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.java.StringAllocator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractSetting<T extends AbstractSetting<? extends T>>
implements Setting {
    public static final char SEPARATOR = '/';
    private final int id;
    private T parent;
    private final IValueHandler shared;
    private final String name;
    private Map<String, T> elements;

    protected AbstractSetting(String name, int id, IValueHandler shared) {
        this.name = name;
        this.shared = shared;
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public T getElement(String subName) {
        AbstractSetting element = null;
        if (null != this.elements) {
            element = (AbstractSetting)this.elements.get(subName);
        }
        return (T)element;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean isLeaf() {
        return null == this.elements || 0 == this.elements.size();
    }

    void addElement(T child) {
        if (null == this.elements) {
            this.elements = new HashMap<String, T>();
        }
        this.elements.put(((AbstractSetting)child).getName(), child);
    }

    protected void removeElementInternal(T child) {
        if (null != this.elements) {
            this.elements.remove(((AbstractSetting)child).getName());
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.name);
        if (null != this.elements) {
            out.append('(');
            Iterator<T> iter = this.elements.values().iterator();
            while (iter.hasNext()) {
                out.append(((AbstractSetting)iter.next()).toString());
                if (!iter.hasNext()) continue;
                out.append(',');
            }
            out.append(')');
        }
        return out.toString();
    }

    public T[] getElements() {
        ArrayList<T> tmp = new ArrayList<T>();
        if (null != this.elements) {
            tmp.addAll(this.elements.values());
        }
        AbstractSetting[] retval = (AbstractSetting[])Array.newInstance(this.getClass(), tmp.size());
        return tmp.toArray(retval);
    }

    @Override
    public boolean isShared() {
        return -1 == this.shared.getId();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractSetting)) {
            return false;
        }
        AbstractSetting other = (AbstractSetting)obj;
        if (this.id != other.getId() || !this.name.equals(other.getName())) {
            return false;
        }
        return this.parent == null || ((AbstractSetting)this.parent).equals(other.getParent());
    }

    public int hashCode() {
        int retval = this.id ^ this.name.hashCode();
        if (this.isShared()) {
            retval ^= Boolean.TRUE.hashCode();
        }
        return retval;
    }

    public void setParent(T parent) {
        this.parent = parent;
    }

    @Override
    public String getPath() {
        return null == this.parent ? this.name : new StringAllocator(((AbstractSetting)this.parent).getPath()).append('/').append(this.name).toString();
    }

    public T getParent() {
        return this.parent;
    }

    @Override
    public IValueHandler getShared() {
        return this.shared;
    }
}

