/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.tx.DBService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.EffectiveInfostorePermission;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.database.impl.InfostoreIterator;
import com.openexchange.groupware.infostore.database.impl.InfostoreSecurity;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.tools.collections.Injector;
import com.openexchange.tools.collections.OXCollections;
import com.openexchange.tools.iterator.SearchIteratorException;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class InfostoreSecurityImpl
extends DBService
implements InfostoreSecurity {
    @Override
    public EffectiveInfostorePermission getInfostorePermission(int id, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        List<DocumentMetadata> documentData = this.getFolderIdAndCreatorForDocuments(new int[]{id}, ctx);
        if (documentData == null || documentData.size() <= 0 || documentData.get(0) == null) {
            throw InfostoreExceptionCodes.NOT_EXIST.create();
        }
        return this.getInfostorePermission(documentData.get(0), ctx, user, userConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EffectiveInfostorePermission getInfostorePermission(DocumentMetadata document, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        Connection con = null;
        try {
            con = this.getReadConnection(ctx);
            EffectivePermission isperm = new OXFolderAccess(con, ctx).getFolderPermission((int)document.getFolderId(), user.getId(), userConfig);
            EffectiveInfostorePermission effectiveInfostorePermission = new EffectiveInfostorePermission(isperm, document, user);
            return effectiveInfostorePermission;
        }
        finally {
            this.releaseReadConnection(ctx, con);
        }
    }

    private List<DocumentMetadata> getFolderIdAndCreatorForDocuments(int[] is, Context ctx) throws OXException {
        InfostoreIterator iter = InfostoreIterator.list(is, new Metadata[]{Metadata.FOLDER_ID_LITERAL, Metadata.ID_LITERAL, Metadata.CREATED_BY_LITERAL}, this.getProvider(), ctx);
        try {
            return iter.asList();
        }
        catch (SearchIteratorException e) {
            throw InfostoreExceptionCodes.COULD_NOT_LOAD.create(e, new Object[0]);
        }
    }

    @Override
    public EffectivePermission getFolderPermission(long folderId, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        return this.getFolderPermission(folderId, ctx, user, userConfig, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EffectivePermission getFolderPermission(long folderId, Context ctx, User user, UserConfiguration userConfig, Connection readConArg) throws OXException {
        Connection readCon = null;
        try {
            readCon = readConArg != null ? readConArg : this.getReadConnection(ctx);
            EffectivePermission effectivePermission = new OXFolderAccess(readCon, ctx).getFolderPermission((int)folderId, user.getId(), userConfig);
            return effectivePermission;
        }
        finally {
            if (readConArg == null) {
                this.releaseReadConnection(ctx, readCon);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <L> L injectInfostorePermissions(int[] ids, Context ctx, User user, UserConfiguration userConfig, L list, Injector<L, EffectiveInfostorePermission> injector) throws OXException {
        HashMap<Integer, EffectivePermission> cache = new HashMap<Integer, EffectivePermission>();
        ArrayList<EffectiveInfostorePermission> permissions = new ArrayList<EffectiveInfostorePermission>();
        Connection con = null;
        List<DocumentMetadata> metadata = this.getFolderIdAndCreatorForDocuments(ids, ctx);
        try {
            con = this.getReadConnection(ctx);
            OXFolderAccess access = new OXFolderAccess(con, ctx);
            for (DocumentMetadata m : metadata) {
                EffectivePermission isperm;
                if (cache.containsKey((int)m.getFolderId())) {
                    isperm = (EffectivePermission)cache.get((int)m.getFolderId());
                } else {
                    isperm = access.getFolderPermission((int)m.getFolderId(), user.getId(), userConfig);
                    cache.put((int)m.getFolderId(), isperm);
                }
                permissions.add(new EffectiveInfostorePermission(isperm, m, user));
            }
        }
        finally {
            this.releaseReadConnection(ctx, con);
        }
        return OXCollections.inject(list, permissions, injector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkFolderId(long folderId, Context ctx) throws OXException {
        FolderObject fo;
        Connection readCon = null;
        try {
            readCon = this.getReadConnection(ctx);
            OXFolderAccess access = new OXFolderAccess(readCon, ctx);
            fo = access.getFolderObject((int)folderId);
        }
        finally {
            this.releaseReadConnection(ctx, readCon);
        }
        if (fo.getModule() != 8) {
            throw InfostoreExceptionCodes.NOT_INFOSTORE_FOLDER.create(Autoboxing.L((long)folderId));
        }
    }
}

