/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container.participants;

import com.openexchange.groupware.container.participants.ConfirmStatus;
import com.openexchange.groupware.container.participants.ConfirmableParticipant;

public abstract class AbstractConfirmableParticipant
implements ConfirmableParticipant {
    private static final long serialVersionUID = 2232819928880304722L;
    private ConfirmStatus status = ConfirmStatus.NONE;
    private boolean bStatus = false;
    private String message;
    private boolean bMessage = false;

    protected AbstractConfirmableParticipant() {
    }

    protected AbstractConfirmableParticipant(ConfirmableParticipant copy) {
        this();
        this.status = copy.getStatus();
        this.bStatus = copy.containsStatus();
        this.message = copy.getMessage();
        this.bMessage = copy.containsMessage();
    }

    @Override
    public final boolean containsStatus() {
        return this.bStatus;
    }

    @Override
    public final int getConfirm() {
        return this.status.getId();
    }

    @Override
    public final String getMessage() {
        return this.message;
    }

    @Override
    public final ConfirmStatus getStatus() {
        return this.status;
    }

    @Override
    public final void setConfirm(int confirm) {
        this.status = ConfirmStatus.byId(confirm);
        this.bStatus = true;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
        this.bMessage = true;
    }

    @Override
    public void setStatus(ConfirmStatus status) {
        this.status = status;
        this.bStatus = true;
    }

    @Override
    public boolean containsMessage() {
        return this.bMessage;
    }

    public AbstractConfirmableParticipant clone() throws CloneNotSupportedException {
        AbstractConfirmableParticipant retval = (AbstractConfirmableParticipant)super.clone();
        retval.bMessage = this.bMessage;
        retval.bStatus = this.bStatus;
        retval.message = this.message;
        retval.status = this.status;
        return retval;
    }
}

