/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactConfig;
import com.openexchange.groupware.contact.ContactSql;
import com.openexchange.groupware.contact.Contacts;
import com.openexchange.groupware.contact.sqlinjectors.IntSQLInjector;
import com.openexchange.groupware.contact.sqlinjectors.SQLInjector;
import com.openexchange.groupware.contact.sqlinjectors.StringSQLInjector;
import com.openexchange.groupware.contact.sqlinjectors.TimestampSQLInjector;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.groupware.tools.iterator.FolderObjectIterator;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.Strings;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.session.Session;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.iterator.SearchIteratorException;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;

public class ContactMySql
implements ContactSql {
    private static final String STR_PERCENT = "%";
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ContactMySql.class));
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private String select = "SELECT co.intfield01,co.cid,co.timestampfield01,co.field03,co.field04,co.field06,co.field07,co.field09,co.field10,co.intfield03,co.field79 FROM prg_contacts AS co ";
    private String[] where;
    private String order = "";
    private int user;
    private int can_read_only_own;
    private int folder;
    private String all_folders;
    private ContactSearchObject cso;
    private long changed_since;
    private long created_since;
    private long both_since;
    private String search_habit = " AND ";
    private int[][] object_id_array;
    private int userid;
    private int[] userIds;
    private boolean internal_user_only;
    private int objectID;
    private final List<SQLInjector> injectors = new ArrayList<SQLInjector>();
    private Context ctx;
    private static final Pattern PAT_ORDER_BY = Pattern.compile("( *ORDER +BY +)(?:([a-zA-Z0-9_.]+)(?: *ASC *| *DESC *)?)(?:, *[a-zA-Z0-9_.]+(?: *ASC *| *DESC *)?)?", 2);
    private static final Pattern PAT_FIELD = Pattern.compile("(?:([a-zA-Z0-9_.]+)(?: *ASC| *DESC)?)", 2);
    private static final Pattern PAT_PREP = Pattern.compile("[a-zA-Z0-9_]+\\.([a-zA-Z0-9_])");
    private static final int[] AUTOCOMPLETE_FIELDS = new int[]{555, 556, 557};
    private static String rightsSelectString = "SELECT co.intfield01,co.intfield02,co.intfield03,co.intfield04,co.fid,co.created_from,co.pflag,co.cid FROM prg_contacts AS co ";
    public static final String PREFIXED_FIELDS = "co.fid,co.cid,co.created_from,co.creating_date,co.changed_from,co.changing_date,co.intfield01";
    private static final List<SearchFiller> SEARCH_FILLERS;

    public ContactMySql(Session so) throws OXException {
        if (so != null) {
            this.ctx = ContextStorage.getStorageContext(so.getContextId());
            this.user = so.getUserId();
        }
    }

    public ContactMySql(Context ctx, int userId) {
        this.ctx = ctx;
        this.user = userId;
    }

    public ContactMySql(Session so, Context ctx) {
        this.ctx = ctx;
        this.user = so.getUserId();
    }

    @Override
    public String getOrder() {
        return this.order;
    }

    @Override
    public PreparedStatement getSqlStatement(Connection con) throws SQLException {
        StringBuilder sb = new StringBuilder(256);
        String select = this.getSelect();
        String orderBy = this.getOrder();
        if (null != orderBy) {
            int pos = select.indexOf(" FROM");
            if (pos < 0 && (pos = select.indexOf(" from")) < 0) {
                throw new SQLException("SELECT statement does not contain \"FROM\".");
            }
            String[] orderFields = ContactMySql.parseFieldsFromOrderBy(orderBy);
            if (0 < orderFields.length) {
                sb.append(select.substring(0, pos));
                for (String orderField : orderFields) {
                    if (-1 != select.indexOf(orderField)) continue;
                    sb.append(',').append(orderField);
                }
                sb.append(" FROM").append(select.substring(pos + 5));
                select = sb.toString();
                sb.setLength(0);
                orderBy = ContactMySql.prepareOrderBy(orderBy);
            }
        }
        String[] whereClauses = this.getWhere();
        sb.append(select);
        if (this.all_folders != null && this.all_folders.length() > 1) {
            sb.append(this.all_folders);
        }
        sb.append(whereClauses[0]);
        for (int i = 1; i < whereClauses.length; ++i) {
            sb.append(" UNION ");
            sb.append(select);
            if (this.all_folders != null && this.all_folders.length() > 1) {
                sb.append(this.all_folders);
            }
            sb.append(whereClauses[i]);
        }
        sb.append(orderBy);
        PreparedStatement ps = con.prepareStatement(sb.toString());
        int size = this.injectors.size();
        for (int i = 0; i < size; ++i) {
            this.injectors.get(i).inject(ps, i + 1);
        }
        this.injectors.clear();
        if (DEBUG) {
            String sql = ps.toString();
            LOG.debug((Object)("\nContactSQL Query: " + sql.substring(sql.indexOf(": ") + 2)));
        }
        return ps;
    }

    private static String[] parseFieldsFromOrderBy(String orderBy) {
        Matcher m = PAT_ORDER_BY.matcher(orderBy);
        if (m.matches()) {
            m = PAT_FIELD.matcher(orderBy.substring(m.end(1)));
            ArrayList<String> l = new ArrayList<String>(2);
            while (m.find()) {
                l.add(m.group(1));
            }
            return l.toArray(new String[l.size()]);
        }
        return new String[0];
    }

    private static final String prepareOrderBy(String orderBy) {
        return PAT_PREP.matcher(orderBy).replaceAll("$1");
    }

    protected String[] getWhere() {
        if (null != this.where) {
            return this.where;
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append(" WHERE co.cid = ").append(this.ctx.getContextId()).append(" AND ");
        if (this.can_read_only_own != 0) {
            sb.append(" (co.created_from = ?) AND ");
            this.injectors.add(new IntSQLInjector(this.can_read_only_own));
        }
        if (this.internal_user_only) {
            sb.append(" (co.userid is not null) AND (fid = ").append(6).append(") AND ");
        }
        if (this.userid > 0) {
            sb.append(" (co.userid = ").append(this.userid).append(") AND ");
        }
        if (this.userIds != null) {
            sb.append(" (co.userid IN (");
            for (int userId : this.userIds) {
                sb.append(userId).append(',');
            }
            sb.setCharAt(sb.length() - 1, ')');
            sb.append(") AND ");
        }
        if (this.changed_since > 0L) {
            sb.append(" (co.changing_date > ").append(this.changed_since).append(") AND ");
        }
        if (this.created_since > 0L) {
            sb.append(" (co.creating_date >= ").append(this.created_since).append(") AND ");
        }
        if (this.created_since > 0L) {
            sb.append(" (co.creating_date >= ").append(this.both_since).append(" OR (co.changed_from >= ").append(this.both_since).append(")) AND ");
        }
        if (this.objectID > 0) {
            sb.append(" (co.intfield01 = ").append(this.objectID).append(") AND ");
        }
        if (this.object_id_array != null && this.object_id_array.length > 0) {
            sb.append(" ( ");
            for (int i = 0; i < this.object_id_array.length; ++i) {
                int oidx = this.object_id_array[i][0];
                int fidx = this.object_id_array[i][1];
                sb.append(" (co.intfield01 = ").append(oidx).append(" AND co.fid = ").append(fidx).append(") ");
                if (i >= this.object_id_array.length - 1) continue;
                sb.append(" OR ");
            }
            sb.append(" ) AND ");
        }
        if (this.cso != null) {
            if (this.cso.isEmailAutoComplete() || this.cso.isOrSearch()) {
                this.search_habit = " OR ";
            }
            sb.append(" ( ");
            if (" OR ".equals(this.search_habit)) {
                ArrayList<String> whereClauses = new ArrayList<String>(16);
                String preWhere = sb.toString();
                int preWhereLen = preWhere.length();
                for (SearchFiller searchFiller : SEARCH_FILLERS) {
                    sb.setLength(0);
                    sb.append(preWhere);
                    int field = searchFiller.fillSearchCriteria(this, sb, false);
                    int sbLen = sb.length();
                    if (sbLen - preWhereLen <= 1) continue;
                    this.appendixWithCSO(sb, field, true);
                    whereClauses.add(sb.toString());
                }
                if (whereClauses.isEmpty()) {
                    this.appendixWithCSO(sb, -1, false);
                    this.where = new String[]{sb.toString()};
                } else {
                    this.where = whereClauses.toArray(new String[whereClauses.size()]);
                }
            } else {
                for (SearchFiller searchFiller : SEARCH_FILLERS) {
                    searchFiller.fillSearchCriteria(this, sb, true);
                }
                this.appendixWithCSO(sb, -1, false);
                this.where = new String[]{sb.toString()};
            }
        } else {
            this.appendix(sb);
            this.where = new String[]{sb.toString()};
        }
        return this.where;
    }

    private void appendixWithCSO(StringBuilder sb, int field, boolean union) {
        int pos;
        if (this.cso.getIgnoreOwn() > 0) {
            sb.append("( co.intfield01 != ").append(this.cso.getIgnoreOwn()).append(") ").append(this.search_habit).append(' ');
        }
        if ((pos = ContactMySql.endsWith(sb, "(", true)) == -1) {
            int pos2 = ContactMySql.endsWith(sb, this.search_habit, true);
            if (pos2 != -1) {
                sb.delete(pos2, sb.length());
            }
            sb.append(") AND ");
        } else {
            sb.delete(pos, sb.length());
        }
        String allFolderSQLINString = this.cso.getAllFolderSQLINString();
        if (null != allFolderSQLINString) {
            this.folder = -1;
            sb.append(allFolderSQLINString);
            sb.append(" AND ");
        }
        if (union) {
            if (this.cso.isEmailAutoComplete() && Arrays.binarySearch(AUTOCOMPLETE_FIELDS, field) >= 0) {
                sb.append('(');
                sb.append(Contacts.mapping[field].getDBFieldName());
                sb.append(" is not null OR ");
                sb.append(Contacts.mapping[602].getDBFieldName());
                sb.append(" > 0) AND ");
            }
        } else if (this.cso.isEmailAutoComplete()) {
            sb.append('(');
            sb.append(Contacts.mapping[555].getDBFieldName());
            sb.append(" is not null OR ");
            sb.append(Contacts.mapping[556].getDBFieldName());
            sb.append(" is not null OR ");
            sb.append(Contacts.mapping[557].getDBFieldName());
            sb.append(" is not null OR ");
            sb.append(Contacts.mapping[602].getDBFieldName());
            sb.append(" > 0) AND ");
        }
        this.appendix(sb);
    }

    private void appendix(StringBuilder sb) {
        if (this.folder != 0 && this.folder != -1) {
            sb.append(" (co.fid = ").append(this.folder).append(") AND ");
        }
        sb.append(' ');
        int pos = ContactMySql.endsWith(sb, "AND", true);
        if (pos != -1) {
            sb.delete(pos, sb.length());
        }
        sb.append(" AND ((co.pflag = 1 and co.created_from = ").append(this.user).append(") OR (co.pflag is null))");
    }

    @Override
    public String getSelect() {
        return this.select;
    }

    @Override
    public void setSelect(String select) {
        this.select = select;
    }

    @Override
    public void setOrder(String order) {
        this.order = order;
    }

    @Override
    public void setFolder(int folder) {
        this.folder = folder;
    }

    @Override
    public void setObjectID(int objectID) {
        this.objectID = objectID;
    }

    @Override
    public void setReadOnlyOwnFolder(int onlyown) {
        this.can_read_only_own = onlyown;
    }

    @Override
    public void setContactSearchObject(ContactSearchObject cso) {
        this.cso = cso;
    }

    @Override
    public void setObjectArray(int[][] object_id) {
        this.object_id_array = new int[object_id.length][];
        for (int i = 0; i < object_id.length; ++i) {
            this.object_id_array[i] = new int[object_id[i].length];
            System.arraycopy(object_id[i], 0, this.object_id_array[i], 0, object_id[i].length);
        }
    }

    @Override
    public void getInternalUsers() {
        this.internal_user_only = true;
    }

    @Override
    public void setInternalUser(int userid) {
        this.userid = userid;
    }

    @Override
    public void setInternalUsers(int[] userIds) {
        this.where = null;
        this.userIds = userIds;
    }

    @Override
    public void setSearchHabit(String habit) {
        this.search_habit = habit;
    }

    @Override
    public void getAllChangedSince(long chs) {
        this.changed_since = chs;
    }

    @Override
    public void getAllCreatedSince(long crs) {
        this.created_since = crs;
    }

    @Override
    public void getAllSince(long bs) {
        this.both_since = bs;
    }

    @Override
    public String buildContactSelectString(int[] cols) {
        StringBuilder sb = new StringBuilder();
        for (int a = 0; a < cols.length; ++a) {
            Contacts.Mapper m = Contacts.mapping[cols[a]];
            if (m == null) {
                if (!DEBUG) continue;
                LOG.debug((Object)("UNKNOWN FIELD -> " + cols[a]));
                continue;
            }
            sb.append("co.").append(m.getDBFieldName()).append(',');
        }
        int len = sb.length();
        return len > 0 ? sb.toString().substring(0, len - 1) : sb.toString();
    }

    @Override
    public String getRangeSearch(String field, String a, String b, String sh) {
        StringBuilder sb = new StringBuilder(32);
        String von = "*";
        String bis = "*";
        if (a != null && a.length() > 0 && !a.equals("*")) {
            von = a;
        }
        if (b != null && b.length() > 0 && !b.equals("*")) {
            bis = b;
        }
        if (!"*".equals(von)) {
            sb.append("co.").append(field).append(" >= ? ").append(sh).append(' ');
            this.injectors.add(new StringSQLInjector(von));
        }
        if (!"*".equals(bis)) {
            sb.append("co.").append(field).append(" <= ? ").append(sh).append(' ');
            this.injectors.add(new StringSQLInjector(bis));
        }
        return sb.toString();
    }

    @Override
    public String buildAllFolderSearchString(int user, int[] group, Session so) throws OXException, SearchIteratorException {
        UserConfiguration config = UserConfigurationStorage.getInstance().getUserConfiguration(user, this.ctx);
        List<FolderObject> list = ((FolderObjectIterator)OXFolderIteratorSQL.getAllVisibleFoldersIteratorOfModule(user, group, config.getAccessibleModules(), 3, this.ctx)).asList();
        int size = list.size();
        int[] folders2 = new int[size];
        for (int i = 0; i < size; ++i) {
            folders2[i] = list.get(i).getObjectID();
        }
        return this.buildFolderSearch(user, group, folders2, so);
    }

    @Override
    public String buildFolderSearch(int user, int[] group, int[] folders2, Session so) throws OXException {
        UserConfiguration config = UserConfigurationStorage.getInstance().getUserConfiguration(user, this.ctx);
        StringBuilder read_all = new StringBuilder();
        StringBuilder read_own = new StringBuilder();
        OXFolderAccess ofa = new OXFolderAccess(this.ctx);
        for (int folder : folders2) {
            EffectivePermission oclp = ofa.getFolderPermission(folder, user, config);
            if (oclp.canReadAllObjects()) {
                read_all.append(folder).append(',');
                continue;
            }
            if (!oclp.canReadOwnObjects()) continue;
            read_own.append(folder).append(',');
        }
        if (read_all.length() > 0) {
            read_all.deleteCharAt(read_all.length() - 1);
        }
        if (read_own.length() > 0) {
            read_own.deleteCharAt(read_own.length() - 1);
        }
        StringBuilder result = new StringBuilder();
        result.append('(');
        if (read_all.length() > 0) {
            result.append("(co.fid IN (");
            result.append((CharSequence)read_all);
            result.append("))");
        }
        if (read_all.length() > 0 && read_own.length() > 0) {
            result.append(" OR ");
        }
        if (read_own.length() > 0) {
            result.append("(co.fid IN (");
            result.append((CharSequence)read_own);
            result.append(") AND co.created_from=");
            result.append(user);
            result.append(')');
        }
        if (read_all.length() == 0 && read_own.length() == 0) {
            result.append("false");
        }
        result.append(')');
        return result.toString();
    }

    @Override
    public String iFgetRightsSelectString() {
        return rightsSelectString;
    }

    @Override
    public String iFgetFolderSelectString(int fid, int cid) {
        return rightsSelectString + " where fid = " + fid + " AND cid = " + cid;
    }

    @Override
    public String iFgetNumberOfContactsString() {
        return "SELECT COUNT(co.intfield01) FROM prg_contacts AS co ";
    }

    @Override
    public String iFgetRightsSelectString(int uid, int cid) {
        return rightsSelectString + " where created_from = " + uid + " AND cid = " + cid;
    }

    @Override
    public String iFcontainsForeignObjectInFolder(int fid, int uid, int cid) {
        return " SELECT intfield01 FROM prg_contacts where fid = " + fid + " AND cid = " + cid + " AND created_from != " + uid + " AND ((pflag = 1 and created_from != " + uid + ") OR (pflag is null))";
    }

    @Override
    public String iFdeleteDistributionListEntriesByIds(int cid) {
        return "DELETE FROM prg_dlist where intfield01 = ? AND intfield02 IS NULL AND intfield03 IS NULL AND cid = " + cid;
    }

    @Override
    public String iFfillDistributionListArray(int id, int cid) {
        return "Select intfield01, intfield02, intfield03, intfield04, field01, field02, field03, field04 from prg_dlist where intfield01 = " + id + " AND cid = " + cid;
    }

    @Override
    public String iFwriteDistributionListArrayInsert() {
        return "INSERT INTO prg_dlist (intfield01, intfield02, intfield03, field01, field02, field03, field04, cid, intfield04) VALUES (?,?,?,?,?,?,?,?,?)";
    }

    @Override
    public String iFupdateDistributionListEntriesByIds() {
        return "UPDATE prg_dlist set intfield01 = ?, intfield02 = ?, intfield03 = ?, intfield04 = ?, field01 = ?, field02 = ?, field03 = ?, field04 = ? WHERE (intfield01 = ?) AND (intfield02 = ?) AND (intfield03 = ?) AND (cid = ?)";
    }

    @Override
    public String iFdeleteDistributionListEntriesByIds2() {
        return "DELETE FROM prg_dlist where intfield01 = ? AND intfield02 = ? AND intfield03 = ? AND  cid = ?";
    }

    @Override
    public String iFgetFillLinkArrayString(int id, int cid) {
        return "Select intfield01, intfield02, field01, field02 from prg_contacts_linkage where intfield01 = " + id + " AND cid = " + cid;
    }

    @Override
    public String iFwriteContactLinkArrayInsert() {
        return "INSERT INTO prg_contacts_linkage (intfield01, intfield02, field01, field02, cid) VALUES (?,?,?,?,?)";
    }

    @Override
    public String iFgetdeleteLinkEntriesByIdsString() {
        return "DELETE FROM prg_contacts_linkage where intfield01 = ? AND intfield02 = ? AND cid = ?";
    }

    @Override
    public String iFgetContactImageLastModified(int id, int cid) {
        return "SELECT changing_date from prg_contacts_image WHERE intfield01 = " + id + " AND cid = " + cid;
    }

    @Override
    public String iFgetContactImageContentType(int id, int cid) {
        return "SELECT mime_type from prg_contacts_image WHERE intfield01 = " + id + " AND cid = " + cid;
    }

    @Override
    public String iFgetContactImage(int contact_id, int cid) {
        return "SELECT image1, changing_date, mime_type  from prg_contacts_image WHERE intfield01 = " + contact_id + " AND cid = " + cid;
    }

    @Override
    public String iFwriteContactImage() {
        return "INSERT INTO prg_contacts_image (intfield01, image1, mime_type, cid, changing_date) VALUES (?,?,?,?,?)";
    }

    @Override
    public String iFupdateContactImageString() {
        return "UPDATE prg_contacts_image SET intfield01 = ?, image1 = ?, mime_type = ?, cid = ?, changing_date = ? WHERE intfield01 = ? AND cid = ? ";
    }

    @Override
    public StringBuilder iFperformContactStorageInsert(StringBuilder insert_fields, StringBuilder insert_values, int user, long lmd, int cid, int id) {
        StringBuilder insert = new StringBuilder("INSERT INTO prg_contacts (").append((CharSequence)insert_fields).append("created_from,").append("changed_from,").append("creating_date,").append("changing_date,").append("intfield01,").append("cid ").append(") VALUES ( ").append(insert_values.toString()).append(user).append(',').append(user).append(',').append(lmd).append(',').append(lmd).append(',').append(id).append(',').append(cid).append(") ");
        return insert;
    }

    @Override
    public StringBuilder iFperformOverridingContactStorageInsert(StringBuilder insert_fields, StringBuilder insert_values, int user, long lmd, int cid, int id) {
        StringBuilder insert = new StringBuilder("INSERT IGNORE INTO prg_contacts (").append((CharSequence)insert_fields).append("created_from,").append("changed_from,").append("creating_date,").append("changing_date,").append("intfield01,").append("cid ").append(") VALUES ( ").append(insert_values.toString()).append(user).append(',').append(user).append(',').append(lmd).append(',').append(lmd).append(',').append(id).append(',').append(cid).append(") ");
        return insert;
    }

    @Override
    public StringBuilder iFperformContactStorageUpdate(StringBuilder update, long lmd, int id, int cid) {
        StringBuilder updater = new StringBuilder("UPDATE prg_contacts SET ").append((CharSequence)update).append("changed_from = ").append(this.user).append(',').append("changing_date =  ").append(lmd).append(" WHERE intfield01 = ").append(id).append(" AND cid = ").append(cid);
        return updater;
    }

    @Override
    public StringBuilder iFgetContactById(String fieldList) {
        StringBuilder sb = new StringBuilder("SELECT ").append(fieldList);
        sb.append(" from prg_contacts AS co ");
        return sb;
    }

    @Override
    public String iFdeleteContactObject(int oid, int cid) {
        return "SELECT fid, created_from, changing_date, pflag from prg_contacts where intfield01 = " + oid + " AND cid = " + cid;
    }

    @Override
    public StringBuilder iFgetColsStringFromDeleteTable(int[] cols) {
        String fields = this.buildContactSelectString(cols);
        int len = fields.length();
        StringBuilder sb = new StringBuilder(len + 256).append("SELECT ");
        sb.append(PREFIXED_FIELDS);
        if (len > 0) {
            sb.append(',').append(fields);
        }
        sb.append(" FROM del_contacts AS co ");
        return sb;
    }

    @Override
    public StringBuilder iFgetColsString(int[] cols) {
        String fields = this.buildContactSelectString(cols);
        int len = fields.length();
        StringBuilder sb = new StringBuilder(len + 256).append("SELECT ");
        sb.append(PREFIXED_FIELDS);
        if (len > 0) {
            sb.append(',').append(fields);
        }
        sb.append(" FROM prg_contacts AS co ");
        return sb;
    }

    @Override
    public void iFdeleteContact(int id, int cid, Statement del) throws SQLException {
        StringBuilder tmp = new StringBuilder(256);
        tmp.append("DELETE FROM del_contacts WHERE cid = ").append(cid).append(" AND intfield01 = ").append(id);
        if (DEBUG) {
            LOG.debug((Object)tmp.toString());
        }
        del.execute(tmp.toString());
        tmp.setLength(0);
        tmp.append("INSERT INTO del_contacts SELECT * FROM prg_contacts WHERE intfield01 = ").append(id).append(" AND  cid = ").append(cid);
        if (DEBUG) {
            LOG.debug((Object)tmp.toString());
        }
        del.execute(tmp.toString());
        tmp.setLength(0);
        tmp.append("DELETE FROM prg_contacts WHERE cid = ").append(cid).append(" AND intfield01 = ").append(id);
        if (DEBUG) {
            LOG.debug((Object)tmp.toString());
        }
        del.execute(tmp.toString());
        tmp.setLength(0);
        tmp.append("DELETE FROM prg_dlist WHERE cid = ").append(cid).append("  AND intfield03 IS NOT NULL AND intfield03 <> 0 AND intfield02 IS NOT NULL AND intfield02 = ").append(id);
        if (DEBUG) {
            LOG.debug((Object)tmp.toString());
        }
        del.execute(tmp.toString());
        tmp.setLength(0);
        tmp.append("DELETE FROM del_dlist WHERE cid = ").append(cid).append("  AND intfield03 IS NOT NULL AND intfield03 <> 0 AND intfield02 IS NOT NULL AND intfield02 = ").append(id);
        if (DEBUG) {
            LOG.debug((Object)tmp.toString());
        }
        del.execute(tmp.toString());
        tmp.setLength(0);
        tmp.append("UPDATE del_contacts SET changing_date = ").append(System.currentTimeMillis()).append(" WHERE cid = ").append(cid).append(" AND intfield01 = ").append(id);
        if (DEBUG) {
            LOG.debug((Object)tmp.toString());
        }
        del.execute(tmp.toString());
    }

    @Override
    public void iFtrashContactsFromFolder(boolean deleteit, Statement del, int oid, int cid) throws SQLException {
        StringBuilder tmp = new StringBuilder(256);
        if (deleteit) {
            tmp.append("DELETE FROM prg_contacts WHERE cid = ").append(cid).append(" AND intfield01 = ").append(oid);
            if (DEBUG) {
                LOG.debug((Object)tmp.toString());
            }
            del.execute(tmp.toString());
        } else {
            tmp.append("DELETE FROM del_contacts WHERE cid = ").append(cid).append(" AND intfield01 = ").append(oid);
            if (DEBUG) {
                LOG.debug((Object)tmp.toString());
            }
            del.execute(tmp.toString());
            tmp.setLength(0);
            tmp.append("INSERT INTO del_contacts SELECT * FROM prg_contacts WHERE intfield01 = ").append(oid).append(" AND  cid = ").append(cid);
            if (DEBUG) {
                LOG.debug((Object)tmp.toString());
            }
            del.execute(tmp.toString());
            tmp.setLength(0);
            tmp.append("DELETE FROM prg_contacts WHERE cid = ").append(cid).append(" AND intfield01 = ").append(oid);
            if (DEBUG) {
                LOG.debug((Object)tmp.toString());
            }
            del.execute(tmp.toString());
        }
        tmp.setLength(0);
        tmp.append("DELETE FROM prg_dlist WHERE cid = ").append(cid).append("  AND intfield03 IS NOT NULL AND intfield03 <> 0 AND intfield02 IS NOT NULL AND intfield02 = ").append(oid);
        if (DEBUG) {
            LOG.debug((Object)tmp.toString());
        }
        del.execute(tmp.toString());
        tmp.setLength(0);
        tmp.append("DELETE FROM del_dlist WHERE cid = ").append(cid).append("  AND intfield03 IS NOT NULL AND intfield03 <> 0 AND intfield02 IS NOT NULL AND intfield02 = ").append(oid);
        if (DEBUG) {
            LOG.debug((Object)tmp.toString());
        }
        del.execute(tmp.toString());
    }

    @Override
    public void iFbackupContact(Statement stmt, int cid, int oid, int uid) throws SQLException {
        StringBuilder tmp = new StringBuilder(256);
        tmp.append("DELETE FROM del_contacts WHERE cid = ").append(cid).append(" AND intfield01 = ").append(oid);
        if (DEBUG) {
            LOG.debug((Object)tmp.toString());
        }
        stmt.execute(tmp.toString());
        tmp.setLength(0);
        tmp.append("INSERT INTO del_contacts SELECT * FROM prg_contacts WHERE intfield01 = ").append(oid).append(" AND  cid = ").append(cid);
        if (DEBUG) {
            LOG.debug((Object)tmp.toString());
        }
        stmt.execute(tmp.toString());
        tmp.setLength(0);
        tmp.append("UPDATE del_contacts SET changing_date = ").append(System.currentTimeMillis()).append(", changed_from = ").append(uid).append(" WHERE cid = ").append(cid).append(" AND intfield01 = ").append(oid);
        if (DEBUG) {
            LOG.debug((Object)tmp.toString());
        }
        stmt.execute(tmp.toString());
    }

    @Override
    public String iFtrashContactsFromFolderUpdateString(int fid, int cid) {
        return "UPDATE del_contacts SET changing_date = " + System.currentTimeMillis() + " WHERE cid = " + cid + " AND fid = " + fid;
    }

    @Override
    public void iFtrashDistributionList(boolean delete, int id, int cid, Statement smt) throws SQLException {
        if (delete) {
            if (DEBUG) {
                LOG.debug((Object)new StringBuilder("DELETE from prg_dlist where intfield01 = ").append(id).append(" AND cid = ").append(cid));
            }
            smt.execute("DELETE from prg_dlist where intfield01 = " + id + " AND cid = " + cid);
        } else {
            StringBuilder sb = new StringBuilder(256);
            sb.append("DELETE FROM del_dlist WHERE cid = ").append(cid).append(" AND intfield01 = ").append(id);
            if (DEBUG) {
                LOG.debug((Object)sb.toString());
            }
            smt.execute(sb.toString());
            sb.setLength(0);
            sb.append("INSERT INTO del_dlist SELECT * FROM prg_dlist WHERE intfield01 = ").append(id).append(" AND  cid = ").append(cid);
            if (DEBUG) {
                LOG.debug((Object)sb.toString());
            }
            smt.execute(sb.toString());
            sb.setLength(0);
            sb.append("DELETE FROM prg_dlist WHERE cid = ").append(cid).append(" AND intfield01 = ").append(id);
            if (DEBUG) {
                LOG.debug((Object)sb.toString());
            }
            smt.execute(sb.toString());
        }
    }

    @Override
    public void iFtrashLinks(boolean delete, Statement smt, int id, int cid) throws SQLException {
        StringBuilder tmp = new StringBuilder("DELETE from prg_contacts_linkage where (intfield01 = ").append(id).append(" OR intfield02 = ").append(id).append(") AND cid = ").append(cid);
        if (DEBUG) {
            LOG.debug((Object)tmp.toString());
        }
        smt.execute(tmp.toString());
    }

    @Override
    public void iFgiveUserContacToAdmin(Statement smt, int oid, int admin_fid, Context ct) throws SQLException {
        StringBuilder tmp = new StringBuilder("UPDATE prg_contacts SET changed_from = ").append(ct.getMailadmin()).append(", created_from = ").append(ct.getMailadmin()).append(", changing_date = ").append(System.currentTimeMillis()).append(", fid = ").append(admin_fid).append(" WHERE intfield01 = ").append(oid).append(" and cid = ").append(ct.getContextId());
        if (DEBUG) {
            LOG.debug((Object)tmp.toString());
        }
        smt.execute(tmp.toString());
    }

    @Override
    public void iFtrashImage(boolean delete, Statement smt, int id, int cid) throws SQLException {
        if (delete) {
            StringBuilder tmp = new StringBuilder("DELETE from prg_contacts_image where intfield01 = ").append(id).append(" AND cid = ").append(cid);
            if (DEBUG) {
                LOG.debug((Object)tmp.toString());
            }
            smt.execute(tmp.toString());
        } else {
            StringBuilder tmp = new StringBuilder(256);
            tmp.append("DELETE from del_contacts_image where intfield01 = ").append(id).append(" AND cid = ").append(cid);
            if (DEBUG) {
                LOG.debug((Object)tmp.toString());
            }
            smt.execute(tmp.toString());
            tmp.setLength(0);
            tmp.append("INSERT INTO del_contacts_image SELECT * FROM prg_contacts_image WHERE intfield01 = ").append(id).append(" AND  cid = ").append(cid);
            if (DEBUG) {
                LOG.debug((Object)tmp.toString());
            }
            smt.execute(tmp.toString());
            tmp.setLength(0);
            tmp.append("DELETE from prg_contacts_image where intfield01 = ").append(id).append(" AND cid = ").append(cid);
            if (DEBUG) {
                LOG.debug((Object)tmp.toString());
            }
            smt.execute(tmp.toString());
        }
    }

    @Override
    public void iFtrashAllUserContacts(boolean delete, Statement del, int cid, int oid, int uid, ResultSet rs, Session so) throws SQLException {
        StringBuilder tmp = new StringBuilder(256);
        if (delete) {
            tmp.append("DELETE from prg_dlist where intfield01 = ").append(oid).append(" AND cid = ").append(cid);
            if (DEBUG) {
                LOG.debug((Object)tmp.toString());
            }
            del.execute(tmp.toString());
            tmp.setLength(0);
            tmp.append("DELETE from prg_contacts_linkage where (intfield01 = ").append(oid).append(" OR intfield02 = ").append(oid).append(") AND cid = ").append(cid);
            if (DEBUG) {
                LOG.debug((Object)tmp.toString());
            }
            del.execute(tmp.toString());
            tmp.setLength(0);
            tmp.append("DELETE from prg_contacts_image where intfield01 = ").append(oid).append(" AND cid = ").append(cid);
            if (DEBUG) {
                LOG.debug((Object)tmp.toString());
            }
            del.execute(tmp.toString());
            tmp.setLength(0);
            tmp.append("DELETE from prg_contacts WHERE cid = ").append(cid).append(" AND intfield01 = ").append(oid);
            if (DEBUG) {
                LOG.debug((Object)tmp.toString());
            }
            del.execute(tmp.toString());
        } else {
            tmp.append("UPDATE prg_contacts SET changed_from = ").append(this.ctx.getMailadmin()).append(", created_from = ").append(this.ctx.getMailadmin()).append(", changing_date = ").append(System.currentTimeMillis()).append(" WHERE intfield01 = ").append(oid).append(" AND cid = ").append(cid);
            if (DEBUG) {
                LOG.debug((Object)tmp.toString());
            }
            del.execute(tmp.toString());
        }
    }

    @Override
    public void iFtrashAllUserContactsDeletedEntries(Statement del, int cid, int uid, Context ct) throws SQLException {
        StringBuilder tmp = new StringBuilder("UPDATE del_contacts SET changed_from = ").append(this.ctx.getMailadmin()).append(", created_from = ").append(this.ctx.getMailadmin()).append(", changing_date = ").append(System.currentTimeMillis()).append(" WHERE created_from = ").append(uid).append(" and cid = ").append(cid);
        if (DEBUG) {
            LOG.debug((Object)tmp.toString());
        }
        del.execute(tmp.toString());
    }

    @Override
    public void iFtrashAllUserContactsDeletedEntriesFromAdmin(Statement del, int cid, int uid) throws SQLException {
        StringBuilder tmp = new StringBuilder("DELETE FROM del_contacts WHERE created_from = ").append(uid).append(" and cid = ").append(cid);
        if (DEBUG) {
            LOG.debug((Object)tmp.toString());
        }
        del.execute(tmp.toString());
    }

    @Override
    public void iFtrashTheAdmin(Statement del, int cid, int uid) throws SQLException {
        StringBuilder tmp = new StringBuilder("DELETE FROM del_contacts WHERE intfield01 = ").append(uid).append(" and cid = ").append(cid);
        if (DEBUG) {
            LOG.debug((Object)tmp.toString());
        }
        del.execute(tmp.toString());
    }

    static int endsWith(StringBuilder stringBuilder, String suffix, boolean ignoreTrailingWhitespaces) {
        int pos = stringBuilder.lastIndexOf(suffix);
        if (pos == -1) {
            return -1;
        }
        int len = stringBuilder.length();
        if (ignoreTrailingWhitespaces) {
            for (int i = pos + suffix.length(); i < len; ++i) {
                if (Strings.isWhitespace((char)stringBuilder.charAt(i))) continue;
                return -1;
            }
            return pos;
        }
        return pos + suffix.length() == len ? pos : -1;
    }

    static void removeMultipleTrailingWhitespaces(StringBuilder stringBuilder) {
        int pos;
        int length = stringBuilder.length();
        for (pos = length - 1; pos > 0 && Strings.isWhitespace((char)stringBuilder.charAt(pos)); --pos) {
        }
        if (pos < length - 1) {
            stringBuilder.delete(pos + 1, length);
        }
    }

    static {
        ArrayList<SearchFiller> searchFillers = new ArrayList<SearchFiller>(32);
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getPattern() != null && cso.getPattern().length() > 0) {
                    if (cso.isStartLetter()) {
                        String field = ContactConfig.getInstance().getString(ContactConfig.Property.LETTER_FIELD);
                        String p = cso.getPattern().trim();
                        String dot = ".";
                        if (".".equals(p) || "#".equals(p)) {
                            sb.append(" (");
                            sb.append(field);
                            sb.append(" < '0%' OR ");
                            sb.append(field);
                            sb.append(" > 'z%') AND ");
                            sb.append(field);
                            sb.append(" NOT LIKE 'z%' AND ");
                        } else if (p.matches("\\d")) {
                            sb.append(' ');
                            sb.append(field);
                            sb.append(" > '0%' AND ");
                            sb.append(field);
                            sb.append(" < 'a%' AND ");
                        } else if (!".".equals(p) && !"all".equals(p)) {
                            String fallbackField = Contacts.mapping[500].getDBFieldName();
                            sb.append(' ');
                            sb.append('(').append(field).append(" IS NOT ? AND ").append(field).append(" LIKE ?)");
                            sb.append(" OR (").append(field).append(" IS ? AND ").append(fallbackField).append(" LIKE ?)");
                            sb.append(" AND ");
                            List injectors = instance.injectors;
                            injectors.add(new StringSQLInjector());
                            injectors.add(new StringSQLInjector(p, ContactMySql.STR_PERCENT));
                            injectors.add(new StringSQLInjector());
                            injectors.add(new StringSQLInjector(p, ContactMySql.STR_PERCENT));
                        }
                    } else {
                        cso.setDisplayName(cso.getPattern());
                    }
                }
                return -1;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getDynamicSearchField() != null && cso.getDynamicSearchField().length > 0) {
                    int pos2;
                    String searchHabit = instance.search_habit;
                    List injectors = instance.injectors;
                    int[] fields = cso.getDynamicSearchField();
                    String[] values = cso.getDynamicSearchFieldValue();
                    boolean modified = false;
                    for (int i = 0; i < fields.length; ++i) {
                        String value;
                        String field;
                        if (fields[i] == 517 || fields[i] == 511) {
                            field = "";
                            if (fields[i] == 517) {
                                field = Contacts.mapping[517].getDBFieldName();
                            } else if (fields[i] == 511) {
                                field = Contacts.mapping[511].getDBFieldName();
                            }
                            value = values[i];
                            sb.append(" ( co.").append(field).append(" LIKE ").append(value).append(") ").append(searchHabit).append(' ');
                            modified = true;
                            continue;
                        }
                        if (fields[i] == 594 || fields[i] == 103) {
                            field = "";
                            if (fields[i] == 594) {
                                field = Contacts.mapping[594].getDBFieldName();
                            } else if (fields[i] == 103) {
                                field = Contacts.mapping[103].getDBFieldName();
                            }
                            value = values[i];
                            sb.append('(').append("co.").append(field).append(" = ").append(value).append(") ").append(searchHabit).append(' ');
                            modified = true;
                            continue;
                        }
                        if (fields[i] == 100) {
                            field = Contacts.mapping[100].getDBFieldName();
                            value = values[i];
                            if ("*".equals(value) || null == value) continue;
                            if ((value = StringCollection.prepareForSearch(value, false)).indexOf(44) == -1) {
                                sb.append('(').append("co.").append(field).append(" LIKE ?) ").append(searchHabit).append(' ');
                                injectors.add(new StringSQLInjector(ContactMySql.STR_PERCENT, value, ContactMySql.STR_PERCENT));
                                continue;
                            }
                            String[] tokens = value.trim().split("\\s*,\\s*");
                            sb.append('(');
                            sb.append(" ( co.").append(field).append(" LIKE ? )");
                            injectors.add(new StringSQLInjector(ContactMySql.STR_PERCENT, tokens[0].toUpperCase(), ContactMySql.STR_PERCENT));
                            for (int j = 1; j < tokens.length; ++j) {
                                sb.append(" OR").append(" ( co.").append(field).append(" LIKE ? )");
                                injectors.add(new StringSQLInjector(ContactMySql.STR_PERCENT, tokens[j].toUpperCase(), ContactMySql.STR_PERCENT));
                            }
                            sb.append(") ").append(searchHabit).append(' ');
                            modified = true;
                            continue;
                        }
                        field = Contacts.mapping[fields[i]].getDBFieldName();
                        value = values[i];
                        if ("*".equals(value)) continue;
                        value = StringCollection.prepareForSearch(value);
                        sb.append("( co.").append(field).append(" LIKE ? ) ").append(searchHabit).append(' ');
                        injectors.add(new StringSQLInjector(value));
                        modified = true;
                    }
                    if (modified && !isSingleSelect && (pos2 = ContactMySql.endsWith(sb, searchHabit, true)) != -1) {
                        sb.delete(pos2, sb.length());
                    }
                }
                return -1;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getAnniversaryRange() != null && cso.getAnniversaryRange().length > 0) {
                    String searchHabit = instance.search_habit;
                    List injectors = instance.injectors;
                    Date[] d = cso.getAnniversaryRange();
                    try {
                        String field = Contacts.mapping[517].getDBFieldName();
                        sb.append("co.").append(field).append(" >= ? ").append(searchHabit).append(' ');
                        sb.append("co.").append(field).append(" <= ? ");
                        if (isSingleSelect) {
                            sb.append(searchHabit).append(' ');
                        }
                        injectors.add(new TimestampSQLInjector(d[0]));
                        injectors.add(new TimestampSQLInjector(d[1]));
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Could not Format Anniversary Date for Range Search! ", (Throwable)e);
                    }
                }
                return 517;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getBirthdayRange() != null && cso.getBirthdayRange().length > 0) {
                    String searchHabit = instance.search_habit;
                    List injectors = instance.injectors;
                    Date[] d = cso.getBirthdayRange();
                    try {
                        String field = Contacts.mapping[511].getDBFieldName();
                        sb.append("co.").append(field).append(" >= ? ").append(searchHabit).append(' ');
                        sb.append("co.").append(field).append(" <= ? ");
                        if (isSingleSelect) {
                            sb.append(searchHabit).append(' ');
                        }
                        injectors.add(new TimestampSQLInjector(d[0]));
                        injectors.add(new TimestampSQLInjector(d[1]));
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Could not Format Birthday Date for Range Search! ", (Throwable)e);
                    }
                }
                return 511;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getBusinessPostalCodeRange() != null && cso.getBusinessPostalCodeRange().length > 0) {
                    int pos2;
                    String searchHabit = instance.search_habit;
                    String[] x = cso.getBusinessPostalCodeRange();
                    sb.append(instance.getRangeSearch(Contacts.mapping[525].getDBFieldName(), x[0], x[1], searchHabit));
                    if (!isSingleSelect && (pos2 = ContactMySql.endsWith(sb, searchHabit, true)) != -1) {
                        sb.delete(pos2, sb.length());
                    }
                }
                return 525;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getCreationDateRange() != null && cso.getCreationDateRange().length > 0) {
                    String searchHabit = instance.search_habit;
                    List injectors = instance.injectors;
                    Date[] d = cso.getCreationDateRange();
                    try {
                        String field = Contacts.mapping[4].getDBFieldName();
                        sb.append("co.").append(field).append(" >= ? ").append(searchHabit).append(' ');
                        sb.append("co.").append(field).append(" <= ? ");
                        if (isSingleSelect) {
                            sb.append(searchHabit).append(' ');
                        }
                        injectors.add(new TimestampSQLInjector(d[0]));
                        injectors.add(new TimestampSQLInjector(d[1]));
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Could not Format Creating_Date Date for Range Search! ", (Throwable)e);
                    }
                }
                return 4;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getLastModifiedRange() != null && cso.getLastModifiedRange().length > 0) {
                    String searchHabit = instance.search_habit;
                    List injectors = instance.injectors;
                    Date[] d = cso.getLastModifiedRange();
                    try {
                        String field = Contacts.mapping[5].getDBFieldName();
                        sb.append("co.").append(field).append(" >= ? ").append(searchHabit).append(' ');
                        sb.append("co.").append(field).append(" <= ? ");
                        if (isSingleSelect) {
                            sb.append(searchHabit).append(' ');
                        }
                        injectors.add(new TimestampSQLInjector(d[0]));
                        injectors.add(new TimestampSQLInjector(d[1]));
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Could not Format LastModified Date for Range Search! ", (Throwable)e);
                    }
                }
                return 5;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getNumberOfEmployeesRange() != null && cso.getNumberOfEmployeesRange().length > 0) {
                    int pos2;
                    String searchHabit = instance.search_habit;
                    String[] x = cso.getNumberOfEmployeesRange();
                    sb.append(instance.getRangeSearch(Contacts.mapping[529].getDBFieldName(), x[0], x[1], searchHabit));
                    if (!isSingleSelect && (pos2 = ContactMySql.endsWith(sb, searchHabit, true)) != -1) {
                        sb.delete(pos2, sb.length());
                    }
                }
                return 529;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getOtherPostalCodeRange() != null && cso.getOtherPostalCodeRange().length > 0) {
                    int pos2;
                    String searchHabit = instance.search_habit;
                    String[] x = cso.getOtherPostalCodeRange();
                    sb.append(instance.getRangeSearch(Contacts.mapping[540].getDBFieldName(), x[0], x[1], searchHabit));
                    if (!isSingleSelect && (pos2 = ContactMySql.endsWith(sb, searchHabit, true)) != -1) {
                        sb.delete(pos2, sb.length());
                    }
                }
                return 540;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getPrivatePostalCodeRange() != null && cso.getPrivatePostalCodeRange().length > 0) {
                    int pos2;
                    String searchHabit = instance.search_habit;
                    String[] x = cso.getPrivatePostalCodeRange();
                    sb.append(instance.getRangeSearch(Contacts.mapping[507].getDBFieldName(), x[0], x[1], searchHabit));
                    if (!isSingleSelect && (pos2 = ContactMySql.endsWith(sb, searchHabit, true)) != -1) {
                        sb.delete(pos2, sb.length());
                    }
                }
                return 507;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getSalesVolumeRange() != null && cso.getSalesVolumeRange().length > 0) {
                    int pos2;
                    String[] x = cso.getSalesVolumeRange();
                    String searchHabit = instance.search_habit;
                    sb.append(instance.getRangeSearch(Contacts.mapping[530].getDBFieldName(), x[0], x[1], searchHabit));
                    if (!isSingleSelect && (pos2 = ContactMySql.endsWith(sb, searchHabit, true)) != -1) {
                        sb.delete(pos2, sb.length());
                    }
                }
                return 530;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getGivenName() != null && cso.getGivenName().length() > 0) {
                    String searchHabit = instance.search_habit;
                    List injectors = instance.injectors;
                    String field = Contacts.mapping[501].getDBFieldName();
                    String value = StringCollection.prepareForSearch(cso.getGivenName());
                    if (ContactMySql.STR_PERCENT.equals(value)) {
                        sb.append(' ');
                    } else {
                        sb.append('(').append("co.").append(field).append(" LIKE ?) ");
                        if (isSingleSelect) {
                            sb.append(searchHabit).append(' ');
                            injectors.add(new StringSQLInjector(value));
                        } else {
                            value = StringCollection.prepareForSearch(cso.getGivenName(), false, true, true);
                            injectors.add(new StringSQLInjector(value));
                        }
                    }
                }
                return 501;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getYomiFirstName() != null && cso.getYomiFirstName().length() > 0) {
                    String searchHabit = instance.search_habit;
                    List injectors = instance.injectors;
                    String field = Contacts.mapping[610].getDBFieldName();
                    String value = StringCollection.prepareForSearch(cso.getYomiFirstName());
                    if (ContactMySql.STR_PERCENT.equals(value)) {
                        sb.append(' ');
                    } else {
                        sb.append('(').append("co.").append(field).append(" LIKE ?) ");
                        if (isSingleSelect) {
                            sb.append(searchHabit).append(' ');
                            injectors.add(new StringSQLInjector(value));
                        } else {
                            value = StringCollection.prepareForSearch(cso.getYomiFirstName(), false, true, true);
                            injectors.add(new StringSQLInjector(value));
                        }
                    }
                }
                return 610;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getSurname() != null && cso.getSurname().length() > 0) {
                    String searchHabit = instance.search_habit;
                    List injectors = instance.injectors;
                    String field = Contacts.mapping[502].getDBFieldName();
                    String value = StringCollection.prepareForSearch(cso.getSurname());
                    if (ContactMySql.STR_PERCENT.equals(value)) {
                        sb.append(' ');
                    } else {
                        sb.append('(').append("co.").append(field).append(" LIKE ?) ");
                        if (isSingleSelect) {
                            sb.append(searchHabit).append(' ');
                            injectors.add(new StringSQLInjector(value));
                        } else {
                            value = StringCollection.prepareForSearch(cso.getSurname(), false, true, true);
                            injectors.add(new StringSQLInjector(value));
                        }
                    }
                }
                return 502;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getYomiLastName() != null && cso.getYomiLastName().length() > 0) {
                    String searchHabit = instance.search_habit;
                    List injectors = instance.injectors;
                    String field = Contacts.mapping[611].getDBFieldName();
                    String value = StringCollection.prepareForSearch(cso.getYomiLastName());
                    if (ContactMySql.STR_PERCENT.equals(value)) {
                        sb.append(' ');
                    } else {
                        sb.append('(').append("co.").append(field).append(" LIKE ?) ");
                        if (isSingleSelect) {
                            sb.append(searchHabit).append(' ');
                            injectors.add(new StringSQLInjector(value));
                        } else {
                            value = StringCollection.prepareForSearch(cso.getYomiLastName(), false, true, true);
                            injectors.add(new StringSQLInjector(value));
                        }
                    }
                }
                return 611;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getDisplayName() != null && cso.getDisplayName().length() > 0) {
                    String searchHabit = instance.search_habit;
                    List injectors = instance.injectors;
                    String field = Contacts.mapping[500].getDBFieldName();
                    String value = StringCollection.prepareForSearch(cso.getDisplayName());
                    if (ContactMySql.STR_PERCENT.equals(value)) {
                        sb.append(' ');
                    } else {
                        sb.append('(').append("co.").append(field).append(" LIKE ?) ");
                        if (isSingleSelect) {
                            sb.append(searchHabit).append(' ');
                            injectors.add(new StringSQLInjector(value));
                        } else {
                            value = StringCollection.prepareForSearch(cso.getDisplayName(), false, true, true);
                            injectors.add(new StringSQLInjector(value));
                        }
                    }
                }
                return 500;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getEmail1() != null && cso.getEmail1().length() > 0) {
                    String searchHabit = instance.search_habit;
                    List injectors = instance.injectors;
                    String field = Contacts.mapping[555].getDBFieldName();
                    String value = StringCollection.prepareForSearch(cso.getEmail1());
                    if (ContactMySql.STR_PERCENT.equals(value)) {
                        sb.append(' ');
                    } else {
                        sb.append('(').append("co.").append(field).append(" LIKE ?) ");
                        if (isSingleSelect) {
                            sb.append(searchHabit).append(' ');
                            injectors.add(new StringSQLInjector(value));
                        } else {
                            value = StringCollection.prepareForSearch(cso.getEmail1(), false, true, true);
                            injectors.add(new StringSQLInjector(value));
                        }
                    }
                }
                return 555;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getEmail2() != null && cso.getEmail2().length() > 0) {
                    String searchHabit = instance.search_habit;
                    List injectors = instance.injectors;
                    String field = Contacts.mapping[556].getDBFieldName();
                    String value = StringCollection.prepareForSearch(cso.getEmail2());
                    if (ContactMySql.STR_PERCENT.equals(value)) {
                        sb.append(' ');
                    } else {
                        sb.append('(').append("co.").append(field).append(" LIKE ?) ");
                        if (isSingleSelect) {
                            sb.append(searchHabit).append(' ');
                            injectors.add(new StringSQLInjector(value));
                        } else {
                            value = StringCollection.prepareForSearch(cso.getEmail2(), false, true, true);
                            injectors.add(new StringSQLInjector(value));
                        }
                    }
                }
                return 556;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getEmail3() != null && cso.getEmail3().length() > 0) {
                    String searchHabit = instance.search_habit;
                    List injectors = instance.injectors;
                    String field = Contacts.mapping[557].getDBFieldName();
                    String value = StringCollection.prepareForSearch(cso.getEmail3());
                    if (ContactMySql.STR_PERCENT.equals(value)) {
                        sb.append(' ');
                    } else {
                        sb.append('(').append("co.").append(field).append(" LIKE ?) ");
                        if (isSingleSelect) {
                            sb.append(searchHabit).append(' ');
                            injectors.add(new StringSQLInjector(value));
                        } else {
                            value = StringCollection.prepareForSearch(cso.getEmail3(), false, true, true);
                            injectors.add(new StringSQLInjector(value));
                        }
                    }
                }
                return 557;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getCatgories() != null && cso.getCatgories().length() > 0) {
                    String searchHabit = instance.search_habit;
                    List injectors = instance.injectors;
                    String field = Contacts.mapping[100].getDBFieldName();
                    String value = cso.getCatgories().trim();
                    if (!"*".equals(value)) {
                        if ((value = StringCollection.prepareForSearch(value, false)).indexOf(44) == -1) {
                            sb.append('(').append("co.").append(field).append(" LIKE ?) ");
                            if (isSingleSelect) {
                                sb.append(searchHabit).append(' ');
                            }
                            injectors.add(new StringSQLInjector(ContactMySql.STR_PERCENT, value, ContactMySql.STR_PERCENT));
                        } else {
                            String[] tokens = value.split("\\s*,\\s*");
                            sb.append('(');
                            sb.append("( co.").append(field).append(" LIKE ? )");
                            injectors.add(new StringSQLInjector(ContactMySql.STR_PERCENT, tokens[0], ContactMySql.STR_PERCENT));
                            for (int i = 1; i < tokens.length; ++i) {
                                sb.append(" OR ").append("( co.").append(field).append(" LIKE ? )");
                                injectors.add(new StringSQLInjector(ContactMySql.STR_PERCENT, tokens[i], ContactMySql.STR_PERCENT));
                            }
                            sb.append(") ");
                            if (isSingleSelect) {
                                sb.append(searchHabit).append(' ');
                            }
                        }
                    }
                }
                return 100;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getCompany() != null && cso.getCompany().length() > 0) {
                    String searchHabit = instance.search_habit;
                    List injectors = instance.injectors;
                    String field = Contacts.mapping[569].getDBFieldName();
                    String value = StringCollection.prepareForSearch(cso.getCompany());
                    if (ContactMySql.STR_PERCENT.equals(value)) {
                        sb.append(' ');
                    } else {
                        sb.append("( co.").append(field).append(" LIKE ? ) ");
                        if (isSingleSelect) {
                            sb.append(searchHabit).append(' ');
                        }
                        injectors.add(new StringSQLInjector(value));
                    }
                }
                return 569;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getYomiCompany() != null && cso.getYomiCompany().length() > 0) {
                    String searchHabit = instance.search_habit;
                    List injectors = instance.injectors;
                    String field = Contacts.mapping[612].getDBFieldName();
                    String value = StringCollection.prepareForSearch(cso.getYomiCompany());
                    if (ContactMySql.STR_PERCENT.equals(value)) {
                        sb.append(' ');
                    } else {
                        sb.append("( co.").append(field).append(" LIKE ? ) ");
                        if (isSingleSelect) {
                            sb.append(searchHabit).append(' ');
                        }
                        injectors.add(new StringSQLInjector(value));
                    }
                }
                return 612;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getDepartment() != null && cso.getDepartment().length() > 0) {
                    String searchHabit = instance.search_habit;
                    List injectors = instance.injectors;
                    String field = Contacts.mapping[519].getDBFieldName();
                    String value = StringCollection.prepareForSearch(cso.getDepartment());
                    if (ContactMySql.STR_PERCENT.equals(value)) {
                        sb.append(' ');
                    } else {
                        sb.append("( co.").append(field).append(" LIKE ? ) ");
                        if (isSingleSelect) {
                            sb.append(searchHabit).append(' ');
                        }
                        injectors.add(new StringSQLInjector(value));
                    }
                }
                return 519;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getStreetBusiness() != null && cso.getStreetBusiness().length() > 0) {
                    String searchHabit = instance.search_habit;
                    List injectors = instance.injectors;
                    String field = Contacts.mapping[523].getDBFieldName();
                    String value = StringCollection.prepareForSearch(cso.getStreetBusiness());
                    if (ContactMySql.STR_PERCENT.equals(value)) {
                        sb.append(' ');
                    } else {
                        sb.append("( co.").append(field).append(" LIKE ? ) ");
                        if (isSingleSelect) {
                            sb.append(searchHabit).append(' ');
                        }
                        injectors.add(new StringSQLInjector(value));
                    }
                }
                return 523;
            }
        });
        searchFillers.add(new SearchFiller(){

            @Override
            public int fillSearchCriteria(ContactMySql instance, StringBuilder sb, boolean isSingleSelect) {
                ContactSearchObject cso = instance.cso;
                if (cso.getCityBusiness() != null && cso.getCityBusiness().length() > 0) {
                    String searchHabit = instance.search_habit;
                    List injectors = instance.injectors;
                    String field = Contacts.mapping[526].getDBFieldName();
                    String value = StringCollection.prepareForSearch(cso.getCityBusiness());
                    if (ContactMySql.STR_PERCENT.equals(value)) {
                        sb.append(' ');
                    } else {
                        sb.append("( co.").append(field).append(" LIKE ? ) ");
                        if (isSingleSelect) {
                            sb.append(searchHabit).append(' ');
                        }
                        injectors.add(new StringSQLInjector(value));
                    }
                }
                return 526;
            }
        });
        SEARCH_FILLERS = new CopyOnWriteArrayList<SearchFiller>(searchFillers);
    }

    private static interface SearchFiller {
        public int fillSearchCriteria(ContactMySql var1, StringBuilder var2, boolean var3);
    }
}

