/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.update;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.server.services.ServerServiceRegistry;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class AlterChangeExceptionFieldLength
implements UpdateTask {
    private static final String UPDATE_PRG_DATES = "ALTER TABLE prg_dates CHANGE COLUMN field08 field08 TEXT";
    private static final String UPDATE_DEL_DATES = "ALTER TABLE del_dates CHANGE COLUMN field08 field08 TEXT";

    @Override
    public int addedWithVersion() {
        return 56;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        block11: {
            Connection writecon = null;
            Statement stmt = null;
            try {
                writecon = Database.getNoTimeout(contextId, true);
                try {
                    stmt = writecon.createStatement();
                }
                catch (SQLException ex) {
                    throw OXCalendarExceptionCodes.UPDATE_EXCEPTION.create(ex.getMessage());
                }
                if (stmt == null) break block11;
                try {
                    stmt.executeUpdate(UPDATE_PRG_DATES);
                }
                catch (SQLException ex) {
                    throw OXCalendarExceptionCodes.UPDATE_EXCEPTION.create(ex.getMessage());
                }
                try {
                    stmt.executeUpdate(UPDATE_DEL_DATES);
                }
                catch (SQLException ex) {
                    throw OXCalendarExceptionCodes.UPDATE_EXCEPTION.create(ex.getMessage());
                }
            }
            finally {
                if (stmt != null) {
                    ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class).closeStatement(stmt);
                }
                if (writecon != null) {
                    Database.backNoTimeout(contextId, true, writecon);
                }
            }
        }
    }
}

