/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group.internal;

import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupStorage;
import com.openexchange.group.internal.GroupTools;
import com.openexchange.groupware.contexts.Context;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GroupsWithGroupZero
extends GroupStorage {
    private final GroupStorage delegate;
    private static final TIntSet SPECIALS = new TIntHashSet(new int[]{43, 40, 41, 91, 93, 36, 94, 46, 123, 125, 124, 92});

    public GroupsWithGroupZero(GroupStorage delegate) {
        this.delegate = delegate;
    }

    @Override
    public Group getGroup(int gid, Context ctx) throws OXException {
        Group retval = GroupTools.GROUP_ZERO.getIdentifier() == gid ? GroupTools.getGroupZero(ctx) : this.delegate.getGroup(gid, ctx);
        return retval;
    }

    @Override
    public Group[] getGroups(boolean loadMembers, Context ctx) throws OXException {
        Group[] groups = this.delegate.getGroups(loadMembers, ctx);
        Group[] retval = new Group[groups.length + 1];
        retval[0] = GroupTools.getGroupZero(ctx);
        System.arraycopy(groups, 0, retval, 1, groups.length);
        return retval;
    }

    @Override
    public Group[] listModifiedGroups(Date modifiedSince, Context ctx) throws OXException {
        Group[] groups = this.delegate.listModifiedGroups(modifiedSince, ctx);
        Group[] retval = new Group[groups.length + 1];
        retval[0] = GroupTools.getGroupZero(ctx);
        System.arraycopy(groups, 0, retval, 1, groups.length);
        return retval;
    }

    @Override
    public Group[] listDeletedGroups(Date modifiedSince, Context ctx) throws OXException {
        Group[] groups = this.delegate.listDeletedGroups(modifiedSince, ctx);
        Group[] retval = new Group[groups.length + 1];
        retval[0] = GroupTools.getGroupZero(ctx);
        System.arraycopy(groups, 0, retval, 1, groups.length);
        return retval;
    }

    @Override
    public Group[] searchGroups(String pattern, boolean loadMembers, Context ctx) throws OXException {
        Pattern pat = Pattern.compile(GroupsWithGroupZero.wildcardToRegex(pattern), 2);
        Group zero = GroupTools.getGroupZero(ctx);
        Matcher match = pat.matcher(zero.getDisplayName());
        ArrayList<Group> groups = new ArrayList<Group>();
        groups.addAll(Arrays.asList(this.delegate.searchGroups(pattern, loadMembers, ctx)));
        if (match.find()) {
            groups.add(zero);
        }
        return groups.toArray(new Group[groups.size()]);
    }

    @Override
    public void insertGroup(Context ctx, Connection con, Group group, GroupStorage.StorageType type) throws OXException {
        this.delegate.insertGroup(ctx, con, group, type);
    }

    @Override
    public void deleteMember(Context ctx, Connection con, Group group, int[] members) throws OXException {
        this.delegate.deleteMember(ctx, con, group, members);
    }

    @Override
    public void insertMember(Context ctx, Connection con, Group group, int[] members) throws OXException {
        this.delegate.insertMember(ctx, con, group, members);
    }

    @Override
    public void updateGroup(Context ctx, Connection con, Group group, Date lastRead) throws OXException {
        this.delegate.updateGroup(ctx, con, group, lastRead);
    }

    @Override
    public void deleteGroup(Context ctx, Connection con, int groupId, Date lastRead) throws OXException {
        this.delegate.deleteGroup(ctx, con, groupId, lastRead);
    }

    private static String wildcardToRegex(String wildcard) {
        if (null == wildcard) {
            return "^.*$";
        }
        if (wildcard.indexOf(42) < 0 && wildcard.indexOf(63) < 0) {
            return Pattern.quote(wildcard);
        }
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int len = wildcard.length();
        for (int i = 0; i < len; ++i) {
            char c = wildcard.charAt(i);
            if (c == '*') {
                s.append(".*");
                continue;
            }
            if (c == '?') {
                s.append('.');
                continue;
            }
            if (SPECIALS.contains((int)c)) {
                s.append('\\');
                s.append(c);
                continue;
            }
            s.append(c);
        }
        s.append('$');
        return s.toString();
    }
}

