/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.outlook.memory.impl;

import com.openexchange.folderstorage.outlook.memory.MemoryCRUD;
import com.openexchange.folderstorage.outlook.memory.MemoryFolder;
import com.openexchange.java.ConcurrentHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

final class MemoryCRUDImpl
implements MemoryCRUD {
    private final ConcurrentMap<String, MemoryFolder> folderMap;
    private final ConcurrentMap<String, Set<MemoryFolder>> parentMap;

    public MemoryCRUDImpl(ConcurrentMap<String, MemoryFolder> folderMap, ConcurrentMap<String, Set<MemoryFolder>> parentMap) {
        this.folderMap = folderMap;
        this.parentMap = parentMap;
    }

    @Override
    public MemoryFolder putIfAbsent(MemoryFolder folder) {
        return this.putIfAbsent(folder.getId(), folder);
    }

    @Override
    public MemoryFolder putIfAbsent(String folderId, MemoryFolder folder) {
        MemoryFolder prev = this.folderMap.putIfAbsent(folderId, folder);
        if (null == prev) {
            ConcurrentHashSet newset;
            String parentId = folder.getParentId();
            ConcurrentHashSet set = (ConcurrentHashSet)this.parentMap.get(parentId);
            if (null == set && null == (set = this.parentMap.putIfAbsent(parentId, (Set<MemoryFolder>)(newset = new ConcurrentHashSet())))) {
                set = newset;
            }
            set.add(folder);
        }
        return prev;
    }

    @Override
    public boolean containsFolder(String folderId) {
        return this.folderMap.containsKey(folderId);
    }

    @Override
    public MemoryFolder get(String folderId) {
        return (MemoryFolder)this.folderMap.get(folderId);
    }

    @Override
    public MemoryFolder put(MemoryFolder folder) {
        return this.put(folder.getId(), folder);
    }

    @Override
    public MemoryFolder put(String folderId, MemoryFolder folder) {
        ConcurrentHashSet newset;
        MemoryFolder ret = this.folderMap.put(folderId, folder);
        String parentId = folder.getParentId();
        ConcurrentHashSet set = (ConcurrentHashSet)this.parentMap.get(parentId);
        if (null == set && null == (set = this.parentMap.putIfAbsent(parentId, (Set<MemoryFolder>)(newset = new ConcurrentHashSet())))) {
            set = newset;
        }
        set.add(folder);
        return ret;
    }

    @Override
    public MemoryFolder remove(String folderId) {
        String parentId;
        Set set;
        MemoryFolder ret = (MemoryFolder)this.folderMap.remove(folderId);
        if (ret != null && null != (set = (Set)this.parentMap.get(parentId = ret.getParentId()))) {
            set.remove(ret);
        }
        return ret;
    }
}

