/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.outlook;

import com.openexchange.concurrent.TimeoutConcurrentMap;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.cascade.ConfigView;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.AccountAware;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageAccountAccess;
import com.openexchange.file.storage.FileStorageAccountManager;
import com.openexchange.file.storage.FileStorageAccountManagerLookupService;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.file.storage.WarningsAware;
import com.openexchange.file.storage.registry.FileStorageServiceRegistry;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.StorageParametersUtility;
import com.openexchange.folderstorage.StoragePriority;
import com.openexchange.folderstorage.StorageType;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.database.DatabaseFolderStorage;
import com.openexchange.folderstorage.database.DatabaseFolderType;
import com.openexchange.folderstorage.database.contentType.CalendarContentType;
import com.openexchange.folderstorage.database.contentType.ContactContentType;
import com.openexchange.folderstorage.database.contentType.TaskContentType;
import com.openexchange.folderstorage.filestorage.FileStorageFolderIdentifier;
import com.openexchange.folderstorage.filestorage.contentType.FileStorageContentType;
import com.openexchange.folderstorage.internal.StorageParametersImpl;
import com.openexchange.folderstorage.internal.Tools;
import com.openexchange.folderstorage.mail.MailFolderType;
import com.openexchange.folderstorage.mail.contentType.DraftsContentType;
import com.openexchange.folderstorage.mail.contentType.MailContentType;
import com.openexchange.folderstorage.mail.contentType.SentContentType;
import com.openexchange.folderstorage.mail.contentType.SpamContentType;
import com.openexchange.folderstorage.mail.contentType.TrashContentType;
import com.openexchange.folderstorage.messaging.MessagingFolderIdentifier;
import com.openexchange.folderstorage.outlook.OutlookFolder;
import com.openexchange.folderstorage.outlook.OutlookFolderStorageRegistry;
import com.openexchange.folderstorage.outlook.OutlookFolderType;
import com.openexchange.folderstorage.outlook.OutlookId;
import com.openexchange.folderstorage.outlook.OutlookServiceRegistry;
import com.openexchange.folderstorage.outlook.memory.MemoryTable;
import com.openexchange.folderstorage.outlook.memory.MemoryTree;
import com.openexchange.folderstorage.outlook.sql.Delete;
import com.openexchange.folderstorage.outlook.sql.Insert;
import com.openexchange.folderstorage.outlook.sql.Select;
import com.openexchange.folderstorage.outlook.sql.Update;
import com.openexchange.folderstorage.outlook.sql.Utility;
import com.openexchange.folderstorage.type.MailType;
import com.openexchange.folderstorage.type.PublicType;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.infostore.InfostoreFacades;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.log.LogProperties;
import com.openexchange.log.Props;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.messaging.MessagingAccount;
import com.openexchange.messaging.MessagingService;
import com.openexchange.messaging.ServiceAware;
import com.openexchange.messaging.registry.MessagingServiceRegistry;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.PutIfAbsent;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.threadpool.ThreadPoolCompletionService;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.threadpool.Trackable;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public final class OutlookFolderStorage
implements FolderStorage {
    private static final String SERVICE_INFOSTORE = "infostore";
    private static final String INFOSTORE;
    private static final String INFOSTORE_USER;
    private static final String INFOSTORE_PUBLIC;
    private static final Set<String> SYSTEM_INFOSTORES;
    static final org.apache.commons.logging.Log LOG;
    static final String PREPARED_FULLNAME_INBOX;
    static final String PREPARED_FULLNAME_DEFAULT;
    private static final ThreadPools.ExpectedExceptionFactory<OXException> FACTORY;
    public static final String OUTLOOK_TREE_ID = "1";
    private static final String OUTLOOK_ROOT_NAME = "Hidden-Root";
    private static final String OUTLOOK_PRIVATE_NAME = "IPM-Root";
    private static final TimeoutConcurrentMap<Key, Future<List<SortableId>>> TCM;
    private static final OutlookFolderStorage INSTANCE;
    final String realTreeId = FolderStorage.REAL_TREE_ID;
    private final FolderType folderType = new OutlookFolderType();
    private final String publicMailFolderPath;
    final OutlookFolderStorageRegistry folderStorageRegistry = OutlookFolderStorageRegistry.getInstance();
    private static final String DEFAULT_ID = "0";
    private static final int MODULE_FILE;
    private static final int MODULE_MAIL;

    public static void removeFromTCM(String fullname, int user, int contextId) {
        Key key = new Key(fullname, Integer.parseInt(OUTLOOK_TREE_ID), user, contextId);
        TCM.remove(key);
    }

    public static void clearTCM() {
        TCM.clear();
    }

    public static OutlookFolderStorage getInstance() {
        return INSTANCE;
    }

    private static boolean showPersonalBelowInfoStore(Session session, boolean altNames) {
        if (!altNames) {
            return false;
        }
        String paramName = "com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore";
        Boolean tmp = (Boolean)session.getParameter("com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore");
        if (null != tmp) {
            return tmp;
        }
        ConfigViewFactory configViewFactory = ServerServiceRegistry.getInstance().getService(ConfigViewFactory.class);
        if (null == configViewFactory) {
            return false;
        }
        try {
            ConfigView view = configViewFactory.getView(session.getUserId(), session.getContextId());
            Boolean b = (Boolean)view.opt("com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore", Boolean.TYPE, (Object)Boolean.FALSE);
            if (session instanceof PutIfAbsent) {
                ((PutIfAbsent)session).setParameterIfAbsent("com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore", (Object)b);
            } else {
                session.setParameter("com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore", (Object)b);
            }
            return b;
        }
        catch (OXException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static Context getContext(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getContext();
        }
        return null == session ? null : ContextStorage.getStorageContext(session);
    }

    private static String getDefaultInfoStoreFolderId(Session session) {
        String paramName = "com.openexchange.folderstorage.defaultInfoStoreFolderId";
        String tmp = (String)session.getParameter("com.openexchange.folderstorage.defaultInfoStoreFolderId");
        if (null != tmp) {
            return tmp;
        }
        try {
            String id = Integer.toString(new OXFolderAccess(OutlookFolderStorage.getContext(session)).getDefaultFolder(session.getUserId(), 8).getObjectID());
            if (session instanceof PutIfAbsent) {
                ((PutIfAbsent)session).setParameterIfAbsent("com.openexchange.folderstorage.defaultInfoStoreFolderId", (Object)id);
            } else {
                session.setParameter("com.openexchange.folderstorage.defaultInfoStoreFolderId", (Object)id);
            }
            return id;
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private OutlookFolderStorage() {
        String property;
        ConfigurationService service = (ConfigurationService)OutlookServiceRegistry.getServiceRegistry().getService(ConfigurationService.class);
        this.publicMailFolderPath = null == service ? null : (null == (property = service.getProperty("PUBLIC_MAIL_FOLDER")) ? null : MailFolderUtility.prepareFullname(0, property));
    }

    @Override
    public void clearCache(int userId, int contextId) {
        OutlookFolderStorage.clearTCM();
    }

    public String getPublicMailFolderPath() {
        return this.publicMailFolderPath;
    }

    @Override
    public void checkConsistency(String treeId, StorageParameters storageParameters) throws OXException {
        Session session = storageParameters.getSession();
        int tree = Tools.getUnsignedInteger(treeId);
        MemoryTable memoryTable = MemoryTable.getMemoryTableFor(session);
        MemoryTree memoryTree = memoryTable.getTree(tree, session);
        List<String> folderIds = memoryTree.getFolders();
        if (!folderIds.isEmpty()) {
            LinkedList<FolderStorage> storages = new LinkedList<FolderStorage>();
            try {
                for (String folderId : folderIds) {
                    FolderStorage folderStorage = this.getOpenedStorage(folderId, this.realTreeId, true, storageParameters, storages);
                    try {
                        if (folderStorage.containsFolder(this.realTreeId, folderId, storageParameters)) continue;
                        boolean restore = memoryTree.hasSubfolderIds(folderId);
                        if (restore) {
                            folderStorage.restore(this.realTreeId, folderId, storageParameters);
                            continue;
                        }
                        this.deleteFolder(treeId, folderId, storageParameters, DatabaseFolderType.getInstance().servesFolderId(folderId), memoryTable);
                    }
                    catch (OXException oxe) {
                        if (LOG.isDebugEnabled()) {
                            LOG.warn((Object)("Checking consistency failed for folder " + folderId + " in tree " + treeId), (Throwable)oxe);
                            continue;
                        }
                        LOG.warn((Object)("Checking consistency failed for folder " + folderId + " in tree " + treeId + ":\n" + oxe.getMessage()));
                    }
                }
                for (FolderStorage folderStorage : storages) {
                    folderStorage.commitTransaction(storageParameters);
                }
            }
            catch (OXException e) {
                for (FolderStorage folderStorage : storages) {
                    folderStorage.rollback(storageParameters);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)("Checking consistency failed in tree " + treeId), (Throwable)e);
                } else {
                    LOG.warn((Object)("Checking consistency failed in tree " + treeId + ":\n" + e.getMessage()));
                }
            }
            catch (RuntimeException e) {
                for (FolderStorage folderStorage : storages) {
                    folderStorage.rollback(storageParameters);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)("Checking consistency failed for in tree " + treeId), (Throwable)e);
                }
                LOG.warn((Object)("Checking consistency failed for in tree " + treeId + ":\n" + e.getMessage()));
            }
        }
    }

    @Override
    public SortableId[] getVisibleFolders(String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        FolderStorage folderStorage = this.folderStorageRegistry.getFolderStorageByContentType(this.realTreeId, contentType);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_CT.create(this.realTreeId, contentType);
        }
        boolean started = folderStorage.startTransaction(storageParameters, false);
        try {
            SortableId[] ret = folderStorage.getVisibleFolders(treeId, contentType, type, storageParameters);
            if (started) {
                folderStorage.commitTransaction(storageParameters);
            }
            return ret;
        }
        catch (OXException e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public void restore(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
    }

    @Override
    public Folder prepareFolder(String treeId, Folder folder, StorageParameters storageParameters) throws OXException {
        String folderId = folder.getID();
        FolderStorage folderStorage = this.folderStorageRegistry.getFolderStorage(this.realTreeId, folderId);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(this.realTreeId, folderId);
        }
        boolean started = folderStorage.startTransaction(storageParameters, true);
        try {
            Folder preparedFolder = folderStorage.prepareFolder(this.realTreeId, folder, storageParameters);
            if (started) {
                folderStorage.commitTransaction(storageParameters);
            }
            if (preparedFolder.isGlobalID() != folder.isGlobalID()) {
                TCM.clear();
            }
            return preparedFolder;
        }
        catch (OXException e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public void clearFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        FolderStorage folderStorage = this.folderStorageRegistry.getFolderStorage(this.realTreeId, folderId);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(this.realTreeId, folderId);
        }
        TCM.clear();
        boolean started = folderStorage.startTransaction(storageParameters, true);
        try {
            folderStorage.clearFolder(this.realTreeId, folderId, storageParameters);
            if (started) {
                folderStorage.commitTransaction(storageParameters);
            }
        }
        catch (OXException e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public void commitTransaction(StorageParameters params) {
    }

    @Override
    public boolean containsFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        return this.containsFolder(treeId, folderId, StorageType.WORKING, storageParameters);
    }

    @Override
    public boolean containsFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        if (PREPARED_FULLNAME_DEFAULT.equals(folderId)) {
            return false;
        }
        FolderStorage dedicatedFolderStorage = this.folderStorageRegistry.getDedicatedFolderStorage(FolderStorage.REAL_TREE_ID, folderId);
        return dedicatedFolderStorage.containsFolder(FolderStorage.REAL_TREE_ID, folderId, storageType, storageParameters);
    }

    @Override
    public void createFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        Folder realFolder;
        TCM.clear();
        String folderId = folder.getID();
        FolderStorage folderStorage = this.folderStorageRegistry.getFolderStorage(this.realTreeId, folderId);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(this.realTreeId, folderId);
        }
        boolean started = folderStorage.startTransaction(storageParameters, true);
        try {
            realFolder = folderStorage.getFolder(this.realTreeId, folderId, StorageType.WORKING, storageParameters);
            if (started) {
                folderStorage.commitTransaction(storageParameters);
            }
        }
        catch (OXException e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        String parentId = folder.getParentID();
        if (realFolder.getParentID().equals(parentId)) {
            return;
        }
        int userId = storageParameters.getUserId();
        if (null == realFolder.getLastModified()) {
            folder.setModifiedBy(userId);
            folder.setLastModified(new Date());
        }
        int contextId = storageParameters.getContextId();
        int tree = Tools.getUnsignedInteger(folder.getTreeID());
        Connection wcon = OutlookFolderStorage.checkWriteConnection(storageParameters);
        Insert.insertFolder(contextId, tree, userId, folder, wcon);
        MemoryTable memoryTable = MemoryTable.optMemoryTableFor(storageParameters.getSession());
        if (null != memoryTable) {
            memoryTable.initializeTree(tree, userId, contextId, wcon);
        }
    }

    @Override
    public void deleteFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        TCM.clear();
        Boolean b = (Boolean)storageParameters.getParameter(FolderType.GLOBAL, "global");
        boolean global = null == b ? DatabaseFolderType.getInstance().servesFolderId(folderId) : b.booleanValue();
        this.deleteFolder(treeId, folderId, storageParameters, global, MemoryTable.optMemoryTableFor(storageParameters.getSession()));
    }

    private void deleteFolder(String treeId, String folderId, StorageParameters storageParameters, boolean global, MemoryTable memoryTable) throws OXException {
        SessiondService sessiondService;
        MemoryTree memoryTree;
        int tree = Tools.getUnsignedInteger(treeId);
        if (null != memoryTable && null != (memoryTree = memoryTable.optTree(tree))) {
            memoryTree.getCrud().remove(folderId);
        }
        if (null != (sessiondService = (SessiondService)OutlookServiceRegistry.getServiceRegistry().getService(SessiondService.class))) {
            Session session = storageParameters.getSession();
            Collection sessions = sessiondService.getSessions(session.getUserId(), session.getContextId());
            HashSet<String> disposed = new HashSet<String>(sessions.size());
            disposed.add(session.getSessionID());
            for (Session current : sessions) {
                MemoryTree memoryTree2;
                MemoryTable memTable;
                if (!disposed.add(current.getSessionID()) || null == (memTable = MemoryTable.optMemoryTableFor(session)) || null == (memoryTree2 = memTable.optTree(tree))) continue;
                memoryTree2.getCrud().remove(folderId);
            }
        }
        Connection wcon = OutlookFolderStorage.checkWriteConnection(storageParameters);
        Delete.deleteFolder(storageParameters.getContextId(), tree, storageParameters.getUserId(), folderId, global, true, wcon);
    }

    @Override
    public ContentType getDefaultContentType() {
        return null;
    }

    @Override
    public String getDefaultFolderID(User user, String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        FolderStorage byContentType;
        if (PublicType.getInstance().equals(type) && null != this.publicMailFolderPath) {
            if (MailContentType.getInstance().toString().equals(((Object)contentType).toString())) {
                return this.publicMailFolderPath;
            }
            if (TaskContentType.getInstance().equals(contentType)) {
                return FolderStorage.PUBLIC_ID;
            }
            if (CalendarContentType.getInstance().equals(contentType)) {
                return FolderStorage.PUBLIC_ID;
            }
            if (ContactContentType.getInstance().equals(contentType)) {
                return FolderStorage.PUBLIC_ID;
            }
        }
        if (null == (byContentType = this.folderStorageRegistry.getFolderStorageByContentType(this.realTreeId, contentType))) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_CT.create(treeId, contentType);
        }
        boolean started = byContentType.startTransaction(storageParameters, false);
        try {
            String defaultFolderID = byContentType.getDefaultFolderID(user, treeId, contentType, type, storageParameters);
            if (started) {
                byContentType.commitTransaction(storageParameters);
            }
            return defaultFolderID;
        }
        catch (OXException e) {
            if (started) {
                byContentType.rollback(storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            if (started) {
                byContentType.rollback(storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public Type getTypeByParent(User user, String treeId, String parentId, StorageParameters storageParameters) throws OXException {
        FolderStorage folderStorage = this.folderStorageRegistry.getFolderStorage(this.realTreeId, parentId);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, parentId);
        }
        boolean started = folderStorage.startTransaction(storageParameters, false);
        try {
            Type originalType = folderStorage.getTypeByParent(user, this.realTreeId, parentId, storageParameters);
            Type retval = MailType.getInstance().equals(originalType) ? (null != this.publicMailFolderPath && parentId.startsWith(this.publicMailFolderPath, 0) ? PublicType.getInstance() : originalType) : originalType;
            if (started) {
                folderStorage.commitTransaction(storageParameters);
            }
            return retval;
        }
        catch (OXException e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public String[] getDeletedFolderIDs(String treeId, Date timeStamp, StorageParameters storageParameters) {
        return new String[0];
    }

    @Override
    public boolean containsForeignObjects(User user, String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        FolderStorage folderStorage = this.folderStorageRegistry.getFolderStorage(this.realTreeId, folderId);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(this.realTreeId, folderId);
        }
        boolean started = folderStorage.startTransaction(storageParameters, false);
        try {
            boolean containsForeignObjects = folderStorage.containsForeignObjects(user, this.realTreeId, folderId, storageParameters);
            if (started) {
                folderStorage.commitTransaction(storageParameters);
            }
            return containsForeignObjects;
        }
        catch (OXException e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean isEmpty(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        FolderStorage folderStorage = this.folderStorageRegistry.getFolderStorage(this.realTreeId, folderId);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(this.realTreeId, folderId);
        }
        boolean started = folderStorage.startTransaction(storageParameters, false);
        try {
            boolean isEmpty = folderStorage.isEmpty(this.realTreeId, folderId, storageParameters);
            if (started) {
                folderStorage.commitTransaction(storageParameters);
            }
            return isEmpty;
        }
        catch (OXException e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public void updateLastModified(long lastModified, String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        FolderStorage folderStorage = this.folderStorageRegistry.getFolderStorage(this.realTreeId, folderId);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(this.realTreeId, folderId);
        }
        TCM.clear();
        boolean started = folderStorage.startTransaction(storageParameters, true);
        try {
            Folder realFolder = folderStorage.getFolder(this.realTreeId, folderId, StorageType.WORKING, storageParameters);
            if (null == realFolder.getLastModified()) {
                int userId;
                int tree;
                int contextId = storageParameters.getContextId();
                boolean containsFolder = Select.containsFolder(contextId, tree = Tools.getUnsignedInteger(treeId), userId = storageParameters.getUserId(), folderId, StorageType.WORKING, OutlookFolderStorage.checkReadConnection(storageParameters));
                if (containsFolder) {
                    Update.updateLastModified(contextId, tree, userId, folderId, lastModified);
                    MemoryTable memoryTable = MemoryTable.optMemoryTableFor(storageParameters.getSession());
                    if (null != memoryTable) {
                        memoryTable.initializeFolder(folderId, tree, userId, contextId);
                    }
                }
            } else {
                folderStorage.updateLastModified(lastModified, FolderStorage.REAL_TREE_ID, folderId, storageParameters);
                MemoryTable memoryTable = MemoryTable.optMemoryTableFor(storageParameters.getSession());
                if (null != memoryTable) {
                    memoryTable.initializeFolder(folderId, Tools.getUnsignedInteger(treeId), storageParameters.getUserId(), storageParameters.getContextId());
                }
            }
            if (started) {
                folderStorage.commitTransaction(storageParameters);
            }
        }
        catch (OXException e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageParameters storageParameters) throws OXException {
        return this.getFolders(treeId, folderIds, StorageType.WORKING, storageParameters);
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageType storageType, StorageParameters storageParameters) throws OXException {
        Folder[] ret = new Folder[folderIds.size()];
        TObjectIntHashMap map = new TObjectIntHashMap(folderIds.size());
        for (int i = 0; i < ret.length; ++i) {
            String folderId = folderIds.get(i);
            if (PREPARED_FULLNAME_DEFAULT.equals(folderId)) {
                throw FolderExceptionErrorMessage.NOT_FOUND.create(folderId, treeId);
            }
            if (FolderStorage.ROOT_ID.equals(folderId)) {
                ret[i] = this.getFolder(treeId, folderId, storageType, storageParameters);
                continue;
            }
            if (FolderStorage.PRIVATE_ID.equals(folderId)) {
                ret[i] = this.getFolder(treeId, folderId, storageType, storageParameters);
                continue;
            }
            if (SYSTEM_INFOSTORES.contains(folderId)) {
                ret[i] = this.getFolder(treeId, folderId, storageType, storageParameters);
                continue;
            }
            map.put((Object)folderId, i);
        }
        if (!map.isEmpty()) {
            List<Folder> realFolders;
            User user = storageParameters.getUser();
            int tree = Tools.getUnsignedInteger(treeId);
            int contextId = storageParameters.getContextId();
            FolderStorage folderStorage = this.folderStorageRegistry.getFolderStorage(this.realTreeId, folderIds.get(0));
            if (null == folderStorage) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(this.realTreeId, folderIds.get(0));
            }
            boolean started = folderStorage.startTransaction(storageParameters, false);
            try {
                realFolders = folderStorage.getFolders(this.realTreeId, Arrays.asList(map.keys((Object[])new String[map.size()])), storageParameters);
                if (started) {
                    folderStorage.commitTransaction(storageParameters);
                }
            }
            catch (OXException e) {
                if (started) {
                    folderStorage.rollback(storageParameters);
                }
                throw e;
            }
            catch (Exception e) {
                if (started) {
                    folderStorage.rollback(storageParameters);
                }
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
            boolean altNames = StorageParametersUtility.getBoolParameter("altNames", storageParameters);
            for (Folder realFolder : realFolders) {
                OutlookFolder outlookFolder = new OutlookFolder(realFolder);
                outlookFolder.setTreeID(treeId);
                this.setSubfolders(treeId, realFolder.getID(), storageParameters, user, tree, contextId, outlookFolder, realFolder);
                Session session = storageParameters.getSession();
                MemoryTable memoryTable = MemoryTable.getMemoryTableFor(session);
                boolean presentInTable = memoryTable.getTree(tree, user.getId(), contextId).fillFolder(outlookFolder);
                if (!presentInTable) {
                    OutlookFolderStorage.doModifications(outlookFolder, session, altNames);
                }
                int index = map.get((Object)realFolder.getID());
                ret[index] = outlookFolder;
            }
        }
        ArrayList<Folder> l = new ArrayList<Folder>(ret.length);
        for (Folder folder : ret) {
            if (null == folder) continue;
            l.add(folder);
        }
        return l;
    }

    @Override
    public Folder getFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        return this.getFolder(treeId, folderId, StorageType.WORKING, storageParameters);
    }

    @Override
    public Folder getFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        Folder realFolder;
        if (PREPARED_FULLNAME_DEFAULT.equals(folderId)) {
            throw FolderExceptionErrorMessage.NOT_FOUND.create(folderId, treeId);
        }
        if (FolderStorage.ROOT_ID.equals(folderId)) {
            Folder rootFolder;
            FolderStorage folderStorage = this.folderStorageRegistry.getFolderStorage(this.realTreeId, folderId);
            if (null == folderStorage) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(this.realTreeId, folderId);
            }
            boolean started = folderStorage.startTransaction(storageParameters, false);
            try {
                rootFolder = folderStorage.getFolder(FolderStorage.REAL_TREE_ID, folderId, storageParameters);
                if (started) {
                    folderStorage.commitTransaction(storageParameters);
                }
            }
            catch (OXException e) {
                if (started) {
                    folderStorage.rollback(storageParameters);
                }
                throw e;
            }
            catch (Exception e) {
                if (started) {
                    folderStorage.rollback(storageParameters);
                }
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
            OutlookFolder outlookRootFolder = new OutlookFolder(rootFolder);
            outlookRootFolder.setName(OUTLOOK_ROOT_NAME);
            outlookRootFolder.setTreeID(treeId);
            outlookRootFolder.setSubfolderIDs(null);
            return outlookRootFolder;
        }
        if (FolderStorage.PRIVATE_ID.equals(folderId)) {
            Folder privateFolder;
            FolderStorage folderStorage = this.folderStorageRegistry.getFolderStorage(this.realTreeId, folderId);
            if (null == folderStorage) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(this.realTreeId, folderId);
            }
            folderStorage.startTransaction(storageParameters, false);
            try {
                privateFolder = folderStorage.getFolder(this.realTreeId, folderId, storageParameters);
                folderStorage.commitTransaction(storageParameters);
            }
            catch (OXException e) {
                folderStorage.rollback(storageParameters);
                throw e;
            }
            catch (Exception e) {
                folderStorage.rollback(storageParameters);
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
            OutlookFolder outlookPrivateFolder = new OutlookFolder(privateFolder);
            outlookPrivateFolder.setName(OUTLOOK_PRIVATE_NAME);
            outlookPrivateFolder.setTreeID(treeId);
            outlookPrivateFolder.setSubfolderIDs(null);
            return outlookPrivateFolder;
        }
        User user = storageParameters.getUser();
        int tree = Tools.getUnsignedInteger(treeId);
        int contextId = storageParameters.getContextId();
        Session session = storageParameters.getSession();
        FolderStorage folderStorage = this.folderStorageRegistry.getFolderStorage(this.realTreeId, folderId);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(this.realTreeId, folderId);
        }
        boolean started = folderStorage.startTransaction(storageParameters, false);
        try {
            realFolder = folderStorage.getFolder(this.realTreeId, folderId, storageParameters);
            if (started) {
                folderStorage.commitTransaction(storageParameters);
            }
        }
        catch (OXException e) {
            MemoryTable memoryTable;
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            if (null == (memoryTable = MemoryTable.optMemoryTableFor(session))) {
                Connection wcon = OutlookFolderStorage.checkWriteConnection(storageParameters);
                if (Select.containsFolder(contextId, tree, user.getId(), folderId, StorageType.WORKING, wcon)) {
                    Delete.deleteFolder(contextId, tree, user.getId(), folderId, false, false, wcon);
                    throw FolderExceptionErrorMessage.TEMPORARY_ERROR.create(e, new Object[0]);
                }
            } else {
                MemoryTree memoryTree = memoryTable.getTree(tree, user.getId(), contextId);
                if (memoryTree.containsFolder(folderId)) {
                    Delete.deleteFolder(contextId, tree, user.getId(), folderId, false, false, OutlookFolderStorage.checkWriteConnection(storageParameters));
                    memoryTree.getCrud().remove(folderId);
                    throw FolderExceptionErrorMessage.TEMPORARY_ERROR.create(e, new Object[0]);
                }
            }
            throw e;
        }
        catch (Exception e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        OutlookFolder outlookFolder = new OutlookFolder(realFolder);
        outlookFolder.setTreeID(treeId);
        if (SYSTEM_INFOSTORES.contains(folderId)) {
            FileStorageAccount defaultAccount;
            if (INFOSTORE.equals(folderId) && !InfostoreFacades.isInfoStoreAvailable() && null != (defaultAccount = this.getDefaultFileStorageAccess(session))) {
                outlookFolder.setName(defaultAccount.getDisplayName());
            }
            outlookFolder.setSubfolderIDs(null);
        } else {
            this.setSubfolders(treeId, folderId, storageParameters, user, tree, contextId, outlookFolder, realFolder);
        }
        MemoryTable memoryTable = MemoryTable.getMemoryTableFor(session);
        boolean presentInTable = memoryTable.getTree(tree, user.getId(), contextId).fillFolder(outlookFolder);
        if (!presentInTable) {
            boolean altNames = StorageParametersUtility.getBoolParameter("altNames", storageParameters);
            OutlookFolderStorage.doModifications(outlookFolder, session, altNames);
        }
        return outlookFolder;
    }

    private void setSubfolders(String treeId, String folderId, StorageParameters storageParameters, User user, int tree, int contextId, OutlookFolder outlookFolder, Folder realFolder) throws OXException {
        if (PREPARED_FULLNAME_INBOX.equals(folderId)) {
            SortableId[] inboxSubfolders = this.getINBOXSubfolders(treeId, storageParameters, user, user.getLocale(), contextId, tree);
            String[] subs = new String[inboxSubfolders.length];
            for (int i = 0; i < subs.length; ++i) {
                subs[i] = inboxSubfolders[i].getId();
            }
            outlookFolder.setSubfolderIDs(subs);
        } else {
            String[] realSubfolderIDs = realFolder.getSubfolderIDs();
            if (null == realSubfolderIDs) {
                outlookFolder.setSubfolderIDs(null);
            } else {
                int userId = user.getId();
                if (0 == realSubfolderIDs.length) {
                    MemoryTable memoryTable = MemoryTable.getMemoryTableFor(storageParameters.getSession());
                    MemoryTree memoryTree = memoryTable.getTree(tree, userId, contextId);
                    boolean contains = memoryTree.containsParent(folderId);
                    if (contains) {
                        outlookFolder.setSubfolderIDs(null);
                        outlookFolder.setSubscribedSubfolders(true);
                    } else {
                        outlookFolder.setSubfolderIDs(realSubfolderIDs);
                    }
                } else if (realFolder.isDefault() || FolderStorage.PUBLIC_ID.equals(realFolder.getID())) {
                    MemoryTable memoryTable = MemoryTable.getMemoryTableFor(storageParameters.getSession());
                    MemoryTree memoryTree = memoryTable.getTree(tree, userId, contextId);
                    if (memoryTree.containsParent(folderId)) {
                        outlookFolder.setSubfolderIDs(null);
                        outlookFolder.setSubscribedSubfolders(true);
                    } else {
                        boolean[] contained = memoryTree.containsFolders(realSubfolderIDs);
                        ArrayList<String> filtered = new ArrayList<String>(realSubfolderIDs.length);
                        for (int i = 0; i < realSubfolderIDs.length; ++i) {
                            if (contained[i]) continue;
                            filtered.add(realSubfolderIDs[i]);
                        }
                        if (!filtered.isEmpty()) {
                            outlookFolder.setSubfolderIDs(filtered.toArray(new String[filtered.size()]));
                            outlookFolder.setSubscribedSubfolders(true);
                        } else {
                            outlookFolder.setSubfolderIDs(new String[0]);
                            outlookFolder.setSubscribedSubfolders(false);
                        }
                    }
                } else {
                    MemoryTable memoryTable = MemoryTable.getMemoryTableFor(storageParameters.getSession());
                    MemoryTree memoryTree = memoryTable.getTree(tree, userId, contextId);
                    if (memoryTree.containsParent(folderId)) {
                        outlookFolder.setSubfolderIDs(null);
                        outlookFolder.setSubscribedSubfolders(true);
                    } else {
                        outlookFolder.setSubfolderIDs(realSubfolderIDs);
                    }
                }
            }
        }
    }

    @Override
    public FolderType getFolderType() {
        return this.folderType;
    }

    @Override
    public String[] getModifiedFolderIDs(String treeId, Date timeStamp, ContentType[] includeContentTypes, final StorageParameters storageParameters) throws OXException {
        if (null == includeContentTypes || includeContentTypes.length == 0) {
            return new String[0];
        }
        boolean containsMail = false;
        for (ContentType contentType : includeContentTypes) {
            if (!MailContentType.getInstance().equals(contentType)) continue;
            containsMail = true;
            break;
        }
        if (containsMail) {
            final User user = storageParameters.getUser();
            Locale locale = user.getLocale();
            final int contextId = storageParameters.getContextId();
            final int tree = Tools.getUnsignedInteger(treeId);
            final FolderNameComparator comparator = new FolderNameComparator(locale);
            ArrayList<Object> maps = new ArrayList<Object>(2);
            maps.add(new MailFolderCallable(comparator, locale, user, contextId, tree, storageParameters).call());
            maps.add(new TrackableCallable<TreeMap<String, List<String>>>(){

                @Override
                public TreeMap<String, List<String>> call() throws OXException {
                    MemoryTable memoryTable = MemoryTable.getMemoryTableFor(storageParameters.getSession());
                    List<String[]> l = memoryTable.getTree(tree, user.getId(), contextId).getSubfolderIds(FolderStorage.PRIVATE_ID);
                    TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(comparator);
                    for (String[] idAndName : l) {
                        String id = idAndName[0];
                        if (!MailFolderType.getInstance().servesFolderId(id)) continue;
                        OutlookFolderStorage.put2TreeMap(idAndName[1], id, treeMap);
                    }
                    return treeMap;
                }
            }.call());
            TreeMap treeMap = new TreeMap(comparator);
            for (TreeMap treeMap2 : maps) {
                for (Map.Entry entry : treeMap2.entrySet()) {
                    String key = (String)entry.getKey();
                    List list = (List)treeMap.get(key);
                    if (null == list) {
                        treeMap.put(key, entry.getValue());
                        continue;
                    }
                    list.addAll((Collection)entry.getValue());
                }
            }
            Collection values = treeMap.values();
            ArrayList<String> arrayList = new ArrayList<String>(values.size());
            for (List list : values) {
                for (String id : list) {
                    arrayList.add(id);
                }
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return new String[0];
    }

    protected static boolean supportsMail(ContentType[] types) {
        for (ContentType contentType : types) {
            if (!MailContentType.getInstance().equals(contentType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public StoragePriority getStoragePriority() {
        return StoragePriority.NORMAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortableId[] getSubfolders(String treeId, String parentId, StorageParameters storageParameters) throws OXException {
        HashMap<String, String> id2name;
        ArrayList<String[]> l;
        FolderStorage folderStorage;
        if (FolderStorage.ROOT_ID.equals(parentId)) {
            return this.getRootFolderSubfolders(storageParameters);
        }
        User user = storageParameters.getUser();
        Locale locale = user.getLocale();
        int contextId = storageParameters.getContextId();
        int tree = Tools.getUnsignedInteger(treeId);
        if (PREPARED_FULLNAME_INBOX.equals(parentId)) {
            return this.getINBOXSubfolders(treeId, storageParameters, user, locale, contextId, tree);
        }
        if (FolderStorage.PRIVATE_ID.equals(parentId)) {
            return this.getPrivateFolderSubfolders(parentId, tree, storageParameters, user, locale, contextId);
        }
        Session session = storageParameters.getSession();
        if (!InfostoreFacades.isInfoStoreAvailable()) {
            FileStorageAccount defaultAccount;
            if (INFOSTORE_USER.equals(parentId) && null != (defaultAccount = this.getDefaultFileStorageAccess(session))) {
                FileStorageService fileStorageService = defaultAccount.getFileStorageService();
                String defaultId = DEFAULT_ID;
                FileStorageAccountAccess defaultFileStorageAccess = fileStorageService.getAccountAccess(DEFAULT_ID, session);
                defaultFileStorageAccess.connect();
                try {
                    FileStorageFolder personalFolder = defaultFileStorageAccess.getFolderAccess().getPersonalFolder();
                    if (defaultFileStorageAccess instanceof WarningsAware) {
                        OutlookFolderStorage.addWarnings(storageParameters, (WarningsAware)defaultFileStorageAccess);
                    }
                    FileStorageFolderIdentifier fsfi = new FileStorageFolderIdentifier(fileStorageService.getId(), defaultAccount.getId(), personalFolder.getId());
                    SortableId[] sortableIdArray = new SortableId[]{new OutlookId(fsfi.toString(), 0, personalFolder.getName())};
                    return sortableIdArray;
                }
                finally {
                    defaultFileStorageAccess.close();
                }
            }
            if (INFOSTORE_PUBLIC.equals(parentId) && null != (defaultAccount = this.getDefaultFileStorageAccess(session))) {
                FileStorageService fileStorageService = defaultAccount.getFileStorageService();
                String defaultId = DEFAULT_ID;
                FileStorageAccountAccess defaultFileStorageAccess = fileStorageService.getAccountAccess(DEFAULT_ID, session);
                defaultFileStorageAccess.connect();
                try {
                    FileStorageFolder[] publicFolders = defaultFileStorageAccess.getFolderAccess().getPublicFolders();
                    SortableId[] ret = new SortableId[publicFolders.length];
                    String serviceId = fileStorageService.getId();
                    String accountId = defaultAccount.getId();
                    for (int i = 0; i < publicFolders.length; ++i) {
                        FileStorageFolder folder = publicFolders[i];
                        FileStorageFolderIdentifier fsfi = new FileStorageFolderIdentifier(serviceId, accountId, folder.getId());
                        ret[i] = new OutlookId(fsfi.toString(), i, folder.getName());
                    }
                    if (defaultFileStorageAccess instanceof WarningsAware) {
                        OutlookFolderStorage.addWarnings(storageParameters, (WarningsAware)defaultFileStorageAccess);
                    }
                    SortableId[] i = ret;
                    return i;
                }
                finally {
                    defaultFileStorageAccess.close();
                }
            }
        }
        if (null == (folderStorage = this.folderStorageRegistry.getFolderStorage(this.realTreeId, parentId))) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(this.realTreeId, parentId);
        }
        boolean started = folderStorage.startTransaction(storageParameters, false);
        try {
            String fName;
            String name;
            String id;
            Folder parentFolder = folderStorage.getFolder(this.realTreeId, parentId, storageParameters);
            SortableId[] realSubfolderIds = OutlookFolderStorage.getSubfolderIDs(parentFolder, folderStorage, storageParameters);
            l = new ArrayList<String[]>(realSubfolderIds.length);
            id2name = new HashMap<String, String>(realSubfolderIds.length);
            if (parentFolder.isDefault() || FolderStorage.PUBLIC_ID.equals(parentId)) {
                MemoryTable memoryTable = MemoryTable.getMemoryTableFor(session);
                boolean[] contained = memoryTable.getTree(tree, user.getId(), contextId).containsFolders(realSubfolderIds);
                for (int k = 0; k < realSubfolderIds.length; ++k) {
                    SortableId realSubfolderId = realSubfolderIds[k];
                    if (contained[k]) continue;
                    id = realSubfolderId.getId();
                    name = realSubfolderId.getName();
                    fName = name == null ? folderStorage.getFolder(this.realTreeId, id, storageParameters).getName() : name;
                    l.add(new String[]{id, fName});
                    id2name.put(id, fName);
                }
            } else {
                for (SortableId realSubfolderId : realSubfolderIds) {
                    id = realSubfolderId.getId();
                    name = realSubfolderId.getName();
                    fName = name == null ? folderStorage.getFolder(this.realTreeId, id, storageParameters).getName() : name;
                    l.add(new String[]{id, fName});
                    id2name.put(id, fName);
                }
            }
            if (INFOSTORE.equals(parentId)) {
                LinkedList<FileStorageAccount> fsAccounts = new LinkedList<FileStorageAccount>();
                FileStorageServiceRegistry fsr = (FileStorageServiceRegistry)OutlookServiceRegistry.getServiceRegistry().getService(FileStorageServiceRegistry.class);
                if (null != fsr) {
                    try {
                        List allServices = fsr.getAllServices();
                        for (FileStorageService fsService : allServices) {
                            List userAccounts = fsService instanceof AccountAware ? ((AccountAware)fsService).getAccounts(session) : fsService.getAccountManager().getAccounts(session);
                            Props props = LogProperties.getLogProperties();
                            for (FileStorageAccount userAccount : userAccounts) {
                                if (SERVICE_INFOSTORE.equals(userAccount.getId()) || DEFAULT_ID.equals(userAccount.getId())) continue;
                                FileStorageAccountAccess accountAccess = this.getFSAccountAccess(storageParameters, userAccount);
                                accountAccess.connect();
                                try {
                                    props.put(LogProperties.Name.FILE_STORAGE_ACCOUNT_ID, (Object)userAccount.getId());
                                    props.put(LogProperties.Name.FILE_STORAGE_CONFIGURATION, (Object)userAccount.getConfiguration().toString());
                                    props.put(LogProperties.Name.FILE_STORAGE_SERVICE_ID, (Object)fsService.getId());
                                    FileStorageFolder rootFolder = accountAccess.getFolderAccess().getRootFolder();
                                    if (null != rootFolder) {
                                        fsAccounts.add(userAccount);
                                    }
                                    if (!(accountAccess instanceof WarningsAware)) continue;
                                    OutlookFolderStorage.addWarnings(storageParameters, (WarningsAware)accountAccess);
                                }
                                finally {
                                    accountAccess.close();
                                    props.remove(LogProperties.Name.FILE_STORAGE_ACCOUNT_ID);
                                    props.remove(LogProperties.Name.FILE_STORAGE_CONFIGURATION);
                                    props.remove(LogProperties.Name.FILE_STORAGE_SERVICE_ID);
                                }
                            }
                        }
                    }
                    catch (OXException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                    if (!fsAccounts.isEmpty()) {
                        Collections.sort(fsAccounts, new FileStorageAccountComparator(locale));
                        int sz = fsAccounts.size();
                        String fid = "";
                        for (int i = 0; i < sz; ++i) {
                            FileStorageService tmp;
                            FileStorageAccount fsa = (FileStorageAccount)fsAccounts.get(i);
                            String serviceId = fsa instanceof com.openexchange.file.storage.ServiceAware ? ((com.openexchange.file.storage.ServiceAware)fsa).getServiceId() : (null == (tmp = fsa.getFileStorageService()) ? null : tmp.getId());
                            FileStorageFolderIdentifier fsfi = new FileStorageFolderIdentifier(serviceId, fsa.getId(), "");
                            l.add(new String[]{fsfi.toString(), fsa.getDisplayName()});
                            id2name.put(fsfi.toString(), fsa.getDisplayName());
                        }
                    }
                }
            }
            if (started) {
                folderStorage.commitTransaction(storageParameters);
            }
        }
        catch (OXException e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        MemoryTable memoryTable = MemoryTable.getMemoryTableFor(session);
        String[] ids = memoryTable.getTree(tree, user.getId(), contextId).getSubfolderIds(locale, parentId, l);
        boolean altNames = StorageParametersUtility.getBoolParameter("altNames", storageParameters);
        if (SYSTEM_INFOSTORES.contains(parentId) && OutlookFolderStorage.showPersonalBelowInfoStore(session, altNames)) {
            String id;
            ArrayList<OutlookId> ret;
            String defaultFolderId;
            if (INFOSTORE.equals(parentId)) {
                defaultFolderId = OutlookFolderStorage.getDefaultInfoStoreFolderId(session);
                if (null != defaultFolderId) {
                    ret = new ArrayList<OutlookId>(ids.length + 1);
                    int ordinal = 0;
                    ret.add(new OutlookId(defaultFolderId, ordinal++, "My files"));
                    for (int i = 0; i < ids.length; ++i) {
                        id = ids[i];
                        ret.add(new OutlookId(id, ordinal++, (String)id2name.get(id)));
                    }
                    return ret.toArray(new SortableId[ret.size()]);
                }
            } else if (INFOSTORE_USER.equals(parentId) && null != (defaultFolderId = OutlookFolderStorage.getDefaultInfoStoreFolderId(session))) {
                ret = new ArrayList(ids.length);
                int ordinal = 0;
                for (int i = 0; i < ids.length; ++i) {
                    id = ids[i];
                    if (defaultFolderId.equals(id)) continue;
                    ret.add(new OutlookId(id, ordinal++, (String)id2name.get(id)));
                }
                return ret.toArray(new SortableId[ret.size()]);
            }
        }
        SortableId[] ret = new SortableId[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i];
            ret[i] = new OutlookId(id, i, (String)id2name.get(id));
        }
        return ret;
    }

    private FileStorageAccount getDefaultFileStorageAccess(Session session) throws OXException {
        FileStorageAccountManagerLookupService lookupService = ServerServiceRegistry.getInstance().getService(FileStorageAccountManagerLookupService.class);
        if (null == lookupService) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{FileStorageAccountManagerLookupService.class.getName()});
        }
        FileStorageAccountManager defaultAccountManager = lookupService.getAccountManager(DEFAULT_ID, session);
        if (null != defaultAccountManager) {
            return defaultAccountManager.getAccount(DEFAULT_ID, session);
        }
        return null;
    }

    private FileStorageAccountAccess getFSAccountAccess(StorageParameters storageParameters, FileStorageAccount userAccount) throws OXException {
        FileStorageService fileStorageService = userAccount.getFileStorageService();
        if (null == fileStorageService) {
            if (!(userAccount instanceof com.openexchange.file.storage.ServiceAware)) {
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create("Missing FileStorageService instance.");
            }
            String serviceId = ((com.openexchange.file.storage.ServiceAware)userAccount).getServiceId();
            fileStorageService = ((FileStorageServiceRegistry)OutlookServiceRegistry.getServiceRegistry().getService(FileStorageServiceRegistry.class)).getFileStorageService(serviceId);
        }
        return fileStorageService.getAccountAccess(userAccount.getId(), storageParameters.getSession());
    }

    SortableId[] getSubfolders(final String id, String treeId, final FolderStorage folderStorage, final StorageParameters storageParameters) throws OXException {
        FutureTask<List<SortableId>> ft;
        Key key = new Key(id, Integer.parseInt(treeId), storageParameters.getUserId(), storageParameters.getContextId());
        FutureTask<List<SortableId>> f = TCM.get(key);
        if (null == f && null == (f = (FutureTask<List<SortableId>>)TCM.putIfAbsent(key, ft = new FutureTask<List<SortableId>>(new TrackableCallable<List<SortableId>>(){

            @Override
            public List<SortableId> call() throws Exception {
                return Arrays.asList(folderStorage.getSubfolders(OutlookFolderStorage.this.realTreeId, id, storageParameters));
            }
        }), 60))) {
            f = ft;
            ft.run();
        }
        try {
            List<SortableId> sortedIDs = f.get();
            return sortedIDs.toArray(new SortableId[sortedIDs.size()]);
        }
        catch (InterruptedException e) {
            ThreadPools.unexpectedlyInterrupted((Thread)Thread.currentThread());
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OXException) {
                throw (OXException)cause;
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(cause, cause.getMessage());
        }
    }

    private SortableId[] getINBOXSubfolders(final String treeId, final StorageParameters storageParameters, final User user, final Locale locale, final int contextId, final int tree) throws OXException {
        FutureTask<List<SortableId>> ft;
        Key key = new Key(PREPARED_FULLNAME_INBOX, tree, user.getId(), contextId);
        FutureTask<List<SortableId>> f = TCM.get(key);
        if (null == f && null == (f = (FutureTask<List<SortableId>>)TCM.putIfAbsent(key, ft = new FutureTask<List<SortableId>>(new TrackableCallable<List<SortableId>>(){

            @Override
            public List<SortableId> call() throws OXException {
                FolderStorage folderStorage = OutlookFolderStorage.this.folderStorageRegistry.getFolderStorage(OutlookFolderStorage.this.realTreeId, PREPARED_FULLNAME_INBOX);
                if (null == folderStorage) {
                    throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(OutlookFolderStorage.this.realTreeId, PREPARED_FULLNAME_INBOX);
                }
                boolean started = folderStorage.startTransaction(storageParameters, false);
                try {
                    TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(new FolderNameComparator(locale));
                    HashSet<String> defIds = new HashSet<String>(6);
                    MailType mailType = MailType.getInstance();
                    defIds.add(folderStorage.getDefaultFolderID(user, treeId, TrashContentType.getInstance(), mailType, storageParameters));
                    defIds.add(folderStorage.getDefaultFolderID(user, treeId, DraftsContentType.getInstance(), mailType, storageParameters));
                    defIds.add(folderStorage.getDefaultFolderID(user, treeId, SentContentType.getInstance(), mailType, storageParameters));
                    defIds.add(folderStorage.getDefaultFolderID(user, treeId, SpamContentType.getInstance(), mailType, storageParameters));
                    SortableId[] inboxSubfolders = folderStorage.getSubfolders(OutlookFolderStorage.this.realTreeId, PREPARED_FULLNAME_INBOX, storageParameters);
                    MemoryTable memoryTable = MemoryTable.getMemoryTableFor(storageParameters.getSession());
                    MemoryTree memoryTree = memoryTable.getTree(tree, user.getId(), contextId);
                    boolean[] contained = memoryTree.containsFolders(inboxSubfolders);
                    for (int i = 0; i < inboxSubfolders.length; ++i) {
                        SortableId sortableId;
                        String id;
                        if (contained[i] || defIds.contains(id = (sortableId = inboxSubfolders[i]).getId())) continue;
                        String name = sortableId.getName();
                        if (null == name) {
                            String localizedName = OutlookFolderStorage.this.getLocalizedName(id, tree, locale, folderStorage, storageParameters);
                            OutlookFolderStorage.put2TreeMap(localizedName, id, treeMap);
                            continue;
                        }
                        OutlookFolderStorage.put2TreeMap(name, id, treeMap);
                    }
                    List<String[]> ids = memoryTree.getSubfolderIds(PREPARED_FULLNAME_INBOX);
                    for (String[] idAndName : ids) {
                        OutlookFolderStorage.put2TreeMap(idAndName[1], idAndName[0], treeMap);
                    }
                    if (started) {
                        folderStorage.commitTransaction(storageParameters);
                    }
                    Collection values = treeMap.values();
                    ArrayList<SortableId> sortedIDs = new ArrayList<SortableId>(values.size());
                    int i = 0;
                    for (List list : values) {
                        for (String id : list) {
                            sortedIDs.add(new OutlookId(id, i++, null));
                        }
                    }
                    return sortedIDs;
                }
                catch (OXException e) {
                    if (started) {
                        folderStorage.rollback(storageParameters);
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (started) {
                        folderStorage.rollback(storageParameters);
                    }
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
                }
            }
        }), 60))) {
            f = ft;
            ft.run();
        }
        try {
            List<SortableId> sortedIDs = f.get();
            return sortedIDs.isEmpty() ? new SortableId[]{} : sortedIDs.toArray(new SortableId[sortedIDs.size()]);
        }
        catch (InterruptedException e) {
            ThreadPools.unexpectedlyInterrupted((Thread)Thread.currentThread());
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OXException) {
                throw (OXException)cause;
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(cause, cause.getMessage());
        }
    }

    private SortableId[] getRootFolderSubfolders(StorageParameters storageParameters) throws OXException {
        SortableId[] ids;
        String parentId = FolderStorage.REAL_TREE_ID;
        FolderStorage folderStorage = this.folderStorageRegistry.getFolderStorage(this.realTreeId, parentId);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(this.realTreeId, parentId);
        }
        boolean started = folderStorage.startTransaction(storageParameters, false);
        try {
            SortableId[] subfolders = folderStorage.getSubfolders(FolderStorage.REAL_TREE_ID, parentId, storageParameters);
            ids = new SortableId[1];
            boolean b = false;
            for (int i = 0; !b && i < subfolders.length; ++i) {
                SortableId si = subfolders[i];
                if (!FolderStorage.PRIVATE_ID.equals(si.getId())) continue;
                ids[0] = si;
                b = true;
            }
            if (!b) {
                throw FolderExceptionErrorMessage.NOT_FOUND.create(FolderStorage.PRIVATE_ID, OUTLOOK_TREE_ID);
            }
            if (started) {
                folderStorage.commitTransaction(storageParameters);
            }
        }
        catch (OXException e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            if (started) {
                folderStorage.rollback(storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        List<String> subfolderIDs = OutlookFolderStorage.toIDList(ids);
        SortableId[] ret = new SortableId[subfolderIDs.size()];
        int i = 0;
        for (String id : subfolderIDs) {
            ret[i] = new OutlookId(id, i, null);
            ++i;
        }
        return ret;
    }

    private SortableId[] getPrivateFolderSubfolders(final String parentId, final int tree, final StorageParameters parameters, final User user, final Locale locale, final int contextId) throws OXException {
        List messagingSubfolderIDs;
        List accountSubfolderIDs;
        ThreadPoolCompletionService completionService = new ThreadPoolCompletionService((ThreadPoolService)OutlookServiceRegistry.getServiceRegistry().getService(ThreadPoolService.class, true));
        int taskCount = 0;
        final FolderNameComparator comparator = new FolderNameComparator(locale);
        completionService.submit(new TrackableCallable<TreeMap<String, List<String>>>(){

            @Override
            public TreeMap<String, List<String>> call() throws OXException {
                FolderStorage folderStorage = OutlookFolderStorage.this.folderStorageRegistry.getDedicatedFolderStorage(OutlookFolderStorage.this.realTreeId, parentId);
                if (null == folderStorage) {
                    throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(OutlookFolderStorage.this.realTreeId, parentId);
                }
                StorageParameters storageParameters = OutlookFolderStorage.newStorageParameters(parameters);
                boolean started = folderStorage.startTransaction(storageParameters, false);
                try {
                    SortableId[] ids = folderStorage.getSubfolders(OutlookFolderStorage.this.realTreeId, parentId, storageParameters);
                    TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(comparator);
                    for (SortableId sortableId : ids) {
                        String id = sortableId.getId();
                        String name = sortableId.getName();
                        if (null == name) {
                            OutlookFolderStorage.put2TreeMap(OutlookFolderStorage.this.getLocalizedName(id, tree, locale, folderStorage, storageParameters), id, treeMap);
                            continue;
                        }
                        OutlookFolderStorage.put2TreeMap(name, sortableId.getId(), treeMap);
                    }
                    if (started) {
                        folderStorage.commitTransaction(storageParameters);
                    }
                    return treeMap;
                }
                catch (OXException e) {
                    if (started) {
                        folderStorage.rollback(storageParameters);
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (started) {
                        folderStorage.rollback(storageParameters);
                    }
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
                }
            }
        });
        ++taskCount;
        completionService.submit(new MailFolderCallable(comparator, locale, user, contextId, tree, parameters));
        ++taskCount;
        completionService.submit(new TrackableCallable<TreeMap<String, List<String>>>(){

            @Override
            public TreeMap<String, List<String>> call() throws OXException {
                MemoryTable memoryTable = MemoryTable.getMemoryTableFor(parameters.getSession());
                List<String[]> l = memoryTable.getTree(tree, user.getId(), contextId).getSubfolderIds(parentId);
                TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(comparator);
                for (String[] idAndName : l) {
                    OutlookFolderStorage.put2TreeMap(idAndName[1], idAndName[0], treeMap);
                }
                return treeMap;
            }
        });
        ++taskCount;
        completionService.submit(new TrackableCallable<TreeMap<String, List<String>>>(){

            @Override
            public TreeMap<String, List<String>> call() throws OXException {
                FolderStorage folderStorage = OutlookFolderStorage.this.folderStorageRegistry.getFolderStorage(OutlookFolderStorage.this.realTreeId, parentId);
                if (null == folderStorage) {
                    throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(OutlookFolderStorage.this.realTreeId, parentId);
                }
                StorageParameters storageParameters = OutlookFolderStorage.newStorageParameters(parameters);
                boolean started = folderStorage.startTransaction(storageParameters, false);
                try {
                    SortableId[] subfolders = folderStorage.getSubfolders(FolderStorage.REAL_TREE_ID, FolderStorage.ROOT_ID, storageParameters);
                    TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(comparator);
                    for (SortableId subfolder : subfolders) {
                        String id = subfolder.getId();
                        if (FolderStorage.PRIVATE_ID.equals(id)) continue;
                        String name = subfolder.getName();
                        if (null == name) {
                            OutlookFolderStorage.put2TreeMap(OutlookFolderStorage.this.getLocalizedName(id, tree, locale, folderStorage, storageParameters), id, treeMap);
                            continue;
                        }
                        OutlookFolderStorage.put2TreeMap(name, id, treeMap);
                    }
                    if (started) {
                        folderStorage.commitTransaction(storageParameters);
                    }
                    return treeMap;
                }
                catch (OXException e) {
                    if (started) {
                        folderStorage.rollback(storageParameters);
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (started) {
                        folderStorage.rollback(storageParameters);
                    }
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
                }
            }
        });
        ++taskCount;
        Session s = parameters.getSession();
        UserConfiguration userConfiguration = s instanceof ServerSession ? ((ServerSession)s).getUserConfiguration() : UserConfigurationStorage.getInstance().getUserConfiguration(user.getId(), parameters.getContext());
        int unifiedMailIndex = -1;
        if (userConfiguration.isMultipleMailAccounts()) {
            MailAccountStorageService mass = (MailAccountStorageService)OutlookServiceRegistry.getServiceRegistry().getService(MailAccountStorageService.class);
            if (null == mass) {
                accountSubfolderIDs = Collections.emptyList();
            } else {
                List<MailAccount> accounts = Arrays.asList(mass.getUserMailAccounts(user.getId(), contextId));
                Collections.sort(accounts, new MailAccountComparator(locale));
                if (accounts.isEmpty()) {
                    accountSubfolderIDs = Collections.emptyList();
                } else {
                    accountSubfolderIDs = new ArrayList(accounts.size());
                    for (MailAccount mailAccount : accounts) {
                        if (mailAccount.isDefaultAccount()) continue;
                        if (UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX.equals(mailAccount.getMailProtocol())) {
                            UnifiedInboxManagement uim = (UnifiedInboxManagement)OutlookServiceRegistry.getServiceRegistry().getService(UnifiedInboxManagement.class);
                            try {
                                if (null == uim || !uim.isEnabled(user.getId(), contextId)) continue;
                                accountSubfolderIDs.add(MailFolderUtility.prepareFullname(mailAccount.getId(), "default"));
                                unifiedMailIndex = accountSubfolderIDs.size() - 1;
                            }
                            catch (OXException e) {
                                LOG.error((Object)e.getMessage(), (Throwable)e);
                            }
                            continue;
                        }
                        accountSubfolderIDs.add(MailFolderUtility.prepareFullname(mailAccount.getId(), "default"));
                    }
                }
            }
        } else {
            accountSubfolderIDs = Collections.emptyList();
        }
        ArrayList messagingAccounts = new ArrayList();
        MessagingServiceRegistry msr = (MessagingServiceRegistry)OutlookServiceRegistry.getServiceRegistry().getService(MessagingServiceRegistry.class);
        if (null == msr) {
            messagingSubfolderIDs = Collections.emptyList();
        } else {
            try {
                List allServices = msr.getAllServices(user.getId(), contextId);
                for (MessagingService messagingService : allServices) {
                    if (messagingService.getId().equals("com.openexchange.messaging.mail")) continue;
                    try {
                        messagingAccounts.addAll(messagingService.getAccountManager().getAccounts(parameters.getSession()));
                    }
                    catch (OXException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            if (messagingAccounts.isEmpty()) {
                messagingSubfolderIDs = Collections.emptyList();
            } else {
                Collections.sort(messagingAccounts, new MessagingAccountComparator(locale));
                int sz = messagingAccounts.size();
                messagingSubfolderIDs = new ArrayList(sz);
                String fullname = "";
                for (int i = 0; i < sz; ++i) {
                    MessagingService tmp;
                    MessagingAccount ma = (MessagingAccount)messagingAccounts.get(i);
                    String serviceId = ma instanceof ServiceAware ? ((ServiceAware)ma).getServiceId() : (null == (tmp = ma.getMessagingService()) ? null : tmp.getId());
                    MessagingFolderIdentifier mfi = new MessagingFolderIdentifier(serviceId, ma.getId(), "");
                    messagingSubfolderIDs.add(mfi.toString());
                }
            }
        }
        List taken = ThreadPools.takeCompletionService((CompletionService)completionService, (int)taskCount, FACTORY);
        TreeMap treeMap = new TreeMap(comparator);
        for (TreeMap tm : taken) {
            for (Map.Entry entry : tm.entrySet()) {
                String key = (String)entry.getKey();
                List list = (List)treeMap.get(key);
                if (null == list) {
                    treeMap.put(key, entry.getValue());
                    continue;
                }
                list.addAll((Collection)entry.getValue());
            }
        }
        Collection values = treeMap.values();
        ArrayList<String> sortedIDs = new ArrayList<String>(values.size() + accountSubfolderIDs.size());
        for (List list : values) {
            for (String id : list) {
                sortedIDs.add(id);
            }
        }
        if (unifiedMailIndex >= 0) {
            sortedIDs.add(0, (String)accountSubfolderIDs.remove(unifiedMailIndex));
        }
        sortedIDs.addAll(accountSubfolderIDs);
        sortedIDs.addAll(messagingSubfolderIDs);
        int size = sortedIDs.size();
        SortableId[] ret = new SortableId[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = new OutlookId((String)sortedIDs.get(i), i, null);
        }
        return ret;
    }

    static void put2TreeMap(String localizedName, String id, TreeMap<String, List<String>> treeMap) {
        List<String> list = treeMap.get(localizedName);
        if (null == list) {
            list = new ArrayList<String>(2);
            treeMap.put(localizedName, list);
        }
        list.add(id);
    }

    static StorageParameters newStorageParameters(StorageParameters source) {
        Session session = source.getSession();
        if (null == session) {
            return new StorageParametersImpl(source.getUser(), source.getContext());
        }
        return new StorageParametersImpl((ServerSession)session);
    }

    @Override
    public ContentType[] getSupportedContentTypes() {
        return new ContentType[0];
    }

    @Override
    public void rollback(StorageParameters params) {
    }

    @Override
    public boolean startTransaction(StorageParameters parameters, boolean modify) {
        return false;
    }

    @Override
    public void updateFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        TCM.clear();
        int contextId = storageParameters.getContextId();
        int tree = Tools.getUnsignedInteger(folder.getTreeID());
        int userId = storageParameters.getUserId();
        String folderId = folder.getID();
        boolean contains = Select.containsFolder(contextId, tree, userId, folderId, StorageType.WORKING, OutlookFolderStorage.checkReadConnection(storageParameters));
        if (contains) {
            Connection wcon = OutlookFolderStorage.checkWriteConnection(storageParameters);
            if (wcon == null) {
                Connection con;
                DatabaseService databaseService = Utility.getDatabaseService();
                try {
                    con = databaseService.getWritable(contextId);
                    con.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
                }
                try {
                    String newId;
                    String parentId;
                    String name = folder.getName();
                    if (name != null) {
                        Update.updateName(contextId, tree, userId, folderId, name, con);
                    }
                    if ((parentId = folder.getParentID()) != null) {
                        Update.updateParent(contextId, tree, userId, folderId, parentId, con);
                    }
                    if ((newId = folder.getNewID()) != null) {
                        Update.updateId(contextId, tree, userId, folderId, newId, con);
                    }
                    Update.updateLastModified(contextId, tree, userId, folderId, System.currentTimeMillis(), con);
                    MemoryTable memoryTable = MemoryTable.optMemoryTableFor(storageParameters.getSession());
                    if (null != memoryTable) {
                        memoryTable.initializeTree(tree, userId, contextId, con);
                    }
                    con.commit();
                }
                catch (SQLException e) {
                    DBUtils.rollback(con);
                    throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
                }
                catch (OXException e) {
                    DBUtils.rollback(con);
                    throw e;
                }
                catch (Exception e) {
                    DBUtils.rollback(con);
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
                }
                finally {
                    DBUtils.autocommit(con);
                    databaseService.backWritable(contextId, con);
                }
            }
            try {
                String newId;
                String parentId;
                String name = folder.getName();
                if (name != null) {
                    Update.updateName(contextId, tree, userId, folderId, name, wcon);
                }
                if ((parentId = folder.getParentID()) != null) {
                    Update.updateParent(contextId, tree, userId, folderId, parentId, wcon);
                }
                if ((newId = folder.getNewID()) != null) {
                    Update.updateId(contextId, tree, userId, folderId, newId, wcon);
                }
                Update.updateLastModified(contextId, tree, userId, folderId, System.currentTimeMillis(), wcon);
                MemoryTable memoryTable = MemoryTable.optMemoryTableFor(storageParameters.getSession());
                if (null != memoryTable) {
                    memoryTable.initializeTree(tree, userId, contextId, wcon);
                }
            }
            catch (OXException e) {
                throw e;
            }
            catch (Exception e) {
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        }
    }

    private static List<String> toIDList(SortableId[] ids) {
        ArrayList<String> l = new ArrayList<String>(ids.length);
        for (SortableId id : ids) {
            l.add(id.getId());
        }
        return l;
    }

    private static SortableId[] getSubfolderIDs(Folder realFolder, FolderStorage folderStorage, StorageParameters storageParameters) throws OXException {
        return folderStorage.getSubfolders(realFolder.getTreeID(), realFolder.getID(), storageParameters);
    }

    String getLocalizedName(String id, int tree, Locale locale, FolderStorage folderStorage, StorageParameters storageParameters) throws OXException {
        Session session = storageParameters.getSession();
        MemoryTable memoryTable = MemoryTable.getMemoryTableFor(session);
        MemoryTree memoryTree = memoryTable.getTree(tree, session);
        String name = memoryTree.getFolderName(id);
        if (null != name) {
            return name;
        }
        return folderStorage.getFolder(this.realTreeId, id, storageParameters).getLocalizedName(locale);
    }

    static Connection checkReadConnection(StorageParameters storageParameters) {
        DatabaseFolderStorage.ConnectionMode con = (DatabaseFolderStorage.ConnectionMode)storageParameters.getParameter(DatabaseFolderType.getInstance(), "DB.Con");
        return null == con ? null : con.connection;
    }

    static Connection checkWriteConnection(StorageParameters storageParameters) {
        DatabaseFolderStorage.ConnectionMode con = (DatabaseFolderStorage.ConnectionMode)storageParameters.getParameter(DatabaseFolderType.getInstance(), "DB.Con");
        if (null != con && con.readWrite) {
            return con.connection;
        }
        return null;
    }

    private static Locale localeFrom(Session session) {
        if (null == session) {
            return Locale.US;
        }
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUser().getLocale();
        }
        return UserStorage.getStorageUser(session.getUserId(), session.getContextId()).getLocale();
    }

    private static void doModifications(OutlookFolder folder, Session session, boolean altNames) {
        String id = folder.getID();
        if (FolderStorage.PUBLIC_ID.equals(id)) {
            folder.setParentID(FolderStorage.PRIVATE_ID);
        } else if (FolderStorage.SHARED_ID.equals(id)) {
            folder.setParentID(FolderStorage.PRIVATE_ID);
        } else if (INFOSTORE.equals(id)) {
            folder.setParentID(FolderStorage.PRIVATE_ID);
            folder.setSubfolderIDs(null);
        } else if (OutlookFolderStorage.isDefaultMailFolder(folder)) {
            folder.setParentID(FolderStorage.PRIVATE_ID);
        } else if (OutlookFolderStorage.isNonPrimaryMailAccountFolder(folder)) {
            folder.setParentID(FolderStorage.PRIVATE_ID);
        } else if (PREPARED_FULLNAME_DEFAULT.equals(folder.getParentID())) {
            folder.setParentID(FolderStorage.PRIVATE_ID);
        } else if (OutlookFolderStorage.isDefaultFileStorageFolder(folder)) {
            folder.setParentID(INFOSTORE);
        } else if (OutlookFolderStorage.showPersonalBelowInfoStore(session, altNames) && id.equals(OutlookFolderStorage.getDefaultInfoStoreFolderId(session))) {
            folder.setParentID(INFOSTORE);
            folder.setName("My files");
        }
    }

    private static boolean isDefaultFileStorageFolder(OutlookFolder folder) {
        if (MODULE_FILE != folder.getContentType().getModule()) {
            return false;
        }
        try {
            FileStorageFolderIdentifier fsfi = new FileStorageFolderIdentifier(folder.getID());
            return 0 == fsfi.getFolderId().length() && fsfi.getServiceId().indexOf(SERVICE_INFOSTORE) < 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isDefaultMailFolder(OutlookFolder folder) {
        if (!folder.isDefault() || MODULE_MAIL != folder.getContentType().getModule()) {
            return false;
        }
        String id = folder.getID();
        try {
            FullnameArgument arg = MailFolderUtility.prepareMailFolderParam(id);
            return 0 == arg.getAccountId();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private static boolean isNonPrimaryMailAccountFolder(OutlookFolder folder) {
        String id = folder.getID();
        if (!id.startsWith("default")) {
            return false;
        }
        try {
            FullnameArgument arg = MailFolderUtility.prepareMailFolderParam(id);
            return "default".equals(arg.getFullname()) && arg.getAccountId() != 0;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private FolderStorage getOpenedStorage(String id, String treeId, boolean modify, StorageParameters storageParameters, Collection<FolderStorage> openedStorages) throws OXException {
        for (FolderStorage ps : openedStorages) {
            if (!ps.getFolderType().servesFolderId(id)) continue;
            return ps;
        }
        FolderStorage tmp = this.folderStorageRegistry.getFolderStorage(treeId, id);
        if (null == tmp) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, id);
        }
        if (tmp.startTransaction(storageParameters, modify)) {
            openedStorages.add(tmp);
        }
        return tmp;
    }

    private static void addWarnings(StorageParameters storageParameters, WarningsAware warningsAware) {
        List list = warningsAware.getAndFlushWarnings();
        if (null != list && !list.isEmpty()) {
            for (OXException warning : list) {
                storageParameters.addWarning(warning);
            }
        }
    }

    static {
        TimeoutConcurrentMap tcm;
        INFOSTORE = Integer.toString(9);
        INFOSTORE_USER = Integer.toString(10);
        INFOSTORE_PUBLIC = Integer.toString(15);
        SYSTEM_INFOSTORES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(INFOSTORE, INFOSTORE_PUBLIC, INFOSTORE_USER)));
        LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(OutlookFolderStorage.class));
        PREPARED_FULLNAME_INBOX = MailFolderUtility.prepareFullname(0, "INBOX");
        PREPARED_FULLNAME_DEFAULT = MailFolderUtility.prepareFullname(0, "default");
        FACTORY = new ThreadPools.ExpectedExceptionFactory<OXException>(){

            public Class<OXException> getType() {
                return OXException.class;
            }

            public OXException newUnexpectedError(Throwable t) {
                return FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(t, t.getMessage());
            }
        };
        try {
            tcm = new TimeoutConcurrentMap(10, true);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            tcm = null;
        }
        TCM = tcm;
        INSTANCE = new OutlookFolderStorage();
        MODULE_FILE = FileStorageContentType.getInstance().getModule();
        MODULE_MAIL = MailContentType.getInstance().getModule();
    }

    private static abstract class TrackableCallable<V>
    implements Callable<V>,
    Trackable {
        private final Props props = LogProperties.optLogProperties((Thread)Thread.currentThread());

        TrackableCallable() {
        }

        public Props optLogProperties() {
            return this.props;
        }
    }

    private static final class FolderNameComparator
    implements Comparator<String> {
        private final Collator collator;

        public FolderNameComparator(Locale locale) {
            this.collator = Collator.getInstance(locale == null ? Locale.US : locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(String o1, String o2) {
            return this.collator.compare(o1, o2);
        }
    }

    private static final class FileStorageAccountComparator
    implements Comparator<FileStorageAccount> {
        private final Collator collator;

        public FileStorageAccountComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(FileStorageAccount o1, FileStorageAccount o2) {
            return this.collator.compare(o1.getDisplayName(), o2.getDisplayName());
        }
    }

    private static final class MessagingAccountComparator
    implements Comparator<MessagingAccount> {
        private final Collator collator;

        public MessagingAccountComparator(Locale locale) {
            this.collator = Collator.getInstance(locale == null ? Locale.US : locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(MessagingAccount o1, MessagingAccount o2) {
            return this.collator.compare(o1.getDisplayName(), o2.getDisplayName());
        }
    }

    private static final class MailAccountComparator
    implements Comparator<MailAccount> {
        private final Collator collator;

        public MailAccountComparator(Locale locale) {
            this.collator = Collator.getInstance(locale == null ? Locale.US : locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(MailAccount o1, MailAccount o2) {
            if (UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX.equals(o1.getMailProtocol())) {
                if (UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX.equals(o2.getMailProtocol())) {
                    return 0;
                }
                return -1;
            }
            if (UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX.equals(o2.getMailProtocol())) {
                return 1;
            }
            if (o1.isDefaultAccount()) {
                if (o2.isDefaultAccount()) {
                    return 0;
                }
                return -1;
            }
            if (o2.isDefaultAccount()) {
                return 1;
            }
            return this.collator.compare(o1.getName(), o2.getName());
        }
    }

    private final class MailFolderCallable
    implements Callable<TreeMap<String, List<String>>>,
    Trackable {
        private final FolderNameComparator comparator;
        private final Locale locale;
        private final User user;
        private final int contextId;
        private final int tree;
        private final StorageParameters parameters;
        private final Props props = LogProperties.optLogProperties((Thread)Thread.currentThread());

        public MailFolderCallable(FolderNameComparator comparator, Locale locale, User user, int contextId, int tree, StorageParameters parameters) {
            this.comparator = comparator;
            this.locale = locale == null ? Locale.US : locale;
            this.user = user;
            this.contextId = contextId;
            this.tree = tree;
            this.parameters = parameters;
        }

        public Props optLogProperties() {
            return this.props;
        }

        @Override
        public TreeMap<String, List<String>> call() throws OXException {
            String fullname = PREPARED_FULLNAME_DEFAULT;
            FolderStorage realFolderStorage = OutlookFolderStorage.this.folderStorageRegistry.getFolderStorage(OutlookFolderStorage.this.realTreeId, fullname);
            if (null == realFolderStorage) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(OutlookFolderStorage.this.realTreeId, fullname);
            }
            StorageParameters storageParameters = OutlookFolderStorage.newStorageParameters(this.parameters);
            boolean started = realFolderStorage.startTransaction(storageParameters, false);
            try {
                SortableId[] mailIDs;
                try {
                    mailIDs = OutlookFolderStorage.this.getSubfolders(fullname, OutlookFolderStorage.this.realTreeId, realFolderStorage, storageParameters);
                    Set<OXException> warnings = storageParameters.getWarnings();
                    if (!warnings.isEmpty()) {
                        for (OXException warning : warnings) {
                            this.parameters.addWarning(warning);
                        }
                    }
                }
                catch (OXException e) {
                    if (MailExceptionCode.UNKNOWN_PROTOCOL.equals(e)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)e.getMessage(), (Throwable)e);
                        }
                        this.parameters.addWarning(e);
                        return new TreeMap<String, List<String>>(this.comparator);
                    }
                    if (MailExceptionCode.ACCOUNT_DOES_NOT_EXIST.equals(e)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)e.getMessage(), (Throwable)e);
                        }
                        this.parameters.addWarning(e);
                        return new TreeMap<String, List<String>>(this.comparator);
                    }
                    if (MimeMailExceptionCode.INVALID_CREDENTIALS.equals(e) || MimeMailExceptionCode.LOGIN_FAILED.equals(e)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)e.getMessage(), (Throwable)e);
                        }
                        this.parameters.addWarning(e);
                        return new TreeMap<String, List<String>>(this.comparator);
                    }
                    if (MimeMailExceptionCode.CONNECT_ERROR.equals(e) || MimeMailExceptionCode.UNKNOWN_HOST.equals(e)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)e.getMessage(), (Throwable)e);
                        }
                        this.parameters.addWarning(e);
                        return new TreeMap<String, List<String>>(this.comparator);
                    }
                    throw e;
                }
                TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(this.comparator);
                String publicFolderPath = OutlookFolderStorage.this.getPublicMailFolderPath();
                for (SortableId sortableId : mailIDs) {
                    String id = sortableId.getId();
                    if (id.equals(publicFolderPath)) continue;
                    String name = sortableId.getName();
                    if (null == name) {
                        OutlookFolderStorage.put2TreeMap(OutlookFolderStorage.this.getLocalizedName(id, this.tree, this.locale, realFolderStorage, storageParameters), id, treeMap);
                        continue;
                    }
                    OutlookFolderStorage.put2TreeMap(name, id, treeMap);
                }
                HashSet<String> defIds = new HashSet<String>(6);
                String treeId = OutlookFolderStorage.this.realTreeId;
                MailType mailType = MailType.getInstance();
                defIds.add(realFolderStorage.getDefaultFolderID(this.user, treeId, TrashContentType.getInstance(), mailType, storageParameters));
                defIds.add(realFolderStorage.getDefaultFolderID(this.user, treeId, DraftsContentType.getInstance(), mailType, storageParameters));
                defIds.add(realFolderStorage.getDefaultFolderID(this.user, treeId, SentContentType.getInstance(), mailType, storageParameters));
                defIds.add(realFolderStorage.getDefaultFolderID(this.user, treeId, SpamContentType.getInstance(), mailType, storageParameters));
                SortableId[] inboxSubfolders = realFolderStorage.getSubfolders(OutlookFolderStorage.this.realTreeId, PREPARED_FULLNAME_INBOX, storageParameters);
                MemoryTable memoryTable = MemoryTable.getMemoryTableFor(storageParameters.getSession());
                boolean[] contained = memoryTable.getTree(this.tree, this.user.getId(), this.contextId).containsFolders(inboxSubfolders);
                for (int i = 0; i < inboxSubfolders.length; ++i) {
                    SortableId sortableId;
                    String id;
                    if (contained[i] || !defIds.contains(id = (sortableId = inboxSubfolders[i]).getId())) continue;
                    String name = sortableId.getName();
                    if (null == name) {
                        OutlookFolderStorage.put2TreeMap(OutlookFolderStorage.this.getLocalizedName(id, this.tree, this.locale, realFolderStorage, storageParameters), id, treeMap);
                        continue;
                    }
                    OutlookFolderStorage.put2TreeMap(name, sortableId.getId(), treeMap);
                }
                if (started) {
                    realFolderStorage.commitTransaction(storageParameters);
                }
                return treeMap;
            }
            catch (OXException e) {
                if (started) {
                    realFolderStorage.rollback(storageParameters);
                }
                throw e;
            }
            catch (Exception e) {
                if (started) {
                    realFolderStorage.rollback(storageParameters);
                }
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        }
    }

    private static final class Key {
        private final int tree;
        private final int userId;
        private final int contextId;
        private final String id;
        private final int hash;

        protected Key(String id, int tree, int userId, int contextId) {
            this.id = id;
            this.tree = tree;
            this.userId = userId;
            this.contextId = contextId;
            int prime = 31;
            int result = 1;
            result = 31 * result + (null == id ? 0 : id.hashCode());
            result = 31 * result + contextId;
            result = 31 * result + tree;
            this.hash = result = 31 * result + userId;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (null == this.id ? null != other.id : !this.id.equals(other.id)) {
                return false;
            }
            if (this.contextId != other.contextId) {
                return false;
            }
            if (this.tree != other.tree) {
                return false;
            }
            return this.userId == other.userId;
        }
    }
}

