/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class StorageParametersImpl
implements StorageParameters {
    private static final Object PRESENT = new Object();
    private final ServerSession session;
    private FolderServiceDecorator decorator;
    private final User user;
    private final int userId;
    private final Context context;
    private final int contextId;
    private final ConcurrentMap<FolderType, ConcurrentMap<String, Object>> parameters;
    private Date timeStamp;
    private Thread usingThread;
    private StackTraceElement[] trace;
    private final Map<OXException, Object> warnings;

    public StorageParametersImpl(ServerSession session) {
        this.session = session;
        this.user = session.getUser();
        this.userId = null == this.user ? -1 : this.user.getId();
        this.context = session.getContext();
        this.contextId = null == this.context ? -1 : this.context.getContextId();
        this.parameters = new ConcurrentHashMap<FolderType, ConcurrentMap<String, Object>>();
        this.warnings = new ConcurrentHashMap<OXException, Object>(2);
    }

    public StorageParametersImpl(User user, Context context) {
        this.session = null;
        this.user = user;
        this.userId = user.getId();
        this.context = context;
        this.contextId = context.getContextId();
        this.parameters = new ConcurrentHashMap<FolderType, ConcurrentMap<String, Object>>();
        this.warnings = new ConcurrentHashMap<OXException, Object>(2);
    }

    public StorageParametersImpl(StorageParameters source) {
        Session s = source.getSession();
        if (null == s) {
            this.user = source.getUser();
            this.session = null;
            this.userId = this.user.getId();
            this.context = source.getContext();
            this.contextId = this.context.getContextId();
        } else {
            try {
                this.session = s instanceof ServerSession ? (ServerSession)s : ServerSessionAdapter.valueOf(s);
                this.user = this.session.getUser();
                this.userId = this.user.getId();
                this.context = this.session.getContext();
                this.contextId = this.context.getContextId();
            }
            catch (OXException e) {
                throw new IllegalStateException(e);
            }
        }
        this.parameters = new ConcurrentHashMap<FolderType, ConcurrentMap<String, Object>>();
        this.warnings = new ConcurrentHashMap<OXException, Object>(2);
    }

    private ConcurrentMap<String, Object> getFolderTypeMap(FolderType folderType, boolean createIfAbsent) {
        ConcurrentHashMap inst;
        ConcurrentHashMap m = (ConcurrentHashMap)this.parameters.get(folderType);
        if (createIfAbsent && null == m && null == (m = (ConcurrentMap)this.parameters.putIfAbsent(folderType, inst = new ConcurrentHashMap()))) {
            m = inst;
        }
        return m;
    }

    @Override
    public void addWarning(OXException warning) {
        warning.addCategory(Category.CATEGORY_WARNING);
        this.warnings.put(warning, PRESENT);
    }

    @Override
    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    @Override
    public Set<OXException> getWarnings() {
        return Collections.unmodifiableSet(this.warnings.keySet());
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public <P> P getParameter(FolderType folderType, String name) {
        ConcurrentMap<String, Object> m = this.getFolderTypeMap(folderType, false);
        if (null == m) {
            return null;
        }
        try {
            Object retval = m.get(name);
            return (P)retval;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public <P> P removeParameter(FolderType folderType, String name) {
        ConcurrentMap<String, Object> m = this.getFolderTypeMap(folderType, false);
        if (null == m) {
            return null;
        }
        try {
            Object retval = m.remove(name);
            return (P)retval;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public void putParameter(FolderType folderType, String name, Object value) {
        if (null == value) {
            ConcurrentMap<String, Object> m = this.getFolderTypeMap(folderType, false);
            if (null == m) {
                return;
            }
            m.remove(name);
        } else {
            ConcurrentMap<String, Object> m = this.getFolderTypeMap(folderType, true);
            m.put(name, value);
        }
    }

    @Override
    public boolean putParameterIfAbsent(FolderType folderType, String name, Object value) {
        if (null == value) {
            throw new IllegalArgumentException("value is null");
        }
        ConcurrentMap<String, Object> m = this.getFolderTypeMap(folderType, true);
        return null == m.putIfAbsent(name, value);
    }

    @Override
    public Date getTimeStamp() {
        return null == this.timeStamp ? null : new Date(this.timeStamp.getTime());
    }

    @Override
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = null == timeStamp ? null : new Date(timeStamp.getTime());
    }

    @Override
    public FolderServiceDecorator getDecorator() {
        return this.decorator;
    }

    @Override
    public void setDecorator(FolderServiceDecorator decorator) {
        this.decorator = decorator;
    }

    @Override
    public int getContextId() {
        return this.contextId;
    }

    @Override
    public int getUserId() {
        return this.userId;
    }

    @Override
    public void markCommitted() {
        this.usingThread = Thread.currentThread();
        this.trace = new Throwable().getStackTrace();
    }

    @Override
    public String getCommittedTrace() {
        StringBuilder sBuilder = new StringBuilder(512);
        sBuilder.append(this.toString());
        sBuilder.append("\nStorage parameters committed at: ").append('\n');
        String delim = "\tat ";
        for (int i = 2; i < this.trace.length; ++i) {
            sBuilder.append("\tat ").append(this.trace[i]).append('\n');
        }
        if (null != this.usingThread && this.usingThread.isAlive()) {
            sBuilder.append("Currently using thread: ").append(this.usingThread.getName()).append('\n');
            StackTraceElement[] trace = this.usingThread.getStackTrace();
            sBuilder.append("\tat ").append(trace[0]);
            String prefix = "\n\tat ";
            for (int i = 1; i < trace.length; ++i) {
                sBuilder.append("\n\tat ").append(trace[i]);
            }
        }
        return sBuilder.toString();
    }
}

