/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.concurrent.CallerRunsCompletionService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.RemoveAfterAccessFolder;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.StoragePriority;
import com.openexchange.folderstorage.StorageType;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.cache.CacheFolderStorageRegistry;
import com.openexchange.folderstorage.cache.CacheFolderType;
import com.openexchange.folderstorage.cache.CacheServiceRegistry;
import com.openexchange.folderstorage.cache.CacheSortableId;
import com.openexchange.folderstorage.cache.lock.TreeLockManagement;
import com.openexchange.folderstorage.cache.memory.FolderMap;
import com.openexchange.folderstorage.cache.memory.FolderMapManagement;
import com.openexchange.folderstorage.database.DatabaseFolderType;
import com.openexchange.folderstorage.internal.StorageParametersImpl;
import com.openexchange.folderstorage.internal.performers.ClearPerformer;
import com.openexchange.folderstorage.internal.performers.CreatePerformer;
import com.openexchange.folderstorage.internal.performers.DeletePerformer;
import com.openexchange.folderstorage.internal.performers.InstanceStorageParametersProvider;
import com.openexchange.folderstorage.internal.performers.PathPerformer;
import com.openexchange.folderstorage.internal.performers.SessionStorageParametersProvider;
import com.openexchange.folderstorage.internal.performers.StorageParametersProvider;
import com.openexchange.folderstorage.internal.performers.UpdatePerformer;
import com.openexchange.folderstorage.internal.performers.UpdatesPerformer;
import com.openexchange.folderstorage.mail.MailFolderType;
import com.openexchange.groupware.ldap.User;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.osgi.ServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.threadpool.RefusedExecutionBehavior;
import com.openexchange.threadpool.ThreadPoolCompletionService;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.threadpool.behavior.AbortBehavior;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.commons.logging.Log;

public final class CacheFolderStorage
implements FolderStorage {
    protected static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(CacheFolderStorage.class));
    private static final ThreadPools.ExpectedExceptionFactory<OXException> FACTORY = new ThreadPools.ExpectedExceptionFactory<OXException>(){

        public Class<OXException> getType() {
            return OXException.class;
        }

        public OXException newUnexpectedError(Throwable t) {
            return FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(t, t.getMessage());
        }
    };
    private static final CacheFolderStorage INSTANCE = new CacheFolderStorage();
    private final String realTreeId = REAL_TREE_ID;
    private final CacheFolderStorageRegistry registry = CacheFolderStorageRegistry.getInstance();
    private volatile CacheService cacheService;
    private volatile Cache globalCache;
    protected static final Set<String> IGNORABLES = RemoveAfterAccessFolder.IGNORABLES;
    private static volatile Integer maxWaitMillis;

    public static CacheFolderStorage getInstance() {
        return INSTANCE;
    }

    private CacheFolderStorage() {
    }

    public void clearAll() {
        Cache cache = this.globalCache;
        if (null != cache) {
            try {
                cache.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FolderMapManagement.getInstance().clear();
    }

    public void removeFromGlobalCache(String folderId, String treeId, int contextId) {
        Cache cache = this.globalCache;
        if (null != cache) {
            cache.removeFromGroup((Serializable)this.newCacheKey(folderId, treeId), Integer.toString(contextId));
        }
    }

    @Override
    public void clearCache(int userId, int contextId) {
        if (contextId <= 0) {
            return;
        }
        Cache cache = this.globalCache;
        if (null != cache) {
            cache.invalidateGroup(Integer.toString(contextId));
        }
        if (userId > 0) {
            CacheFolderStorage.dropUserEntries(userId, contextId);
        } else {
            FolderMapManagement.getInstance().dropFor(contextId);
        }
    }

    public void clear(Session session) {
        this.clearCache(session.getUserId(), session.getContextId());
    }

    public void onCacheAvailable() throws OXException {
        this.cacheService = (CacheService)CacheServiceRegistry.getServiceRegistry().getService(CacheService.class, true);
        this.globalCache = this.cacheService.getCache("GlobalFolderCache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheAbsent() throws OXException {
        CacheService service = this.cacheService;
        Cache cache = this.globalCache;
        if (cache != null) {
            try {
                cache.clear();
                if (null != service) {
                    service.freeCache("GlobalFolderCache");
                }
            }
            finally {
                this.globalCache = null;
            }
        }
        if (service != null) {
            this.cacheService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkConsistency(String treeId, final StorageParameters storageParameters) throws OXException {
        Lock rlock = CacheFolderStorage.readLockFor(treeId, storageParameters);
        CacheFolderStorage.acquire(rlock);
        try {
            for (FolderStorage folderStorage : this.registry.getFolderStoragesForTreeID(treeId)) {
                boolean started = folderStorage.startTransaction(storageParameters, false);
                try {
                    folderStorage.checkConsistency(treeId, storageParameters);
                    if (!started) continue;
                    folderStorage.commitTransaction(storageParameters);
                }
                catch (OXException e) {
                    if (started) {
                        folderStorage.rollback(storageParameters);
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (started) {
                        folderStorage.rollback(storageParameters);
                    }
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
                }
            }
            final String realTreeId = this.realTreeId;
            if (realTreeId.equals(treeId)) {
                try {
                    final ServerSession session = ServerSessionAdapter.valueOf(storageParameters.getSession());
                    final ServiceRegistry serviceRegistry = CacheServiceRegistry.getServiceRegistry();
                    final ThreadPoolService threadPool = ThreadPools.getThreadPool();
                    final RefusedExecutionBehavior behavior = AbortBehavior.getInstance();
                    final Log log = LOG;
                    final boolean debugEnabled = log.isDebugEnabled();
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                long st = debugEnabled ? System.currentTimeMillis() : 0L;
                                final StorageParameters params = CacheFolderStorage.newStorageParameters(storageParameters);
                                params.putParameter(MailFolderType.getInstance(), "__accessFast", Boolean.FALSE);
                                if (session.getUserConfiguration().isMultipleMailAccounts()) {
                                    MailAccountStorageService storageService = (MailAccountStorageService)serviceRegistry.getService(MailAccountStorageService.class, true);
                                    MailAccount[] accounts = storageService.getUserMailAccounts(session.getUserId(), session.getContextId());
                                    ArrayList<1> tasks2 = new ArrayList<1>(accounts.length);
                                    for (final MailAccount mailAccount : accounts) {
                                        String folderId;
                                        Folder rootFolder;
                                        int accountId = mailAccount.getId();
                                        if (accountId == 0 || IGNORABLES.contains(mailAccount.getMailProtocol()) || null != (rootFolder = CacheFolderStorage.this.getRefFromCache(realTreeId, folderId = MailFolderUtility.prepareFullname(accountId, "default"), params))) continue;
                                        Runnable mailAccountTask = new Runnable(){

                                            @Override
                                            public void run() {
                                                try {
                                                    long st2 = debugEnabled ? System.currentTimeMillis() : 0L;
                                                    Folder rootFolder = CacheFolderStorage.this.loadFolder(realTreeId, folderId, StorageType.WORKING, params);
                                                    CacheFolderStorage.this.putFolder(rootFolder, realTreeId, params, false);
                                                    String[] subfolderIDs = rootFolder.getSubfolderIDs();
                                                    if (null != subfolderIDs) {
                                                        for (String subfolderId : subfolderIDs) {
                                                            Folder folder = CacheFolderStorage.this.loadFolder(realTreeId, subfolderId, StorageType.WORKING, params);
                                                            CacheFolderStorage.this.putFolder(folder, realTreeId, params, false);
                                                        }
                                                    }
                                                    if (debugEnabled) {
                                                        StringAllocator tmp = new StringAllocator(64);
                                                        tmp.append("CacheFolderStorage.checkConsistency(): ");
                                                        tmp.append("Loading external root folder \"");
                                                        tmp.append(mailAccount.generateMailServerURL()).append("\" took ");
                                                        tmp.append(System.currentTimeMillis() - st2).append("msec");
                                                        log.debug((Object)tmp.toString());
                                                    }
                                                }
                                                catch (Exception e) {
                                                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                                                }
                                            }
                                        };
                                        tasks2.add(mailAccountTask);
                                    }
                                    if (!tasks2.isEmpty()) {
                                        for (Runnable runnable : tasks2) {
                                            threadPool.submit(ThreadPools.trackableTask((Runnable)runnable), behavior);
                                        }
                                    }
                                }
                                if (debugEnabled) {
                                    StringAllocator tmp = new StringAllocator(64);
                                    tmp.append("CacheFolderStorage.checkConsistency(): Submitting loading external root folders took ");
                                    tmp.append(System.currentTimeMillis() - st).append("msec");
                                    log.debug((Object)tmp.toString());
                                }
                            }
                            catch (Exception e) {
                                LOG.debug((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    };
                    threadPool.submit(ThreadPools.trackableTask((Runnable)task), behavior);
                }
                catch (Exception e) {
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            rlock.unlock();
        }
    }

    protected static void checkOpenedStorage(FolderStorage checkMe, StorageParameters params, boolean modify, Collection<FolderStorage> openedStorages) throws OXException {
        if (openedStorages.contains(checkMe)) {
            return;
        }
        if (checkMe.startTransaction(params, modify)) {
            openedStorages.add(checkMe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        Lock lock = CacheFolderStorage.writeLockFor(treeId, storageParameters);
        CacheFolderStorage.acquire(lock);
        try {
            FolderStorage storage = this.registry.getFolderStorage(treeId, folderId);
            if (null == storage) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
            }
            boolean started = storage.startTransaction(storageParameters, false);
            try {
                storage.restore(treeId, folderId, storageParameters);
                if (started) {
                    storage.commitTransaction(storageParameters);
                }
            }
            catch (OXException e) {
                if (started) {
                    storage.rollback(storageParameters);
                }
                throw e;
            }
            catch (Exception e) {
                if (started) {
                    storage.rollback(storageParameters);
                }
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
            finally {
                this.clear(storageParameters.getSession());
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Folder prepareFolder(String treeId, Folder folder, StorageParameters storageParameters) throws OXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PathPerformer newPathPerformer(StorageParameters storageParameters) throws OXException {
        Session session = storageParameters.getSession();
        if (null == session) {
            return new PathPerformer(storageParameters.getUser(), storageParameters.getContext(), null, this.registry);
        }
        return new PathPerformer(ServerSessionAdapter.valueOf(session), null, (FolderStorageDiscoverer)this.registry);
    }

    @Override
    public ContentType getDefaultContentType() {
        return null;
    }

    @Override
    public void commitTransaction(StorageParameters params) throws OXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        String treeId = folder.getTreeID();
        Lock lock = CacheFolderStorage.writeLockFor(treeId, storageParameters);
        CacheFolderStorage.acquire(lock);
        try {
            Folder parentFolder;
            CacheKey cacheKey;
            Session session = storageParameters.getSession();
            CreatePerformer createPerformer = null == session ? new CreatePerformer(storageParameters.getUser(), storageParameters.getContext(), storageParameters.getDecorator(), this.registry) : new CreatePerformer(ServerSessionAdapter.valueOf(session), storageParameters.getDecorator(), (FolderStorageDiscoverer)this.registry);
            createPerformer.setCheck4Duplicates(false);
            String folderId = createPerformer.doCreate(folder);
            FolderStorage storage = this.registry.getFolderStorage(treeId, folderId);
            if (null == storage) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
            }
            int contextId = storageParameters.getContextId();
            Folder createdFolder = null;
            try {
                createdFolder = this.loadFolder(this.realTreeId, folderId, StorageType.WORKING, true, storageParameters);
                if (createdFolder.isCacheable()) {
                    this.putFolder(createdFolder, this.realTreeId, storageParameters, false);
                }
            }
            catch (OXException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)"Newly created folder could not be loaded from appropriate storage.", (Throwable)e);
                }
                LOG.warn((Object)"Newly created folder could not be loaded from appropriate storage.");
            }
            FolderMapManagement folderMapManagement = FolderMapManagement.getInstance();
            Cache cache = this.globalCache;
            String sContextId = Integer.toString(contextId);
            int userId = storageParameters.getUserId();
            for (String tid : new String[]{treeId, this.realTreeId}) {
                cacheKey = this.newCacheKey(folder.getParentID(), tid);
                cache.removeFromGroup((Serializable)cacheKey, sContextId);
                folderMapManagement.dropFor(folder.getParentID(), treeId, userId, contextId, session);
                folderMapManagement.dropFor(folder.getParentID(), this.realTreeId, userId, contextId, session);
            }
            if (null != createdFolder) {
                for (String tid : new String[]{treeId, this.realTreeId}) {
                    cacheKey = this.newCacheKey(createdFolder.getParentID(), tid);
                    cache.removeFromGroup((Serializable)cacheKey, sContextId);
                    folderMapManagement.dropFor(folder.getParentID(), treeId, userId, contextId, session);
                    folderMapManagement.dropFor(folder.getParentID(), this.realTreeId, userId, contextId, session);
                }
            }
            if ((parentFolder = this.loadFolder(this.realTreeId, folder.getParentID(), StorageType.WORKING, true, storageParameters)).isCacheable()) {
                this.putFolder(parentFolder, this.realTreeId, storageParameters, true);
            }
            if (null != createdFolder && (parentFolder = this.loadFolder(this.realTreeId, createdFolder.getParentID(), StorageType.WORKING, true, storageParameters)).isCacheable()) {
                this.putFolder(parentFolder, this.realTreeId, storageParameters, true);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void putFolder(Folder folder, String treeId, StorageParameters storageParameters, boolean invalidate) throws OXException {
        if (folder.isGlobalID()) {
            this.globalCache.putInGroup((Serializable)this.newCacheKey(folder.getID(), treeId), Integer.toString(storageParameters.getContextId()), (Serializable)folder, invalidate);
        } else {
            CacheFolderStorage.getFolderMapFor(storageParameters.getSession()).put(treeId, folder, storageParameters.getSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(String id, String treeId, boolean singleOnly, Session session) throws OXException {
        Lock lock = TreeLockManagement.getInstance().getFor(treeId, session).writeLock();
        CacheFolderStorage.acquire(lock);
        try {
            if (singleOnly) {
                this.removeSingleFromCache(id, treeId, session.getUserId(), session, true);
            } else {
                this.removeFromCache(id, treeId, session, new PathPerformer(ServerSessionAdapter.valueOf(session), null, (FolderStorageDiscoverer)this.registry));
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void removeFromCache(String id, String treeId, Session session, PathPerformer pathPerformer) throws OXException {
        List<String> ids;
        if (null == id) {
            return;
        }
        try {
            if (this.existsFolder(treeId, id, StorageType.WORKING, pathPerformer.getStorageParameters())) {
                UserizedFolder[] path = pathPerformer.doPath(treeId, id, true);
                ids = new ArrayList<String>(path.length);
                for (UserizedFolder userizedFolder : path) {
                    ids.add(userizedFolder.getID());
                }
            } else {
                ids = Collections.singletonList(id);
            }
        }
        catch (Exception e) {
            Log log = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(CacheFolderStorage.class));
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            try {
                ids = new ArrayList<String>(Arrays.asList(pathPerformer.doForcePath(treeId, id, true)));
            }
            catch (Exception e1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e1.getMessage(), (Throwable)e1);
                }
                ids = Collections.singletonList(id);
            }
        }
        int contextId = session.getContextId();
        int userId = session.getUserId();
        Cache cache = this.globalCache;
        FolderMapManagement folderMapManagement = FolderMapManagement.getInstance();
        if (this.realTreeId.equals(treeId)) {
            for (String folderId : ids) {
                cache.removeFromGroup((Serializable)this.newCacheKey(folderId, treeId), Integer.toString(contextId));
                folderMapManagement.dropFor(folderId, treeId, userId, contextId);
            }
        } else {
            for (String folderId : ids) {
                cache.removeFromGroup((Serializable)this.newCacheKey(folderId, treeId), Integer.toString(contextId));
                folderMapManagement.dropFor(folderId, treeId, userId, contextId);
                cache.removeFromGroup((Serializable)this.newCacheKey(folderId, this.realTreeId), Integer.toString(contextId));
                folderMapManagement.dropFor(folderId, this.realTreeId, userId, contextId);
            }
        }
    }

    public void removeSingleFromCache(String id, String treeId, int userId, Session session, boolean deleted) {
        this.removeSingleFromCache(id, treeId, userId, session.getContextId(), deleted, session);
    }

    public void removeSingleFromCache(String id, String treeId, int optUserId, int contextId, boolean deleted, Session optSession) {
        this.removeSingleFromCache(id, treeId, optUserId, contextId, deleted, false, optSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSingleFromCache(String id, String treeId, int optUserId, int contextId, boolean deleted, boolean userCacheOnly, Session optSession) {
        Lock lock = optUserId > 0 ? TreeLockManagement.getInstance().getFor(treeId, optUserId, contextId).writeLock() : Session.EMPTY_LOCK;
        try {
            CacheFolderStorage.acquire(lock);
        }
        catch (OXException e) {
            return;
        }
        try {
            String sContextId = Integer.toString(contextId);
            Cache cache = userCacheOnly ? null : this.globalCache;
            for (String tid : new HashSet<String>(Arrays.asList(treeId, this.realTreeId))) {
                String parentID;
                Folder cachedFolder;
                FolderMap folderMap;
                if (null != cache) {
                    String parentID2;
                    Folder cachedFolder2;
                    CacheKey cacheKey = this.newCacheKey(id, tid);
                    if (deleted && null != (cachedFolder2 = (Folder)cache.getFromGroup((Serializable)cacheKey, sContextId)) && null != (parentID2 = cachedFolder2.getParentID())) {
                        cache.removeFromGroup((Serializable)this.newCacheKey(parentID2, tid), sContextId);
                    }
                    cache.removeFromGroup((Serializable)cacheKey, sContextId);
                }
                FolderMapManagement folderMapManagement = FolderMapManagement.getInstance();
                if (optUserId > 0 && null != (folderMap = folderMapManagement.optFor(optUserId, contextId)) && deleted && null != (cachedFolder = folderMap.get(id, tid, optSession)) && null != (parentID = cachedFolder.getParentID())) {
                    folderMapManagement.dropFor(parentID, tid, optUserId, contextId, optSession);
                }
                folderMapManagement.dropFor(id, tid, optUserId, contextId, optSession);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        Lock lock = CacheFolderStorage.readLockFor(treeId, storageParameters);
        CacheFolderStorage.acquire(lock);
        try {
            Session session = storageParameters.getSession();
            if (null == session) {
                new ClearPerformer(storageParameters.getUser(), storageParameters.getContext(), this.registry).doClear(treeId, folderId);
            } else {
                new ClearPerformer(ServerSessionAdapter.valueOf(session), this.registry).doClear(treeId, folderId);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void deleteFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        block24: {
            lock = CacheFolderStorage.writeLockFor(treeId, storageParameters);
            CacheFolderStorage.acquire(lock);
            try {
                contextId = storageParameters.getContextId();
                userId = storageParameters.getUserId();
                session = storageParameters.getSession();
                sContextId = Integer.toString(contextId);
                try {
                    deleteMe = this.getFolder(treeId, folderId, storageParameters);
                    subfolderIDs = this.loadAllSubfolders(treeId, deleteMe, false, storageParameters);
                }
                catch (OXException e) {
                    this.globalCache.removeFromGroup((Serializable)this.newCacheKey(folderId, treeId), sContextId);
                    FolderMapManagement.getInstance().dropFor(folderId, treeId, userId, contextId, session);
                    lock.unlock();
                    return;
                }
                folderMapManagement = FolderMapManagement.getInstance();
                folderMapManagement.dropFor(folderId, treeId, userId, contextId, session);
                folderMapManagement.dropFor(folderId, this.realTreeId, userId, contextId, session);
                folderMapManagement.dropFor(deleteMe.getParentID(), treeId, userId, contextId, session);
                folderMapManagement.dropFor(deleteMe.getParentID(), this.realTreeId, userId, contextId, session);
                cacheable = deleteMe.isCacheable();
                global = deleteMe.isGlobalID();
                parentId = deleteMe.getParentID();
                if (!this.realTreeId.equals(treeId)) {
                    parameters = CacheFolderStorage.newStorageParameters(storageParameters);
                    folderStorage = this.registry.getFolderStorage(this.realTreeId, folderId);
                    started = folderStorage.startTransaction(parameters, false);
                    try {
                        realParentId = folderStorage.getFolder(this.realTreeId, folderId, parameters).getParentID();
                        if (!started) ** GOTO lbl43
                        folderStorage.commitTransaction(parameters);
                    }
                    catch (OXException e) {
                        if (started) {
                            folderStorage.rollback(parameters);
                        }
                        throw e;
                    }
                    catch (RuntimeException e) {
                        if (started) {
                            folderStorage.rollback(parameters);
                        }
                        throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, new Object[0]);
                    }
                } else {
                    realParentId = null;
                }
lbl43:
                // 3 sources

                if (cacheable) {
                    if (global) {
                        this.globalCache.removeFromGroup((Serializable)this.newCacheKey(folderId, treeId), sContextId);
                    } else {
                        FolderMapManagement.getInstance().dropFor(folderId, treeId, userId, contextId, session);
                    }
                    this.removeFromSubfolders(treeId, parentId, sContextId, session);
                    if (null != realParentId) {
                        this.removeFromSubfolders(this.realTreeId, realParentId, sContextId, session);
                    }
                }
                for (String subfolderId : subfolderIDs) {
                    this.removeSingleFromCache(subfolderId, treeId, userId, contextId, true, session);
                }
                if (null == session) {
                    new DeletePerformer(storageParameters.getUser(), storageParameters.getContext(), this.registry).doDelete(treeId, folderId, storageParameters.getTimeStamp());
                } else {
                    new DeletePerformer(ServerSessionAdapter.valueOf(session), this.registry).doDelete(treeId, folderId, storageParameters.getTimeStamp());
                }
                if (null != realParentId && !FolderStorage.ROOT_ID.equals(realParentId)) {
                    this.removeFromCache(realParentId, treeId, storageParameters.getSession(), this.newPathPerformer(storageParameters));
                }
                if (FolderStorage.ROOT_ID.equals(parentId)) break block24;
                this.removeFromCache(parentId, treeId, storageParameters.getSession(), this.newPathPerformer(storageParameters));
                try {
                    parentFolder = this.loadFolder(treeId, parentId, StorageType.WORKING, true, storageParameters);
                    if (parentFolder.isCacheable()) {
                        this.putFolder(parentFolder, treeId, storageParameters, true);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void removeFromSubfolders(String treeId, String parentId, String contextId, Session session) {
        this.registry.clearCaches(session.getUserId(), session.getContextId());
        this.globalCache.removeFromGroup((Serializable)this.newCacheKey(parentId, treeId), contextId);
        FolderMapManagement.getInstance().dropFor(parentId, treeId, session.getUserId(), session.getContextId(), session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultFolderID(User user, String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        Lock lock = CacheFolderStorage.readLockFor(treeId, storageParameters);
        CacheFolderStorage.acquire(lock);
        try {
            String folderId;
            FolderStorage storage = this.registry.getFolderStorageByContentType(treeId, contentType);
            if (null == storage) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_CT.create(treeId, contentType);
            }
            boolean started = storage.startTransaction(storageParameters, false);
            try {
                folderId = storage.getDefaultFolderID(user, treeId, contentType, type, storageParameters);
                if (started) {
                    storage.commitTransaction(storageParameters);
                }
            }
            catch (OXException e) {
                if (started) {
                    storage.rollback(storageParameters);
                }
                throw e;
            }
            catch (Exception e) {
                if (started) {
                    storage.rollback(storageParameters);
                }
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
            String string = folderId;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type getTypeByParent(User user, String treeId, String parentId, StorageParameters storageParameters) throws OXException {
        Lock lock = CacheFolderStorage.readLockFor(treeId, storageParameters);
        CacheFolderStorage.acquire(lock);
        try {
            Type type;
            FolderStorage storage = this.registry.getFolderStorage(treeId, parentId);
            if (null == storage) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, parentId);
            }
            boolean started = storage.startTransaction(storageParameters, false);
            try {
                type = storage.getTypeByParent(user, treeId, parentId, storageParameters);
                if (started) {
                    storage.commitTransaction(storageParameters);
                }
            }
            catch (OXException e) {
                if (started) {
                    storage.rollback(storageParameters);
                }
                throw e;
            }
            catch (Exception e) {
                if (started) {
                    storage.rollback(storageParameters);
                }
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
            Type type2 = type;
            return type2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean containsForeignObjects(User user, String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isEmpty(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLastModified(long lastModified, String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        Lock lock = CacheFolderStorage.writeLockFor(treeId, storageParameters);
        CacheFolderStorage.acquire(lock);
        try {
            FolderStorage storage = this.registry.getFolderStorage(treeId, folderId);
            if (null == storage) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
            }
            boolean started = storage.startTransaction(storageParameters, false);
            try {
                storage.updateLastModified(lastModified, treeId, folderId, storageParameters);
                if (started) {
                    storage.commitTransaction(storageParameters);
                }
            }
            catch (OXException e) {
                if (started) {
                    storage.rollback(storageParameters);
                }
                throw e;
            }
            catch (Exception e) {
                if (started) {
                    storage.rollback(storageParameters);
                }
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
            this.removeFromCache(folderId, treeId, storageParameters.getSession(), this.newPathPerformer(storageParameters));
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Folder getFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        return this.getFolder(treeId, folderId, StorageType.WORKING, storageParameters);
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageParameters storageParameters) throws OXException {
        return this.getFolders(treeId, folderIds, StorageType.WORKING, storageParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Folder getFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        Lock lock = CacheFolderStorage.readLockFor(treeId, storageParameters);
        CacheFolderStorage.acquire(lock);
        try {
            Folder folder = this.getCloneFromCache(treeId, folderId, storageParameters);
            if (null != folder) {
                Folder folder2 = folder;
                return folder2;
            }
            folder = this.loadFolder(treeId, folderId, storageType, storageParameters);
            if (folder.isCacheable()) {
                this.putFolder(folder, treeId, storageParameters, false);
                Folder folder3 = (Folder)folder.clone();
                return folder3;
            }
            Folder folder4 = folder;
            return folder4;
        }
        finally {
            lock.unlock();
        }
    }

    private Folder getCloneFromCache(String treeId, String folderId, StorageParameters storageParameters) {
        Folder folder = this.getRefFromCache(treeId, folderId, storageParameters);
        return null == folder ? null : (Folder)folder.clone();
    }

    protected Folder getRefFromCache(String treeId, String folderId, StorageParameters params) {
        int contextId = params.getContextId();
        Folder folder = (Folder)this.globalCache.getFromGroup((Serializable)this.newCacheKey(folderId, treeId), Integer.toString(contextId));
        if (null != folder) {
            return folder;
        }
        FolderMap folderMap = CacheFolderStorage.optFolderMapFor(params);
        if (null != folderMap && null != (folder = folderMap.get(folderId, treeId, params.getSession()))) {
            if (folder instanceof RemoveAfterAccessFolder) {
                RemoveAfterAccessFolder raaf = (RemoveAfterAccessFolder)folder;
                int fUserId = raaf.getUserId();
                int fContextId = raaf.getContextId();
                if (fUserId >= 0 && params.getUserId() != fUserId || fContextId >= 0 && params.getContextId() != fContextId) {
                    return null;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Locally loaded folder " + folderId + " from context " + contextId + " for user " + params.getUserId()));
            }
            return folder;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageType storageType, StorageParameters storageParameters) throws OXException {
        Lock lock = CacheFolderStorage.readLockFor(treeId, storageParameters);
        CacheFolderStorage.acquire(lock);
        try {
            int size = folderIds.size();
            Folder[] ret = new Folder[size];
            TObjectIntHashMap toLoad = new TObjectIntHashMap(size);
            for (int i = 0; i < size; ++i) {
                String folderId = folderIds.get(i);
                Folder folder = this.getCloneFromCache(treeId, folderId, storageParameters);
                if (null == folder) {
                    toLoad.put((Object)folderId, i);
                    continue;
                }
                ret[i] = folder;
            }
            Map<Object, Object> fromStorage = toLoad.isEmpty() ? Collections.emptyMap() : this.loadFolders(treeId, Arrays.asList(toLoad.keys((Object[])new String[toLoad.size()])), storageType, storageParameters);
            for (Map.Entry entry : fromStorage.entrySet()) {
                Folder folder = (Folder)entry.getValue();
                int index = toLoad.get(entry.getKey());
                if (folder.isCacheable()) {
                    this.putFolder(folder, treeId, storageParameters, false);
                    folder = (Folder)folder.clone();
                }
                ret[index] = folder;
            }
            ArrayList<Folder> l = new ArrayList<Folder>(ret.length);
            for (Folder folder : ret) {
                if (null == folder) continue;
                l.add(folder);
            }
            ArrayList<Folder> arrayList = l;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public FolderType getFolderType() {
        return CacheFolderType.getInstance();
    }

    @Override
    public StoragePriority getStoragePriority() {
        return StoragePriority.HIGHEST;
    }

    /*
     * Exception decompiling
     */
    @Override
    public SortableId[] getVisibleFolders(String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public SortableId[] getSubfolders(final String treeId, final String parentId, final StorageParameters storageParameters) throws OXException {
        lock = CacheFolderStorage.readLockFor(treeId, storageParameters);
        CacheFolderStorage.acquire(lock);
        try {
            parent = this.getFolder(treeId, parentId, storageParameters);
            subfolders = parent.getSubfolderIDs();
            if (null == subfolders) {
                neededStorages = this.registry.getFolderStoragesForParent(treeId, parentId);
                if (0 == neededStorages.length) {
                    var9_10 = new SortableId[]{};
                    return var9_10;
                }
                try {
                    if (1 == neededStorages.length) {
                        neededStorage = neededStorages[0];
                        started = neededStorage.startTransaction(storageParameters, false);
                        try {
                            allSubfolderIds = Arrays.asList(neededStorage.getSubfolders(treeId, parentId, storageParameters));
                            if (!started) ** GOTO lbl35
                            neededStorage.commitTransaction(storageParameters);
                        }
                        catch (Exception e) {
                            if (started) {
                                neededStorage.rollback(storageParameters);
                            }
                            throw e;
                        }
                    } else {
                        allSubfolderIds = new ArrayList<E>(neededStorages.length * 8);
                        completionService = new ThreadPoolCompletionService(ThreadPools.getThreadPool()).setTrackable(true);
                        for (final FolderStorage neededStorage : neededStorages) {
                            completionService.submit(new ThreadPools.TrackableCallable<List<SortableId>>(){

                                public List<SortableId> call() throws Exception {
                                    StorageParameters newParameters = CacheFolderStorage.newStorageParameters(storageParameters);
                                    boolean started = neededStorage.startTransaction(newParameters, false);
                                    try {
                                        List<SortableId> l = Arrays.asList(neededStorage.getSubfolders(treeId, parentId, newParameters));
                                        if (started) {
                                            neededStorage.commitTransaction(newParameters);
                                        }
                                        return l;
                                    }
                                    catch (Exception e) {
                                        if (started) {
                                            neededStorage.rollback(newParameters);
                                        }
                                        throw e;
                                    }
                                }
                            });
                        }
                        results = ThreadPools.takeCompletionService((CompletionService)completionService, (int)neededStorages.length, CacheFolderStorage.FACTORY);
                        for (List result : results) {
                            allSubfolderIds.addAll(result);
                        }
                    }
lbl35:
                    // 3 sources

                    Collections.sort(allSubfolderIds);
                    ret = allSubfolderIds.toArray(new SortableId[allSubfolderIds.size()]);
                }
                catch (OXException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, new Object[]{e.getMessage()});
                }
            } else {
                ret = new SortableId[subfolders.length];
                for (i = 0; i < ret.length; ++i) {
                    ret[i] = new CacheSortableId(subfolders[i], i, null);
                }
            }
            var8_9 = ret;
            return var8_9;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public ContentType[] getSupportedContentTypes() {
        return new ContentType[0];
    }

    @Override
    public void rollback(StorageParameters params) {
    }

    @Override
    public boolean startTransaction(StorageParameters parameters, boolean modify) throws OXException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        String treeId = folder.getTreeID();
        Lock lock = CacheFolderStorage.writeLockFor(treeId, storageParameters);
        CacheFolderStorage.acquire(lock);
        try {
            UpdatePerformer updatePerformer;
            String oldParentId;
            Session session = storageParameters.getSession();
            String oldFolderId = folder.getID();
            Folder storageVersion = this.getCloneFromCache(treeId, oldFolderId, storageParameters);
            if (null == storageVersion) {
                storageVersion = this.getFolder(treeId, oldFolderId, storageParameters);
            }
            boolean isMove = null != folder.getParentID();
            String string = oldParentId = isMove ? this.getFolder(treeId, oldFolderId, storageParameters).getParentID() : null;
            if (null == session) {
                updatePerformer = new UpdatePerformer(storageParameters.getUser(), storageParameters.getContext(), storageParameters.getDecorator(), this.registry);
                updatePerformer.setCheck4Duplicates(false);
                updatePerformer.doUpdate(folder, storageParameters.getTimeStamp());
            } else {
                updatePerformer = new UpdatePerformer(ServerSessionAdapter.valueOf(session), storageParameters.getDecorator(), (FolderStorageDiscoverer)this.registry);
                updatePerformer.setCheck4Duplicates(false);
                updatePerformer.doUpdate(folder, storageParameters.getTimeStamp());
            }
            String newFolderId = folder.getID();
            int userId = storageParameters.getUserId();
            if (isMove) {
                this.removeSingleFromCache(oldFolderId, treeId, userId, session, false);
                this.removeFromCache(oldParentId, treeId, session, this.newPathPerformer(storageParameters));
            } else {
                this.removeFromCache(newFolderId, treeId, session, this.newPathPerformer(storageParameters));
            }
            Folder updatedFolder = this.loadFolder(treeId, newFolderId, StorageType.WORKING, true, storageParameters);
            int contextId = storageParameters.getContextId();
            FolderMapManagement folderMapManagement = FolderMapManagement.getInstance();
            folderMapManagement.dropFor(newFolderId, treeId, userId, contextId, session);
            folderMapManagement.dropFor(newFolderId, this.realTreeId, userId, contextId, session);
            folderMapManagement.dropFor(updatedFolder.getParentID(), treeId, userId, contextId, session);
            folderMapManagement.dropFor(updatedFolder.getParentID(), this.realTreeId, userId, contextId, session);
            folderMapManagement.dropFor(oldFolderId, treeId, userId, contextId, session);
            folderMapManagement.dropFor(oldFolderId, this.realTreeId, userId, contextId, session);
            folderMapManagement.dropFor(storageVersion.getParentID(), treeId, userId, contextId, session);
            folderMapManagement.dropFor(storageVersion.getParentID(), this.realTreeId, userId, contextId, session);
            if (isMove) {
                String newParentId = updatedFolder.getParentID();
                if (null != newParentId && !newParentId.equals(oldParentId)) {
                    this.removeSingleFromCache(newParentId, treeId, userId, storageParameters.getSession(), false);
                }
                Folder f = this.loadFolder(this.realTreeId, newFolderId, StorageType.WORKING, true, storageParameters);
                this.removeSingleFromCache(f.getParentID(), treeId, userId, storageParameters.getSession(), false);
                if (f.isCacheable()) {
                    this.putFolder(f, this.realTreeId, storageParameters, true);
                }
                if ((f = this.loadFolder(this.realTreeId, oldParentId, StorageType.WORKING, true, storageParameters)).isCacheable()) {
                    this.putFolder(f, this.realTreeId, storageParameters, true);
                }
                if ((f = this.loadFolder(this.realTreeId, newParentId, StorageType.WORKING, true, storageParameters)).isCacheable()) {
                    this.putFolder(f, this.realTreeId, storageParameters, true);
                }
            } else {
                Folder f = this.loadFolder(this.realTreeId, newFolderId, StorageType.WORKING, true, storageParameters);
                if (f.isCacheable()) {
                    this.putFolder(f, this.realTreeId, storageParameters, true);
                }
            }
            if (updatedFolder.isCacheable()) {
                this.putFolder(updatedFolder, treeId, storageParameters, true);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean containsFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        return this.containsFolder(treeId, folderId, StorageType.WORKING, storageParameters);
    }

    @Override
    public String[] getModifiedFolderIDs(String treeId, Date timeStamp, ContentType[] includeContentTypes, StorageParameters storageParameters) throws OXException {
        return this.getChangedFolderIDs(0, treeId, timeStamp, includeContentTypes, storageParameters);
    }

    @Override
    public String[] getDeletedFolderIDs(String treeId, Date timeStamp, StorageParameters storageParameters) throws OXException {
        return this.getChangedFolderIDs(1, treeId, timeStamp, null, storageParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getChangedFolderIDs(int index, String treeId, Date timeStamp, ContentType[] includeContentTypes, StorageParameters storageParameters) throws OXException {
        Lock lock = CacheFolderStorage.readLockFor(treeId, storageParameters);
        CacheFolderStorage.acquire(lock);
        try {
            Session session = storageParameters.getSession();
            boolean ignoreDelete = index == 0;
            UserizedFolder[] folders2 = null == session ? new UpdatesPerformer(storageParameters.getUser(), storageParameters.getContext(), storageParameters.getDecorator(), this.registry).doUpdates(treeId, timeStamp, ignoreDelete, includeContentTypes)[index] : new UpdatesPerformer(ServerSessionAdapter.valueOf(session), storageParameters.getDecorator(), (FolderStorageDiscoverer)this.registry).doUpdates(treeId, timeStamp, ignoreDelete, includeContentTypes)[index];
            if (null == folders2 || folders2.length == 0) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            String[] ids = new String[folders2.length];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = folders2[i].getID();
            }
            String[] stringArray = ids;
            return stringArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean containsFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CacheKey newCacheKey(String folderId, String treeId) {
        return this.cacheService.newCacheKey(1, new Serializable[]{treeId, folderId});
    }

    private boolean existsFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        FolderStorage storage = this.registry.getFolderStorage(treeId, folderId);
        if (null == storage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
        }
        boolean started = storage.startTransaction(storageParameters, false);
        try {
            boolean exists = storage.containsFolder(treeId, folderId, storageType, storageParameters);
            if (started) {
                storage.commitTransaction(storageParameters);
            }
            return exists;
        }
        catch (OXException e) {
            if (started) {
                storage.rollback(storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            if (started) {
                storage.rollback(storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    public Folder loadFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        return this.loadFolder(treeId, folderId, storageType, false, storageParameters);
    }

    private Folder loadFolder(String treeId, String folderId, StorageType storageType, boolean readWrite, StorageParameters storageParameters) throws OXException {
        FolderStorage storage = this.registry.getFolderStorage(treeId, folderId);
        if (null == storage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
        }
        boolean started = storage.startTransaction(storageParameters, readWrite);
        try {
            Folder folder = storage.getFolder(treeId, folderId, storageType, storageParameters);
            if (started) {
                storage.commitTransaction(storageParameters);
            }
            return folder;
        }
        catch (OXException e) {
            if (started) {
                storage.rollback(storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            if (started) {
                storage.rollback(storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private String[] loadAllSubfolders(String treeId, Folder folder, boolean readWrite, StorageParameters storageParameters) throws OXException {
        HashSet<FolderStorage> openedStorages = new HashSet<FolderStorage>(2);
        HashSet<String> ids = new HashSet<String>(16);
        try {
            String[] subfolderIds = folder.getSubfolderIDs();
            if (null == subfolderIds) {
                this.loadAllSubfolders(treeId, folder.getID(), readWrite, storageParameters, ids, openedStorages);
            } else {
                ids.addAll(Arrays.asList(subfolderIds));
                for (String subfolderId : subfolderIds) {
                    this.loadAllSubfolders(treeId, subfolderId, readWrite, storageParameters, ids, openedStorages);
                }
            }
            for (FolderStorage fs : openedStorages) {
                fs.commitTransaction(storageParameters);
            }
        }
        catch (OXException e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(storageParameters);
            }
            throw e;
        }
        catch (RuntimeException e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        return ids.toArray(new String[ids.size()]);
    }

    private void loadAllSubfolders(String treeId, String folderId, boolean readWrite, StorageParameters storageParameters, Set<String> ids, Set<FolderStorage> openedStorages) throws OXException {
        FolderStorage storage = this.registry.getFolderStorage(treeId, folderId);
        if (null == storage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
        }
        this.checkOpenedStorage(storage, readWrite, openedStorages, storageParameters);
        try {
            SortableId[] subfolders;
            for (SortableId sortableId : subfolders = storage.getSubfolders(treeId, folderId, storageParameters)) {
                String id = sortableId.getId();
                this.loadAllSubfolders(treeId, id, readWrite, storageParameters, ids, openedStorages);
                ids.add(id);
            }
        }
        catch (RuntimeException e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    protected void checkOpenedStorage(FolderStorage checkMe, boolean modify, Collection<FolderStorage> openedStorages, StorageParameters storageParameters) throws OXException {
        if (openedStorages.contains(checkMe)) {
            return;
        }
        if (checkMe.startTransaction(storageParameters, modify)) {
            openedStorages.add(checkMe);
        }
    }

    private Map<String, Folder> loadFolders(final String treeId, List<String> folderIds, final StorageType storageType, StorageParameters storageParameters) throws OXException {
        StorageParametersProvider paramsProvider;
        ThreadPoolCompletionService completionService;
        int size = folderIds.size();
        HashMap<FolderStorage, TIntList> map = new HashMap<FolderStorage, TIntList>(4);
        for (int i = 0; i < size; ++i) {
            String id = folderIds.get(i);
            FolderStorage tmp = this.registry.getFolderStorage(treeId, id);
            if (null == tmp) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, id);
            }
            TIntList list = (TIntList)map.get(tmp);
            if (null == list) {
                list = new TIntArrayList();
                map.put(tmp, list);
            }
            list.add(i);
        }
        if (1 == map.size()) {
            completionService = new CallerRunsCompletionService();
            paramsProvider = new InstanceStorageParametersProvider(storageParameters);
        } else {
            completionService = new ThreadPoolCompletionService((ThreadPoolService)CacheServiceRegistry.getServiceRegistry().getService(ThreadPoolService.class, true)).setTrackable(true);
            Session session = storageParameters.getSession();
            paramsProvider = null == session ? new SessionStorageParametersProvider(storageParameters.getUser(), storageParameters.getContext()) : new SessionStorageParametersProvider((ServerSession)storageParameters.getSession());
        }
        final ConcurrentHashMap<String, Folder> ret = new ConcurrentHashMap<String, Folder>(size);
        int taskCount = 0;
        for (Map.Entry entry : map.entrySet()) {
            final FolderStorage fs = (FolderStorage)entry.getKey();
            int[] indexes = ((TIntList)entry.getValue()).toArray();
            final ArrayList<String> ids = new ArrayList<String>(indexes.length);
            for (int index : indexes) {
                ids.add(folderIds.get(index));
            }
            completionService.submit(new ThreadPools.TrackableCallable<Object>(){

                public Object call() throws Exception {
                    StorageParameters newParameters = paramsProvider.getStorageParameters();
                    boolean started = !DatabaseFolderType.getInstance().equals(fs.getFolderType()) && fs.startTransaction(newParameters, false);
                    try {
                        List<Folder> folders2 = fs.getFolders(treeId, ids, storageType, newParameters);
                        if (started) {
                            fs.commitTransaction(newParameters);
                            started = false;
                        }
                        for (Folder folder : folders2) {
                            ret.put(folder.getID(), folder);
                        }
                        Object var4_5 = null;
                        return var4_5;
                    }
                    catch (RuntimeException e) {
                        throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, new Object[0]);
                    }
                    finally {
                        if (started) {
                            fs.rollback(newParameters);
                        }
                    }
                }
            });
            ++taskCount;
        }
        ThreadPools.takeCompletionService((CompletionService)completionService, (int)taskCount, FACTORY);
        return ret;
    }

    static StorageParameters newStorageParameters(StorageParameters source) {
        Session session = source.getSession();
        if (null == session) {
            return new StorageParametersImpl(source.getUser(), source.getContext());
        }
        return new StorageParametersImpl((ServerSession)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int maxWaitMillis() {
        Integer i = maxWaitMillis;
        if (null != i) return i;
        Class<CacheFolderStorage> clazz = CacheFolderStorage.class;
        synchronized (CacheFolderStorage.class) {
            i = maxWaitMillis;
            if (null != i) return i;
            ConfigurationService service = (ConfigurationService)CacheServiceRegistry.getServiceRegistry().getService(ConfigurationService.class);
            int millis = null == service ? 60000 : service.getIntProperty("AJP_WATCHER_MAX_RUNNING_TIME", 60000);
            maxWaitMillis = i = Integer.valueOf(millis << 1);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return i;
        }
    }

    private static void acquire(Lock lock) throws OXException {
        if (null == lock) {
            return;
        }
        try {
            if (!lock.tryLock(CacheFolderStorage.maxWaitMillis(), TimeUnit.MILLISECONDS)) {
                throw FolderExceptionErrorMessage.TRY_AGAIN.create("The maximum time to wait for the lock is exceeded.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw FolderExceptionErrorMessage.TRY_AGAIN.create(e, e.getMessage());
        }
    }

    public static Lock readLockFor(String treeId, StorageParameters params) {
        return CacheFolderStorage.lockFor(treeId, params).readLock();
    }

    public static Lock writeLockFor(String treeId, StorageParameters params) {
        return CacheFolderStorage.lockFor(treeId, params).writeLock();
    }

    private static ReadWriteLock lockFor(String treeId, StorageParameters params) {
        return TreeLockManagement.getInstance().getFor(treeId, params.getUserId(), params.getContextId());
    }

    private static FolderMap getFolderMapFor(Session session) {
        return FolderMapManagement.getInstance().getFor(session);
    }

    private static FolderMap optFolderMapFor(Session session) {
        return FolderMapManagement.getInstance().optFor(session);
    }

    private static FolderMap optFolderMapFor(StorageParameters parameters) {
        return FolderMapManagement.getInstance().optFor(parameters.getUserId(), parameters.getContextId());
    }

    public static void dropUserEntries(int userId, int contextId) {
        FolderMap folderMap = FolderMapManagement.getInstance().optFor(userId, contextId);
        if (null != folderMap) {
            folderMap.clear();
        }
    }
}

