/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.internal.mapping;

import com.openexchange.config.ConfigurationService;
import com.openexchange.contact.internal.ContactServiceLookup;
import com.openexchange.contact.internal.mapping.StringMapping;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.container.Contact;
import com.openexchange.mail.mime.QuotedInternetAddress;
import javax.mail.internet.AddressException;

public abstract class EMailMapping
extends StringMapping {
    private Boolean validateEmail = null;

    private boolean isValidateEmail() throws OXException {
        if (null == this.validateEmail) {
            this.validateEmail = ContactServiceLookup.getService(ConfigurationService.class).getBoolProperty("validate_contact_email", true);
        }
        return this.validateEmail;
    }

    @Override
    public void validate(Contact contact) throws OXException {
        String value;
        super.validate(contact);
        if (this.isValidateEmail() && this.isSet(contact) && null != (value = (String)this.get(contact)) && !value.trim().isEmpty()) {
            try {
                new QuotedInternetAddress(value).validate();
            }
            catch (AddressException e) {
                throw ContactExceptionCodes.INVALID_EMAIL.create(e, value);
            }
        }
    }
}

