/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.configuration;

import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.Initialization;
import com.openexchange.tools.conf.AbstractConfig;
import java.io.File;

public final class SystemConfig
extends AbstractConfig
implements Initialization {
    private static final SystemConfig singleton = new SystemConfig();
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(SystemConfig.class));
    private static final String KEY = "openexchange.propdir";

    private SystemConfig() {
    }

    public static String getProperty(String key) {
        return SystemConfig.getProperty(key, null);
    }

    public static String getProperty(String key, String def) {
        return singleton.getPropertyInternal(key, def);
    }

    public static String getProperty(Property property) {
        return SystemConfig.getProperty(property.propertyName);
    }

    public static boolean isPropertiesLoad() {
        return null != singleton && singleton.isPropertiesLoadInternal();
    }

    public static SystemConfig getInstance() {
        return singleton;
    }

    public void start() throws OXException {
        if (this.isPropertiesLoadInternal()) {
            LOG.error((Object)"Duplicate initialization of SystemConfig.");
            return;
        }
        this.loadPropertiesInternal();
    }

    public void stop() {
        this.clearProperties();
    }

    @Override
    protected String getPropertyFileName() throws OXException {
        String directory = System.getProperty(KEY);
        if (null == directory) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(KEY);
        }
        return directory + File.separator + "system.properties";
    }

    public static enum Property {
        LDAP("LDAP"),
        CACHE("Cache"),
        USER_CONF_STORAGE("UserConfigurationStorage"),
        WebdavOverrides("WEBDAVOVERRIDES"),
        MimeTypeFileName("MimeTypeFileName");

        private String propertyName;

        private Property(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

