/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.responseRenderers;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.jpeg.JpegDirectory;
import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.container.ByteArrayInputStreamClosure;
import com.openexchange.ajax.container.DelegateFileHolder;
import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.ResponseRenderer;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.tools.images.ImageTransformationService;
import com.openexchange.tools.images.ImageTransformations;
import com.openexchange.tools.images.ScaleType;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;

public class FileResponseRenderer
implements ResponseRenderer {
    private static final Log LOG = com.openexchange.log.Log.loggerFor(FileResponseRenderer.class);
    private static final int BUFLEN = 2048;
    private static final String PARAMETER_CONTENT_DISPOSITION = "content_disposition";
    private static final String PARAMETER_CONTENT_TYPE = "content_type";
    private static final String SAVE_AS_TYPE = "application/octet-stream";
    private volatile ImageTransformationService scaler;
    private static final String DELIVERY = AJAXServlet.PARAMETER_DELIVERY;
    private static final String DOWNLOAD = "download";
    private static final String VIEW = "view";
    private static final String MULTIPART_BOUNDARY = "MULTIPART_BYTERANGES";
    private static final Pattern PATTERN_BYTE_RANGES = Pattern.compile("^bytes=\\d*-\\d*(,\\d*-\\d*)*$");
    private final Tika tika = new Tika(TikaConfig.getDefaultConfig());

    @Override
    public int getRanking() {
        return 0;
    }

    public void setScaler(ImageTransformationService scaler) {
        this.scaler = scaler;
    }

    @Override
    public boolean handles(AJAXRequestData request, AJAXRequestResult result) {
        return result.getResultObject() instanceof IFileHolder;
    }

    @Override
    public void write(AJAXRequestData request, AJAXRequestResult result, HttpServletRequest req, HttpServletResponse resp) {
        IFileHolder file = (IFileHolder)result.getResultObject();
        if (file == null || this.hasNoFileItem(file)) {
            try {
                resp.sendError(404);
            }
            catch (IOException e) {
                LOG.error((Object)"Exception while trying to write HTTP response.", (Throwable)e);
            }
            return;
        }
        this.writeFileHolder(file, request, result, req, resp);
    }

    /*
     * Exception decompiling
     */
    public void writeFileHolder(IFileHolder fileHolder, AJAXRequestData requestData, AJAXRequestResult result, HttpServletRequest req, HttpServletResponse resp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 17[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getContentTypeByFileName(String fileName) {
        if (null == fileName) {
            return null;
        }
        String contentTypeByFileName = MimeType2ExtMap.getContentType(fileName);
        if (SAVE_AS_TYPE.equals(contentTypeByFileName)) {
            return null;
        }
        return contentTypeByFileName;
    }

    private void sendErrorSafe(int sc, String msg, HttpServletResponse resp) {
        try {
            resp.sendError(sc, msg);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private boolean trySetSanitizedContentType(String contentType, String fallbackContentType, HttpServletResponse resp) {
        try {
            resp.setContentType(new ContentType(contentType).getBaseType());
            return true;
        }
        catch (Exception e) {
            resp.setContentType(fallbackContentType);
            return false;
        }
    }

    private boolean isTransformationNeeded(AJAXRequestData request, IFileHolder[] arr, String delivery) throws OXException, IOException {
        boolean transformationNeeded;
        IFileHolder file = arr[0];
        boolean bl = transformationNeeded = !file.getContentType().toLowerCase().startsWith("image/jpeg");
        if (!transformationNeeded) {
            boolean bl2 = transformationNeeded = request.isSet("cropWidth") || request.isSet("cropHeight");
        }
        if (!transformationNeeded) {
            InputStream stream = file.getStream();
            if (null == stream) {
                LOG.warn((Object)"(Possible) Image file misses stream data");
                return false;
            }
            BufferedInputStream inputStream = null;
            if (file.repetitive()) {
                inputStream = new BufferedInputStream(stream);
            } else if (stream.markSupported() && file.getLength() > 0L && file.getLength() < 131072L) {
                byte[] bytes = Streams.stream2bytes((InputStream)stream);
                DelegateFileHolder dfh = new DelegateFileHolder(file).setStream(new ByteArrayInputStreamClosure(bytes), (long)bytes.length);
                Streams.close((Closeable)file);
                arr[0] = file = dfh;
                inputStream = new BufferedInputStream(file.getStream(), (int)file.getLength());
            }
            if (inputStream == null) {
                transformationNeeded = true;
            } else {
                try {
                    Metadata metadata = ImageMetadataReader.readMetadata((BufferedInputStream)inputStream, (boolean)false);
                    if (metadata == null) {
                        transformationNeeded = true;
                    } else {
                        JpegDirectory jpegDirectory;
                        int orientation = 1;
                        ExifIFD0Directory exifDirectory = (ExifIFD0Directory)metadata.getDirectory(ExifIFD0Directory.class);
                        if (exifDirectory != null) {
                            orientation = exifDirectory.getInt(274);
                        }
                        if (orientation != 1) {
                            Boolean rotate;
                            Boolean bl3 = rotate = request.isSet("rotate") ? request.getParameter("rotate", Boolean.class) : null;
                            if (null == rotate && !DOWNLOAD.equalsIgnoreCase(delivery) || null != rotate && rotate.booleanValue()) {
                                transformationNeeded = true;
                            }
                        }
                        if (null == (jpegDirectory = (JpegDirectory)metadata.getDirectory(JpegDirectory.class))) {
                            transformationNeeded = true;
                        } else {
                            int width = jpegDirectory.getImageWidth();
                            int height = jpegDirectory.getImageHeight();
                            int maxWidth = request.isSet("width") ? request.getParameter("width", Integer.TYPE) : 0;
                            int maxHeight = request.isSet("height") ? request.getParameter("height", Integer.TYPE) : 0;
                            ScaleType scaleType = ScaleType.getType(request.getParameter("scaleType"));
                            transformationNeeded = scaleType == ScaleType.CONTAIN ? maxWidth > 0 && width > maxWidth || maxHeight > 0 && height > maxHeight : maxWidth > 0 && width != maxWidth || maxHeight > 0 && height != maxHeight;
                        }
                    }
                }
                catch (ImageProcessingException e) {
                    transformationNeeded = true;
                }
                catch (MetadataException e) {
                    transformationNeeded = true;
                }
                if (!file.repetitive() && stream.markSupported()) {
                    stream.reset();
                }
            }
        }
        return transformationNeeded;
    }

    private IFileHolder transformIfImage(AJAXRequestData request, IFileHolder fileHolder, String delivery) throws IOException, OXException {
        Boolean compress;
        Boolean rotate;
        boolean markSupported;
        ImageTransformationService scaler = this.scaler;
        if (null == scaler || !this.isImage(fileHolder)) {
            return fileHolder;
        }
        IFileHolder file = fileHolder;
        IFileHolder[] arr = new IFileHolder[]{file};
        boolean transformationNeeded = this.isTransformationNeeded(request, arr, delivery);
        file = arr[0];
        if (!transformationNeeded) {
            return new DelegateFileHolder(file).setLength(-1L);
        }
        InputStream stream = file.getStream();
        if (null == stream) {
            LOG.warn((Object)"(Possible) Image file misses stream data");
            return file;
        }
        boolean bl = markSupported = file.repetitive() ? false : stream.markSupported();
        if (markSupported) {
            stream.mark(131072);
        }
        ImageTransformations transformations = scaler.transfom(stream);
        Boolean bl2 = rotate = request.isSet("rotate") ? request.getParameter("rotate", Boolean.class) : null;
        if (null == rotate && !DOWNLOAD.equalsIgnoreCase(delivery) || null != rotate && rotate.booleanValue()) {
            transformations.rotate();
        }
        if (request.isSet("cropWidth") || request.isSet("cropHeight")) {
            int cropX = request.isSet("cropX") ? request.getParameter("cropX", Integer.TYPE) : 0;
            int cropY = request.isSet("cropY") ? request.getParameter("cropY", Integer.TYPE) : 0;
            int cropWidth = request.getParameter("cropWidth", Integer.TYPE);
            int cropHeight = request.getParameter("cropHeight", Integer.TYPE);
            transformations.crop(cropX, cropY, cropWidth, cropHeight);
        }
        if (request.isSet("width") || request.isSet("height")) {
            int maxWidth = request.isSet("width") ? request.getParameter("width", Integer.TYPE) : 0;
            int maxHeight = request.isSet("height") ? request.getParameter("height", Integer.TYPE) : 0;
            ScaleType scaleType = ScaleType.getType(request.getParameter("scaleType"));
            transformations.scale(maxWidth, maxHeight, scaleType);
        }
        Boolean bl3 = compress = request.isSet("compress") ? request.getParameter("compress", Boolean.class) : null;
        if (null == compress && !DOWNLOAD.equalsIgnoreCase(delivery) || null != compress && compress.booleanValue()) {
            transformations.compress();
        }
        try {
            InputStream transformed = transformations.getInputStream(file.getContentType());
            if (null == transformed) {
                LOG.warn((Object)"Got no resulting input stream from transformation, trying to recover original input");
                if (markSupported) {
                    try {
                        stream.reset();
                        return file;
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Error resetting input stream", (Throwable)e);
                    }
                }
                LOG.error((Object)("Unable to transform image from " + file));
                return file.repetitive() ? file : null;
            }
            return new FileHolder(transformed, -1L, file.getContentType(), file.getName());
        }
        catch (RuntimeException e) {
            LOG.error((Object)("Unable to transform image from " + file));
            return file.repetitive() ? file : null;
        }
    }

    private String checkedContentDisposition(String contentDisposition, IFileHolder file) {
        String ct = this.toLowerCase(file.getContentType());
        if (null == ct || ct.startsWith("text/htm")) {
            int pos = contentDisposition.indexOf(59);
            return pos > 0 ? "attachment" + contentDisposition.substring(pos) : "attachment";
        }
        return contentDisposition;
    }

    private boolean isImage(IFileHolder file) {
        String fileName;
        String contentType = file.getContentType();
        return null != contentType && contentType.startsWith("image/") || (fileName = file.getName()) != null && (contentType = MimeType2ExtMap.getContentType(fileName)).startsWith("image/");
    }

    private String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    private boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }

    private String unquote(String s) {
        if (!this.isEmpty(s) && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private String getPrimaryType(String contentType) {
        if (this.isEmpty(contentType)) {
            return contentType;
        }
        int pos = contentType.indexOf(47);
        return pos > 0 ? contentType.substring(0, pos) : contentType;
    }

    private boolean equalPrimaryTypes(String contentType1, String contentType2) {
        if (null == contentType1 || null == contentType2) {
            return false;
        }
        return this.toLowerCase(this.getPrimaryType(contentType1)).startsWith(this.toLowerCase(this.getPrimaryType(contentType2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String detectMimeType(InputStream in) throws IOException {
        if (null == in) {
            return null;
        }
        try {
            String string = this.tika.detect(in);
            return string;
        }
        finally {
            Streams.close((Closeable)in);
        }
    }

    private long sublong(String value, int beginIndex, int endIndex) {
        String substring = value.substring(beginIndex, endIndex);
        return substring.length() > 0 ? Long.parseLong(substring) : -1L;
    }

    private void copy(InputStream inputStream, OutputStream output, long start, long length) throws IOException {
        int read;
        InputStream input = !(inputStream instanceof BufferedInputStream) && !(inputStream instanceof ByteArrayInputStream) ? new BufferedInputStream(inputStream, 8192) : inputStream;
        int i = 0;
        while ((long)i < start) {
            if (input.read() < 0) {
                throw new IOException("Start index " + start + " out of range. Got only " + i);
            }
            ++i;
        }
        long toRead = length;
        byte[] buffer = new byte[2048];
        while ((read = input.read(buffer)) > 0) {
            if ((toRead -= (long)read) > 0L) {
                output.write(buffer, 0, read);
                continue;
            }
            output.write(buffer, 0, (int)toRead + read);
            break;
        }
    }

    private boolean hasNoFileItem(IFileHolder file) {
        String fileMIMEType = file.getContentType();
        return (this.isEmpty(fileMIMEType) || SAVE_AS_TYPE.equals(fileMIMEType)) && this.isEmpty(file.getName()) && file.getLength() <= 0L;
    }

    private static final class Range {
        final long start;
        final long end;
        final long length;
        final long total;

        Range(long start, long end, long total) {
            this.start = start;
            this.end = end;
            this.length = end - start + 1L;
            this.total = total;
        }
    }
}

