/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview;

import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.utils.DisplayMode;
import com.openexchange.preview.PreviewOutput;
import com.openexchange.preview.PreviewService;
import com.openexchange.preview.cache.CachedPreview;
import com.openexchange.preview.cache.CachedPreviewDocument;
import com.openexchange.preview.cache.PreviewCache;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;

public abstract class AbstractPreviewResultConverter
implements ResultConverter {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(AbstractPreviewResultConverter.class));
    private static final AtomicReference<PreviewCache> CACHE_REF = new AtomicReference();
    private static final Charset UTF8 = Charsets.UTF_8;
    private static final byte[] DELIM = new byte[]{13, 10};
    protected static final String PARAMETER_VIEW = "view";
    protected static final String PARAMETER_EDIT = "edit";
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Set<String> BOOLS = new HashSet<String>(Arrays.asList("true", "yes", "y", "on", "1"));
    private static final String VIEW_RAW = "raw";
    private static final String VIEW_TEXT = "text";
    private static final String VIEW_TEXT_NO_HTML_ATTACHMENT = "textNoHtmlAttach";
    private static final String VIEW_HTML = "html";
    private static final String VIEW_HTML_BLOCKED_IMAGES = "noimg";

    public static void setPreviewCache(PreviewCache ref) {
        CACHE_REF.set(ref);
    }

    protected static PreviewCache getPreviewCache() {
        return CACHE_REF.get();
    }

    protected AbstractPreviewResultConverter() {
    }

    @Override
    public String getInputFormat() {
        return "file";
    }

    protected String generatePreviewCacheKey(String eTag, AJAXRequestData requestData) {
        StringAllocator sb = new StringAllocator(512);
        sb.append(requestData.getModule());
        sb.append('-').append(requestData.getAction());
        sb.append('-').append(requestData.getSession().getContextId());
        ArrayList<String> parameters = new ArrayList<String>(requestData.getParameters().keySet());
        Collections.sort(parameters);
        for (String name : parameters) {
            if (name.equalsIgnoreCase("session") || name.equalsIgnoreCase("action")) continue;
            sb.append('-').append(name);
            String parameter = requestData.getParameter(name);
            if (AbstractPreviewResultConverter.isEmpty(parameter)) continue;
            sb.append('=').append(parameter);
        }
        try {
            byte[] md5Bytes = sb.toString().getBytes("UTF-8");
            sb.setNewLength(0);
            return sb.append(eTag).append('-').append(AbstractPreviewResultConverter.asHex(MessageDigest.getInstance("MD5").digest(md5Bytes))).toString();
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return sb.toString();
    }

    public static String asHex(byte[] hash) {
        int length = hash.length;
        char[] buf = new char[length * 2];
        int x = 0;
        for (int i = 0; i < length; ++i) {
            buf[x++] = HEX_CHARS[hash[i] >>> 4 & 0xF];
            buf[x++] = HEX_CHARS[hash[i] & 0xF];
        }
        return new String(buf);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, final ServerSession session, Converter converter) throws OXException {
        block24: {
            fileHolder = null;
            try {
                previewCache = AbstractPreviewResultConverter.getPreviewCache();
                eTag = requestData.getETag();
                v0 = isValidEtag = AbstractPreviewResultConverter.isEmpty(eTag) == false;
                if (null != previewCache && isValidEtag && null != (cachedPreview = previewCache.get(cacheKey = this.generatePreviewCacheKey(eTag, requestData), 0, session.getContextId()))) {
                    in = cachedPreview.getInputStream();
                    bytes = null == in ? cachedPreview.getBytes() : Streams.stream2bytes((InputStream)in);
                    map = new HashMap<String, String>(4);
                    map.put("resourcename", cachedPreview.getFileName());
                    map.put("content-type", cachedPreview.getFileType());
                    computedFailure = this.computeFailure(AbstractPreviewResultConverter.DELIM);
                    prev = 0;
                    pos = this.indexOf(bytes, AbstractPreviewResultConverter.DELIM, prev, computedFailure);
                    if (pos >= 0) {
                        contents = new LinkedList<E>();
                        baos = new ByteArrayOutputStream(16384);
                        do {
                            baos.reset();
                            prev = pos + AbstractPreviewResultConverter.DELIM.length;
                            pos = this.indexOf(bytes, AbstractPreviewResultConverter.DELIM, prev, computedFailure);
                            if (pos >= 0) {
                                baos.write(bytes, prev, pos);
                            } else {
                                baos.write(bytes, prev, bytes.length);
                            }
                            contents.add(new String(Base64.decodeBase64((byte[])Charsets.toAsciiBytes((String)Charsets.toAsciiString((byte[])baos.toByteArray()))), AbstractPreviewResultConverter.UTF8));
                        } while (pos >= 0);
                    } else {
                        contents = Collections.singletonList(new String(Base64.decodeBase64((byte[])Charsets.toAsciiBytes((String)Charsets.toAsciiString((byte[])bytes))), AbstractPreviewResultConverter.UTF8));
                    }
                    result.setResultObject(new CachedPreviewDocument(contents, map), this.getOutputFormat());
                }
                ** GOTO lbl-1000
            }
            catch (IOException e) {
                try {
                    throw AjaxExceptionCodes.IO_ERROR.create(e, new Object[]{e.getMessage()});
                    catch (RuntimeException e) {
                        throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, new Object[]{e.getMessage()});
                    }
                }
                catch (Throwable var24_34) {
                    Streams.close(fileHolder);
                    throw var24_34;
                }
            }
            Streams.close((Closeable)fileHolder);
            return;
lbl-1000:
            // 1 sources

            {
                resultObject = result.getResultObject();
                if (!(resultObject instanceof IFileHolder)) {
                    throw AjaxExceptionCodes.UNEXPECTED_RESULT.create(new Object[]{IFileHolder.class.getSimpleName(), null == resultObject ? "null" : resultObject.getClass().getSimpleName()});
                }
                fileHolder = (IFileHolder)resultObject;
                previewService = ServerServiceRegistry.getInstance().getService(PreviewService.class);
                dataProperties = new DataProperties(4);
                dataProperties.put("com.openexchange.conversion.content-type", fileHolder.getContentType());
                dataProperties.put("com.openexchange.conversion.disposition", fileHolder.getDisposition());
                dataProperties.put("com.openexchange.conversion.name", fileHolder.getName());
                dataProperties.put("com.openexchange.conversion.size", Long.toString(fileHolder.getLength()));
                pages = -1;
                if (requestData.containsParameter("pages")) {
                    pages = requestData.getIntParameter("pages");
                }
                previewDocument = previewService.getPreviewFor((Data)new SimpleData((Object)fileHolder.getStream(), dataProperties), this.getOutput(), (Session)session, pages);
                if (null != previewCache && isValidEtag && null != (content = previewDocument.getContent()) && (size = content.size()) > 0) {
                    cacheKey = this.generatePreviewCacheKey(eTag, requestData);
                    if (1 == content.size()) {
                        bytes = Charsets.toAsciiBytes((String)Charsets.toAsciiString((byte[])Base64.encodeBase64((byte[])((String)content.get(0)).getBytes(AbstractPreviewResultConverter.UTF8))));
                    } else {
                        baos = Streams.newByteArrayOutputStream((int)16384);
                        baos.write(Charsets.toAsciiBytes((String)Charsets.toAsciiString((byte[])Base64.encodeBase64((byte[])((String)content.get(0)).getBytes(AbstractPreviewResultConverter.UTF8)))));
                        delim = AbstractPreviewResultConverter.DELIM;
                        for (i = 1; i < size; ++i) {
                            baos.write(delim);
                            baos.write(Charsets.toAsciiBytes((String)Charsets.toAsciiString((byte[])Base64.encodeBase64((byte[])((String)content.get(i)).getBytes(AbstractPreviewResultConverter.UTF8)))));
                        }
                        bytes = baos.toByteArray();
                    }
                    fileName = fileHolder.getName();
                    fileType = fileHolder.getContentType();
                    task = new AbstractTask<Void>(){

                        public Void call() throws OXException {
                            CachedPreview preview = new CachedPreview(bytes, fileName, fileType, (long)bytes.length);
                            previewCache.save(cacheKey, preview, 0, session.getContextId());
                            return null;
                        }
                    };
                    threadPool = ServerServiceRegistry.getInstance().getService(ThreadPoolService.class);
                    if (null == threadPool) {
                        thread = Thread.currentThread();
                        ran = false;
                        task.beforeExecute(thread);
                        try {
                            task.call();
                            ran = true;
                            task.afterExecute(null);
                        }
                        catch (Exception ex) {
                            if (!ran) {
                                task.afterExecute((Throwable)ex);
                            }
                            if (ex instanceof OXException) {
                                v1 = (OXException)ex;
                                throw v1;
                            }
                            v1 = AjaxExceptionCodes.UNEXPECTED_ERROR.create(ex, new Object[]{ex.getMessage()});
                            throw v1;
                        }
                    } else {
                        threadPool.submit((Task)task);
                    }
                }
                if (requestData.getIntParameter("save") == 1) break block24;
                result.setResultObject(previewDocument, this.getOutputFormat());
            }
        }
        Streams.close((Closeable)fileHolder);
    }

    protected static boolean parseBool(String value) {
        if (null == value) {
            return false;
        }
        return BOOLS.contains(value.trim().toLowerCase(Locale.US));
    }

    protected static DisplayMode detectDisplayMode(boolean modifyable, String view, UserSettingMail usm) {
        DisplayMode displayMode;
        if (null == view) {
            return modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        }
        if (VIEW_RAW.equals(view)) {
            displayMode = DisplayMode.RAW;
        } else if (VIEW_TEXT_NO_HTML_ATTACHMENT.equals(view)) {
            usm.setDisplayHtmlInlineContent(false);
            usm.setSuppressHTMLAlternativePart(true);
            displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        } else if (VIEW_TEXT.equals(view)) {
            usm.setDisplayHtmlInlineContent(false);
            displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        } else if (VIEW_HTML.equals(view)) {
            usm.setDisplayHtmlInlineContent(true);
            usm.setAllowHTMLImages(true);
            displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        } else if (VIEW_HTML_BLOCKED_IMAGES.equals(view)) {
            usm.setDisplayHtmlInlineContent(true);
            usm.setAllowHTMLImages(false);
            displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        } else {
            LOG.warn((Object)new StringAllocator(64).append("Unknown value in parameter ").append(PARAMETER_VIEW).append(": ").append(view).append(". Using user's mail settings as fallback."));
            displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        }
        return displayMode;
    }

    public abstract PreviewOutput getOutput();

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }

    private int indexOf(byte[] data, byte[] pattern, int[] computeFailure) {
        return this.indexOf(data, pattern, 0, computeFailure);
    }

    private int indexOf(byte[] data, byte[] pattern, int fromIndex, int[] computedFailure) {
        int[] failure = null == computedFailure ? this.computeFailure(pattern) : computedFailure;
        int j = 0;
        int dLen = data.length;
        if (dLen == 0) {
            return -1;
        }
        int pLen = pattern.length;
        for (int i = fromIndex; i < dLen; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pLen) continue;
            return i - pLen + 1;
        }
        return -1;
    }

    private int[] computeFailure(byte[] pattern) {
        int length = pattern.length;
        int[] failure = new int[length];
        int j = 0;
        for (int i = 1; i < length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }
}

