/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.tools.session.ServerSession;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DebugConverter
implements ResultConverter {
    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        StringAllocator out = new StringAllocator("<!DOCTYPE html><head><title>").append(requestData.getAction() + " Response").append("</title></head><body><h1>Request with action ").append(requestData.getAction()).append("</h1>");
        out.append("<h2>Parameters:</h2>");
        out.append("<table>");
        Iterator<String> parameterNames = requestData.getParameterNames();
        while (parameterNames.hasNext()) {
            String paramName = parameterNames.next();
            out.append("<tr><th>").append(paramName).append("</th><td>").append(requestData.getParameter(paramName)).append("</td></tr>");
        }
        out.append("</table>");
        Object data = requestData.getData();
        if (data != null) {
            if (data instanceof JSONObject) {
                try {
                    out.append("<h2>Body:</h2><pre>").append(((JSONObject)data).toString(4));
                }
                catch (JSONException e) {
                    out.append("Error rendering body: ").append(e.toString());
                }
            } else if (data instanceof JSONArray) {
                try {
                    out.append("<h2>Body:</h2><pre>").append(((JSONArray)data).toString(4));
                }
                catch (JSONException e) {
                    out.append("Error rendering body: ").append(e.toString());
                }
            }
        }
        out.append("<h1>Response</h1>");
        try {
            converter.convert(result.getFormat(), "apiResponse", requestData, result, session);
            Response response = (Response)result.getResultObject();
            JSONObject json = new JSONObject();
            ResponseWriter.write(response, json);
            out.append("<h2>Response:</h2><pre>").append(json.toString(4));
        }
        catch (Exception e) {
            out.append("Can't render response: " + e.toString());
        }
        out.append("</body></html>");
        result.setHeader("Content-Type", "text/html");
        result.setResultObject(out.toString());
    }

    @Override
    public String getInputFormat() {
        return "json";
    }

    @Override
    public String getOutputFormat() {
        return "debug";
    }

    @Override
    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }
}

