/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.Login;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.ajax.login.LoginRequestHandler;
import com.openexchange.ajax.login.LoginRequestImpl;
import com.openexchange.ajax.login.LoginTools;
import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.login.LoginResult;
import com.openexchange.login.internal.LoginPerformer;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.http.Tools;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class TokenLogin
implements LoginRequestHandler {
    private final LoginConfiguration conf;

    public TokenLogin(LoginConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.doTokenLogin(req, resp);
        }
        catch (OXException e) {
            Login.logAndSendException(resp, e);
        }
    }

    private void doTokenLogin(HttpServletRequest req, HttpServletResponse resp) throws OXException, IOException {
        LoginResult result;
        String serverToken;
        LoginRequestImpl request = LoginTools.parseLogin(req, "login", true, this.conf.getDefaultClient(), this.conf.isCookieForceHTTPS(), this.conf.isDisableTrimLogin(), true);
        request.setClientToken(LoginTools.parseParameter(req, "clientToken", true, null));
        HashMap<String, Object> properties = new HashMap<String, Object>(1);
        String capabilities = req.getParameter("capabilities");
        if (null != capabilities) {
            properties.put("client.capabilities", capabilities);
        }
        if (null == (serverToken = (result = LoginPerformer.getInstance().doLogin(request, properties)).getServerToken())) {
            throw LoginExceptionCodes.SERVER_TOKEN_NOT_CREATED.create();
        }
        Session session = result.getSession();
        User user = result.getUser();
        Tools.disableCaching(resp);
        resp.sendRedirect(TokenLogin.generateRedirectURL(LoginTools.encodeUrl(req.getParameter("uiWebPath"), true), LoginTools.encodeUrl(req.getParameter("autologin"), true), session, user.getPreferredLanguage(), this.conf.getUiWebPath(), request.getHttpSessionID(), serverToken));
    }

    private static String generateRedirectURL(String uiWebPathParam, String shouldStore, Session session, String language, String uiWebPath, String httpSessionId, String serverToken) {
        String retval = uiWebPathParam;
        if (null == retval) {
            retval = uiWebPath;
        }
        retval = retval.replaceAll("[\n\r]", "");
        retval = LoginTools.addFragmentParameter(retval, "jsessionid", httpSessionId);
        retval = LoginTools.addFragmentParameter(retval, "serverToken", serverToken);
        retval = LoginTools.addFragmentParameter(retval, "user", session.getLogin());
        retval = LoginTools.addFragmentParameter(retval, "user_id", Integer.toString(session.getUserId()));
        retval = LoginTools.addFragmentParameter(retval, "language", language);
        if (shouldStore != null) {
            retval = LoginTools.addFragmentParameter(retval, "store", shouldStore);
        }
        return retval;
    }
}

