/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging;

import com.openexchange.messaging.MessagingField;
import java.util.EnumMap;
import java.util.Map;

public interface MessagingHeader {
    public HeaderType getHeaderType();

    public String getName();

    public String getValue();

    public static enum HeaderType {
        PLAIN,
        DATE,
        ADDRESS,
        PARAMETERIZED;

    }

    public static enum KnownHeader {
        ACCOUNT_NAME("X-Account-Name"),
        BCC("Bcc"),
        CC("Cc"),
        CONTENT_TYPE("Content-Type"),
        CONTENT_DISPOSITION("Content-Disposition"),
        CONTENT_TRANSFER_ENCODING("Content-Transfer-Encoding"),
        FROM("From"),
        IN_REPLY_TO("In-Reply-To"),
        MESSAGE_ID("Message-Id"),
        MIME_VERSION("MIME-Version"),
        PRIORITY("X-Priority"),
        REFERENCES("References"),
        DISPOSITION_NOTIFICATION_TO("Disposition-Notification-To"),
        REPLY_TO("Reply-To"),
        SENT_DATE("Date"),
        SUBJECT("Subject"),
        TO("To"),
        DATE("Date"),
        MESSAGE_TYPE("X-Message-Type"),
        MAILER("X-Mailer");

        private final String name;
        private static final Map<KnownHeader, MessagingField> equivalenceMap;

        private KnownHeader(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public MessagingField getEquivalentField() {
            return equivalenceMap.get((Object)this);
        }

        static {
            equivalenceMap = new EnumMap<KnownHeader, MessagingField>(KnownHeader.class);
            equivalenceMap.put(BCC, MessagingField.BCC);
            equivalenceMap.put(CC, MessagingField.CC);
            equivalenceMap.put(CONTENT_TYPE, MessagingField.CONTENT_TYPE);
            equivalenceMap.put(FROM, MessagingField.FROM);
            equivalenceMap.put(PRIORITY, MessagingField.PRIORITY);
            equivalenceMap.put(DISPOSITION_NOTIFICATION_TO, MessagingField.DISPOSITION_NOTIFICATION_TO);
            equivalenceMap.put(SENT_DATE, MessagingField.SENT_DATE);
            equivalenceMap.put(SUBJECT, MessagingField.SUBJECT);
            equivalenceMap.put(TO, MessagingField.TO);
            equivalenceMap.put(DATE, MessagingField.SENT_DATE);
            MessagingField.initHeaders();
        }
    }
}

