/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DirectIO {
    private static volatile Method cleanerMethod;

    private DirectIO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Method cleanerMethod() {
        Method m = cleanerMethod;
        if (null != m) return m;
        Class<DirectIO> clazz = DirectIO.class;
        synchronized (DirectIO.class) {
            m = cleanerMethod;
            if (null != m) return m;
            try {
                m = ByteBuffer.class.getMethod("cleaner", new Class[0]);
                m.setAccessible(true);
                cleanerMethod = m;
            }
            catch (Exception e) {
                Log log = LogFactory.getLog(DirectIO.class);
                log.error((Object)"Couldn't initialze Java Reflection method for \"cleaner\".", (Throwable)e);
            }
            return m;
        }
    }

    public static void destroyDirectByteBuffer(ByteBuffer toBeDestroyed) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        if (null == toBeDestroyed || !toBeDestroyed.isDirect()) {
            return;
        }
        Method cleanerMethod = DirectIO.cleanerMethod();
        Object cleaner = cleanerMethod.invoke((Object)toBeDestroyed, new Object[0]);
        Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
        cleanMethod.setAccessible(true);
        cleanMethod.invoke(cleaner, new Object[0]);
    }
}

