/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ConcurrentHashSet<E>
extends AbstractSet<E>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -2608324279213322648L;
    private static final Object PRESENT = new Object();
    private static int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_SEGMENTS = 16;
    private ConcurrentHashMap<E, Object> map;

    public ConcurrentHashSet(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.map = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    public ConcurrentHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f, 16);
    }

    public ConcurrentHashSet() {
        this(DEFAULT_INITIAL_CAPACITY, 0.75f, 16);
    }

    public ConcurrentHashSet(Set<? extends E> t) {
        this(Math.max((int)((float)t.size() / 0.75f) + 1, 11), 0.75f, 16);
        this.addAll(t);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, PRESENT) == null;
    }

    public boolean addIfAbsent(E e) {
        return this.map.putIfAbsent(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    public boolean removeIfPresent(Object o) {
        return this.map.remove(o, PRESENT);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            ConcurrentHashSet newSet = (ConcurrentHashSet)super.clone();
            newSet.map.putAll(this.map);
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("Clone fialed although Cloneable is implemented.");
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.map.size());
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            s.writeObject(i.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.map = new ConcurrentHashMap();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object e = s.readObject();
            this.map.put(e, PRESENT);
        }
    }
}

