/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.log;

import com.openexchange.java.StringAllocator;
import com.openexchange.log.ForceLog;
import com.openexchange.log.LogPropertyName;
import com.openexchange.log.Props;
import com.openexchange.session.Session;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public final class LogProperties {
    private static final List<LogPropertyName> PROPERTY_NAMES = new CopyOnWriteArrayList<LogPropertyName>();
    private static final AtomicBoolean ENABLED = new AtomicBoolean(false);
    private static final ConcurrentMap<Thread, Props> THREAD_LOCAL = new ConcurrentHashMap<Thread, Props>();

    private LogProperties() {
    }

    public static void configuredProperties(Collection<LogPropertyName> propertyNames) {
        PROPERTY_NAMES.clear();
        ENABLED.set(false);
        if (null != propertyNames && !propertyNames.isEmpty()) {
            PROPERTY_NAMES.addAll(new TreeSet<LogPropertyName>(propertyNames));
            ENABLED.set(true);
        }
    }

    public static List<LogPropertyName> getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public static boolean isEnabled() {
        return ENABLED.get();
    }

    public static Props optLogProperties() {
        return LogProperties.optLogProperties(Thread.currentThread());
    }

    public static Props optLogProperties(Thread thread) {
        if (null == thread) {
            return null;
        }
        Props props = (Props)THREAD_LOCAL.get(thread);
        if (props == null) {
            return null;
        }
        return props;
    }

    public static void removeLogProperties() {
        LogProperties.removeLogProperties(Thread.currentThread());
    }

    public static void removeLogProperties(Thread thread) {
        THREAD_LOCAL.remove(thread);
    }

    public static Props getLogProperties() {
        return LogProperties.getLogProperties(Thread.currentThread());
    }

    public static Props getLogProperties(Thread thread) {
        Props newprops;
        if (null == thread) {
            return null;
        }
        Props props = (Props)THREAD_LOCAL.get(thread);
        if (null == props && null == (props = THREAD_LOCAL.putIfAbsent(thread, newprops = new Props()))) {
            props = newprops;
        }
        return props;
    }

    public static void removeLogProperties(Collection<Name> names) {
        Props props = LogProperties.optLogProperties();
        if (null != props) {
            props.remove(names);
        }
    }

    public static void cloneLogProperties(Thread other) {
        Thread thread = Thread.currentThread();
        Props props = (Props)THREAD_LOCAL.get(thread);
        if (null == props) {
            return;
        }
        THREAD_LOCAL.put(other, new Props(props));
    }

    public static void putSessionProperties(Session session) {
        if (null == session) {
            return;
        }
        Props props = LogProperties.getLogProperties();
        props.put(Name.SESSION_SESSION_ID, session.getSessionID());
        props.put(Name.SESSION_USER_ID, ForceLog.valueOf(session.getUserId()));
        props.put(Name.SESSION_CONTEXT_ID, ForceLog.valueOf(session.getContextId()));
        String client = session.getClient();
        props.put(Name.SESSION_CLIENT_ID, client == null ? "unknown" : ForceLog.valueOf(client));
        props.put(Name.SESSION_SESSION, session);
    }

    public static void removeSessionProperties() {
        Props props = LogProperties.optLogProperties();
        if (null != props) {
            props.remove(Name.SESSION_SESSION_ID);
            props.remove(Name.SESSION_USER_ID);
            props.remove(Name.SESSION_CONTEXT_ID);
            props.remove(Name.SESSION_CLIENT_ID);
            props.remove(Name.SESSION_SESSION);
        }
    }

    public static <V> V getLogProperty(Name name) {
        Thread thread = Thread.currentThread();
        Props props = (Props)THREAD_LOCAL.get(thread);
        return null == props ? null : (V)props.get(name);
    }

    public static void putLogProperty(Name name, Object value) {
        if (null == value) {
            LogProperties.getLogProperties().remove(name);
        } else {
            LogProperties.getLogProperties().put(name, value);
        }
    }

    public static String getAndPrettyPrint() {
        return LogProperties.getAndPrettyPrint(Collections.<Name>emptySet());
    }

    public static String getAndPrettyPrint(Name nonMatching) {
        return LogProperties.getAndPrettyPrint(EnumSet.of(nonMatching));
    }

    public static String getAndPrettyPrint(Name ... nonMatching) {
        return LogProperties.getAndPrettyPrint(EnumSet.copyOf(Arrays.asList(nonMatching)));
    }

    public static String getAndPrettyPrint(Collection<Name> nonMatching) {
        String logString = "";
        Props logProperties = LogProperties.optLogProperties();
        if (logProperties != null) {
            StringAllocator logBuilder = new StringAllocator(1024);
            Map<Name, Object> propertyMap = logProperties.getMap();
            TreeMap<String, String> sorted = new TreeMap<String, String>();
            String sep = System.getProperty("line.separator");
            for (Map.Entry<Name, Object> entry : propertyMap.entrySet()) {
                Object value;
                Name propertyName = entry.getKey();
                if (null != nonMatching && nonMatching.contains((Object)propertyName) || null == (value = entry.getValue())) continue;
                sorted.put(propertyName.getName(), value.toString());
            }
            for (Map.Entry<Name, Object> entry : sorted.entrySet()) {
                logBuilder.append((String)((Object)entry.getKey())).append('=').append((String)entry.getValue()).append(sep);
            }
            logString = logBuilder.toString();
        }
        return logString;
    }

    public static enum Name {
        AJAX_REQUEST_NUMBER("com.openexchange.ajax.requestNumber"),
        AJAX_ACTION("com.openexchange.ajax.action"),
        AJAX_MODULE("com.openexchange.ajax.module"),
        AJP_REQUEST_URI("com.openexchange.ajpv13.requestURI"),
        AJP_SERVLET_PATH("com.openexchange.ajpv13.servletPath"),
        AJP_PATH_INFO("com.openexchange.ajpv13.pathInfo"),
        AJP_REQUEST_IP("com.openexchange.ajpv13.requestIp"),
        AJP_REQUEST_ID("com.openexchange.ajpv13.requestId"),
        AJP_SERVER_NAME("com.openexchange.ajpv13.serverName"),
        AJP_THREAD_NAME("com.openexchange.ajpv13.threadName"),
        AJP_REMOTE_PORT("com.openexchange.ajpv13.remotePort"),
        AJP_REMOTE_ADDRESS("com.openexchange.ajpv13.remoteAddress"),
        AJP_HTTP_SESSION("com.openexchange.ajp13.httpSession"),
        SESSION_SESSION_ID("com.openexchange.session.sessionId"),
        SESSION_USER_ID("com.openexchange.session.userId"),
        SESSION_CONTEXT_ID("com.openexchange.session.contextId"),
        SESSION_CLIENT_ID("com.openexchange.session.clientId"),
        SESSION_SESSION("com.openexchange.session.session"),
        GRIZZLY_REQUEST_URI("com.openexchange.grizzly.requestURI"),
        GRIZZLY_SERVLET_PATH("com.openexchange.grizzly.servletPath"),
        GRIZZLY_PATH_INFO("com.openexchange.grizzly.pathInfo"),
        GRIZZLY_REQUEST_IP("com.openexchange.grizzly.requestIp"),
        GRIZZLY_SERVER_NAME("com.openexchange.grizzly.serverName"),
        GRIZZLY_THREAD_NAME("com.openexchange.grizzly.threadName"),
        GRIZZLY_REMOTE_PORT("com.openexchange.grizzly.remotePort"),
        GRIZZLY_REMOTE_ADDRESS("com.openexchange.grizzly.remoteAddress"),
        GRIZZLY_HTTP_SESSION("com.openexchange.http.grizzly.session"),
        SERVLET_SERVLET_PATH("javax.servlet.servletPath"),
        SERVLET_PATH_INFO("javax.servlet.pathInfo"),
        SERVLET_QUERY_STRING("javax.servlet.queryString"),
        FILE_STORAGE_ACCOUNT_ID("com.openexchange.file.storage.accountId"),
        FILE_STORAGE_CONFIGURATION("com.openexchange.file.storage.configuration"),
        FILE_STORAGE_SERVICE_ID("com.openexchange.file.storage.serviceId"),
        MAIL_HOST("com.openexchange.mail.host"),
        MAIL_FULL_NAME("com.openexchange.mail.fullName"),
        MAIL_MAIL_ID("com.openexchange.mail.mailId"),
        MAIL_ACCOUNT_ID("com.openexchange.mail.accountId"),
        MAIL_LOGIN("com.openexchange.mail.login"),
        DATABASE_SCHEMA("com.openexchange.database.schema"),
        LOGIN_LOGIN("com.openexchange.login.login"),
        LOGIN_CLIENT_IP("com.openexchange.login.clientIp"),
        LOGIN_USER_AGENT("com.openexchange.login.userAgent"),
        LOGIN_AUTH_ID("com.openexchange.login.authId"),
        LOGIN_CLIENT("com.openexchange.login.client"),
        LOGIN_VERSION("com.openexchange.login.version");

        private final String name;
        private static final Map<String, Name> STRING2NAME;

        private Name(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Name nameFor(String sName) {
            return null == sName ? null : STRING2NAME.get(sName);
        }

        static {
            Name[] values = Name.values();
            HashMap<String, Name> m = new HashMap<String, Name>(values.length);
            for (Name name : values) {
                m.put(name.getName(), name);
            }
            STRING2NAME = m;
        }
    }
}

