/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.internal;

import com.openexchange.config.PropertyEvent;
import com.openexchange.config.PropertyListener;
import com.openexchange.config.internal.PropertyEventImpl;
import com.openexchange.config.internal.filewatcher.FileListener;
import com.openexchange.java.Streams;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class PropertyWatcher
implements FileListener {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(PropertyWatcher.class));
    private static final ConcurrentMap<String, PropertyWatcher> WATCHER_MAP = new ConcurrentHashMap<String, PropertyWatcher>();
    private final Map<Class<? extends PropertyListener>, PropertyListener> listeners = new ConcurrentHashMap<Class<? extends PropertyListener>, PropertyListener>();
    private final boolean caseInsensitive;
    private final String name;
    private String value;

    public static PropertyWatcher getPropertyWatcher(String name) {
        return (PropertyWatcher)WATCHER_MAP.get(name);
    }

    public static void removePropertWatcher(String name) {
        WATCHER_MAP.remove(name);
    }

    public static PropertyWatcher addPropertyWatcher(String name, String value, boolean caseInsensitive) {
        PropertyWatcher newWatcher;
        PropertyWatcher watcher = (PropertyWatcher)WATCHER_MAP.get(name);
        if (null == watcher && null == (watcher = WATCHER_MAP.putIfAbsent(name, newWatcher = new PropertyWatcher(name, value, caseInsensitive)))) {
            watcher = newWatcher;
        }
        return watcher;
    }

    private PropertyWatcher(String name, String value, boolean caseInsensitive) {
        this.name = name;
        this.value = value;
        this.caseInsensitive = caseInsensitive;
    }

    public void addPropertyListener(PropertyListener listener) {
        if (!this.listeners.containsKey(listener.getClass())) {
            this.listeners.put(listener.getClass(), listener);
        }
    }

    public void removePropertyListener(PropertyListener listener) {
        if (this.listeners.containsKey(listener.getClass())) {
            this.listeners.remove(listener.getClass());
        }
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onChange(File file) {
        BufferedInputStream fis;
        try {
            fis = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
            this.value = null;
            this.notifyListeners(true);
            return;
        }
        try {
            Properties properties = new Properties();
            properties.load(fis);
            String newValue = properties.getProperty(this.name);
            if (newValue == null) {
                this.value = null;
                this.notifyListeners(true);
                return;
            }
            if (this.caseInsensitive ? !newValue.equalsIgnoreCase(this.value) : !newValue.equals(this.value)) {
                this.value = newValue;
                this.notifyListeners(false);
            }
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            Streams.close((Closeable)fis);
        }
    }

    @Override
    public void onDelete() {
        this.value = null;
        this.notifyListeners(true);
    }

    private void notifyListeners(boolean isDelete) {
        PropertyEventImpl event = new PropertyEventImpl(this.name, this.value, isDelete ? PropertyEvent.Type.DELETED : PropertyEvent.Type.CHANGED);
        for (PropertyListener propertyListener : this.listeners.values()) {
            propertyListener.onPropertyChange(event);
        }
    }
}

