/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.ProtocolException;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.util.PropUtil;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.URLName;
import javax.security.auth.Subject;

public class JavaIMAPStore
extends IMAPStore {
    private final boolean enableSASL;
    private transient Subject kerberosSubject;
    protected String[] saslMechanisms;
    protected String saslRealm;
    private String authorizationID;
    private String proxyAuthUser;

    public JavaIMAPStore(Session session, URLName url, String name, boolean isSSL) {
        super(session, url, name, isSSL);
        this.enableSASL = PropUtil.getBooleanSessionProperty((Session)session, (String)"mail.imap.sasl.enable", (boolean)false);
        if (this.enableSASL) {
            this.kerberosSubject = (Subject)session.getProperties().get("mail.imap.sasl.kerberosSubject");
            String s = session.getProperty("mail.imap.sasl.mechanisms");
            if (s != null && s.length() > 0) {
                ArrayList<String> v = new ArrayList<String>(5);
                StringTokenizer st = new StringTokenizer(s, " ,");
                while (st.hasMoreTokens()) {
                    String m = st.nextToken();
                    if (m.length() <= 0) continue;
                    v.add(m);
                }
                this.saslMechanisms = v.toArray(new String[0]);
            }
            if ((s = session.getProperty("mail.imap.sasl.realm")) != null) {
                this.saslRealm = s;
            }
            if ((s = session.getProperty("mail." + name + ".sasl.authorizationid")) != null) {
                this.authorizationID = s;
            }
            if ((s = session.getProperty("mail." + name + ".proxyauth.user")) != null) {
                this.proxyAuthUser = s;
            }
        }
    }

    public JavaIMAPStore(Session session, URLName url) {
        this(session, url, "imap", false);
    }

    protected void login(final IMAPProtocol p, final String u, final String pw) throws ProtocolException {
        if (this.enableSASL && null != this.kerberosSubject) {
            final String authzid = this.authorizationID != null ? this.authorizationID : (this.proxyAuthUser != null ? this.proxyAuthUser : null);
            try {
                Subject.doAs(this.kerberosSubject, new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        p.sasllogin(JavaIMAPStore.this.saslMechanisms, JavaIMAPStore.this.saslRealm, authzid, u, pw);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                JavaIMAPStore.handlePrivilegedActionException(e);
            }
        } else {
            super.login(p, u, pw);
        }
    }

    private static void handlePrivilegedActionException(PrivilegedActionException e) throws ProtocolException {
        if (null == e) {
            return;
        }
        Exception cause = e.getException();
        if (null == cause) {
            throw new ProtocolException(e.getMessage());
        }
        if (cause instanceof ProtocolException) {
            throw (ProtocolException)cause;
        }
        if (cause instanceof MessagingException) {
            MessagingException me = (MessagingException)cause;
            Exception nextException = me.getNextException();
            if (nextException instanceof ProtocolException) {
                throw (ProtocolException)nextException;
            }
            throw new ProtocolException(me.getMessage(), (Throwable)me);
        }
        throw new ProtocolException(e.getMessage(), (Throwable)cause);
    }
}

