/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.ssl;

import com.openexchange.tools.ssl.TrustAllManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TrustAllSSLSocketFactory
extends SSLSocketFactory {
    private static final Log LOG = LogFactory.getLog(TrustAllSSLSocketFactory.class);
    private final SSLSocketFactory factory;

    protected TrustAllSSLSocketFactory() {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{new TrustAllManager()}, new SecureRandom());
            this.factory = context.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (KeyManagementException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static SSLSocketFactory getDefault() {
        return new TrustAllSSLSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        return TrustAllSSLSocketFactory.checkProtocols(this.factory.createSocket());
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return TrustAllSSLSocketFactory.checkProtocols(this.factory.createSocket(s, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return TrustAllSSLSocketFactory.checkProtocols(this.factory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        return TrustAllSSLSocketFactory.checkProtocols(this.factory.createSocket(host, port, localAddress, localPort));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return TrustAllSSLSocketFactory.checkProtocols(this.factory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return TrustAllSSLSocketFactory.checkProtocols(this.factory.createSocket(address, port, localAddress, localPort));
    }

    private static Socket checkProtocols(Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            TrustAllSSLSocketFactory.tryAddProtocol("SSLv3", sslSocket);
            TrustAllSSLSocketFactory.tryAddProtocol("SSLv2", sslSocket);
            TrustAllSSLSocketFactory.tryAddProtocol("TLSv1", sslSocket);
            TrustAllSSLSocketFactory.tryAddProtocol("SSLv23", sslSocket);
        }
        return socket;
    }

    private static boolean tryAddProtocol(String protocol, SSLSocket sslSocket) {
        LinkedHashSet<String> protocols = new LinkedHashSet<String>(Arrays.asList(sslSocket.getEnabledProtocols()));
        if (protocols.add(protocol)) {
            try {
                sslSocket.setEnabledProtocols(protocols.toArray(new String[0]));
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }
}

