/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.user;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.test.TestException;
import com.openexchange.webdav.xml.framework.WebDAVClient;
import com.openexchange.webdav.xml.user.actions.SearchRequest;
import com.openexchange.webdav.xml.user.actions.SearchResponse;
import java.io.IOException;
import java.util.Map;
import org.jdom2.JDOMException;

public final class GroupUserTools {
    private final WebDAVClient client;
    private int userId;

    public GroupUserTools(WebDAVClient client) {
        this.client = client;
    }

    public final int getUserId() throws OXException, IOException, JDOMException, OXException {
        return this.getUserId(null);
    }

    public final int getUserId(String host) throws OXException, IOException, JDOMException, OXException {
        if (0 == this.userId) {
            SearchRequest request = new SearchRequest();
            SearchResponse response = this.client.execute(host, request);
            for (Contact contact : response) {
                Map map = contact.getMap();
                if (map == null || !map.containsKey("myidentity")) continue;
                this.userId = contact.getInternalUserId();
                break;
            }
            if (0 == this.userId) {
                throw new TestException("Unable to find identifier of user.");
            }
        }
        return this.userId;
    }
}

