/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.tools.versit.Versit;
import com.openexchange.tools.versit.VersitDefinition;
import com.openexchange.tools.versit.VersitObject;
import com.openexchange.tools.versit.converter.OXContainerConverter;
import com.openexchange.webdav.AbstractWebdavTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.TimeZone;

public class ICalTest
extends AbstractWebdavTest {
    protected Date startTime = null;
    protected Date endTime = null;
    private static final String ICAL_URL = "/servlet/webdav.ical";

    public ICalTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testUpload() throws Exception {
        GetMethodWebRequest initRequest = new GetMethodWebRequest("http://" + this.hostName + ICAL_URL);
        initRequest.setHeaderField("authorization", "Basic " + ICalTest.getAuthData(this.login, this.password, this.context));
        WebResponse initresponse = this.webCon.getResponse((WebRequest)initRequest);
        ICalTest.assertEquals((int)200, (int)initresponse.getResponseCode());
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testUpload");
        appointmentObj.setStartDate(new Date());
        appointmentObj.setEndDate(new Date());
        Task taskObj = new Task();
        taskObj.setTitle("testUpload");
        taskObj.setStartDate(new Date());
        taskObj.setEndDate(new Date());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        VersitDefinition def = Versit.getDefinition((String)"text/calendar");
        VersitDefinition.Writer w = def.getWriter((OutputStream)byteArrayOutputStream, "UTF-8");
        VersitObject ical = OXContainerConverter.newCalendar((String)"2.0");
        def.writeProperties(w, ical);
        VersitDefinition eventDef = def.getChildDef("VEVENT");
        def.getChildDef("VTODO");
        OXContainerConverter oxContainerConverter = new OXContainerConverter(TimeZone.getDefault(), "t@t.de");
        VersitObject versitAppointment = oxContainerConverter.convertAppointment(appointmentObj);
        eventDef.write(w, versitAppointment);
        VersitObject versitTask = oxContainerConverter.convertTask(taskObj);
        eventDef.write(w, versitTask);
        def.writeEnd(w, ical);
        w.flush();
        byteArrayOutputStream.flush();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest("http://" + this.hostName + ICAL_URL, (InputStream)byteArrayInputStream, "text/calendar");
        req.setHeaderField("authorization", "Basic " + ICalTest.getAuthData(this.login, this.password, this.context));
        WebResponse resp = this.webCon.getResponse((WebRequest)req);
        ICalTest.assertEquals((int)200, (int)resp.getResponseCode());
    }

    public void testDownload() throws Exception {
        GetMethodWebRequest req = new GetMethodWebRequest("http://" + this.hostName + ICAL_URL);
        req.setHeaderField("authorization", "Basic " + ICalTest.getAuthData(this.login, this.password, this.context));
        WebResponse resp = this.webCon.getResponse((WebRequest)req);
        ICalTest.assertEquals((int)200, (int)resp.getResponseCode());
    }
}

