/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.regex;

import com.openexchange.tools.regex.RFC2616Regex;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ParseCookiesTest
extends TestCase {
    private final Log LOG = LogFactory.getLog(ParseCookiesTest.class);

    public ParseCookiesTest(String name) {
        super(name);
    }

    public void testCookie() throws Throwable {
        this.LOG.info((Object)("Version: " + RFC2616Regex.COOKIE_VERSION));
        String version = "$Version=0";
        ParseCookiesTest.assertTrue((boolean)RFC2616Regex.COOKIE_VERSION.matcher("$Version=0").matches());
        this.LOG.info((Object)RFC2616Regex.COOKIE_VALUE);
        String simple = "sessionid=aaa713ea6275b42205f040c6614701b7";
        ParseCookiesTest.assertTrue((boolean)RFC2616Regex.COOKIE_VALUE.matcher("sessionid=aaa713ea6275b42205f040c6614701b7").matches());
        this.LOG.info((Object)RFC2616Regex.COOKIES);
        String firstCookie = "$Version=0; sessionid=aaa713ea6275b42205f040c6614701b7";
        ParseCookiesTest.assertTrue((boolean)RFC2616Regex.COOKIES.matcher("$Version=0; sessionid=aaa713ea6275b42205f040c6614701b7").matches());
        String two = "sessionid=aaa713ea6275b42205f040c6614701b7, JSESSIONID=1fed47c83eb3d3d5178c510bbde887499591f014.OX1";
        ParseCookiesTest.assertTrue((boolean)RFC2616Regex.COOKIES.matcher("sessionid=aaa713ea6275b42205f040c6614701b7, JSESSIONID=1fed47c83eb3d3d5178c510bbde887499591f014.OX1").matches());
        String twoWithFirstVersion = "$Version=0; sessionid=aaa713ea6275b42205f040c6614701b7, JSESSIONID=1fed47c83eb3d3d5178c510bbde887499591f014.OX1";
        ParseCookiesTest.assertTrue((boolean)RFC2616Regex.COOKIES.matcher("$Version=0; sessionid=aaa713ea6275b42205f040c6614701b7, JSESSIONID=1fed47c83eb3d3d5178c510bbde887499591f014.OX1").matches());
        String twoWithVersion = "$Version=0; sessionid=aaa713ea6275b42205f040c6614701b7, $Version=0; JSESSIONID=1fed47c83eb3d3d5178c510bbde887499591f014.OX1";
        ParseCookiesTest.assertTrue((boolean)RFC2616Regex.COOKIES.matcher("$Version=0; sessionid=aaa713ea6275b42205f040c6614701b7, $Version=0; JSESSIONID=1fed47c83eb3d3d5178c510bbde887499591f014.OX1").matches());
        String valueWithPath = "JSESSIONID=1fed47c83eb3d3d5178c510bbde887499591f014.OX1; $Path=/";
        ParseCookiesTest.assertTrue((boolean)RFC2616Regex.COOKIES.matcher("JSESSIONID=1fed47c83eb3d3d5178c510bbde887499591f014.OX1; $Path=/").matches());
        String headerValue = "$Version=0; sessionid=aaa713ea6275b42205f040c6614701b7, $Version=0; JSESSIONID=1fed47c83eb3d3d5178c510bbde887499591f014.OX1; $Path=/";
        ParseCookiesTest.assertTrue((boolean)RFC2616Regex.COOKIES.matcher("$Version=0; sessionid=aaa713ea6275b42205f040c6614701b7, $Version=0; JSESSIONID=1fed47c83eb3d3d5178c510bbde887499591f014.OX1; $Path=/").matches());
    }
}

