/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures;

import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.groupware.container.Contact;
import com.openexchange.test.fixtures.ContactFinder;
import com.openexchange.test.fixtures.FixtureException;
import com.openexchange.test.fixtures.TestUserConfig;
import com.openexchange.test.fixtures.TestUserConfigFactory;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class SimpleCredentials
implements Cloneable {
    private String login;
    private String imapLogin;
    private String password;
    private Contact contact;
    private TestUserConfig config;
    private TestUserConfigFactory userConfigFactory = null;
    private final ContactFinder contactFinder;
    private Locale locale = null;
    private int userId = 0;
    private int contactId = 0;
    private String privateAppointmentFolderId = null;
    private String privateTaskFolderId = null;
    private String privateContactFolderId = null;
    private String privateInfostoreFolderId = null;
    private TimeZone timezone = null;
    private boolean hasFullGroupware;
    private boolean hasFullGroupwareSet = false;
    private boolean hasActiveSync;
    private boolean hasActiveSyncSet = false;
    private boolean hasOXUpdater;
    private boolean hasOXUpdaterSet = false;

    public SimpleCredentials(TestUserConfigFactory userConfigFactory, ContactFinder contactFinder) {
        this.userConfigFactory = userConfigFactory;
        this.contactFinder = contactFinder;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getIMAPLogin() {
        return null == this.imapLogin ? this.login : this.imapLogin;
    }

    public void setIMAPLogin(String imapLogin) {
        this.imapLogin = imapLogin;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Contact asContact() {
        if (null == this.contact) {
            this.contact = this.contactFinder.getContact(this);
        }
        return this.contact;
    }

    public TestUserConfig getConfig() {
        if (null == this.config) {
            this.config = this.userConfigFactory.create(this);
        }
        return this.config;
    }

    public int getUserId() {
        if (0 == this.userId) {
            this.userId = this.getConfig().getInt(Tree.Identifier);
        }
        return this.userId;
    }

    public int getContactId() {
        if (0 == this.contactId) {
            this.contactId = this.getConfig().getInt(Tree.Identifier);
        }
        return this.contactId;
    }

    public String getPrivateAppointmentFolderId() {
        if (null == this.privateAppointmentFolderId) {
            this.privateAppointmentFolderId = this.getConfig().getString(Tree.PrivateAppointmentFolder);
        }
        return this.privateAppointmentFolderId;
    }

    public String getPrivateTaskFolderId() {
        if (null == this.privateTaskFolderId) {
            this.privateTaskFolderId = this.getConfig().getString(Tree.PrivateTaskFolder);
        }
        return this.privateTaskFolderId;
    }

    public String getPrivateContactFolderId() {
        if (null == this.privateContactFolderId) {
            this.privateContactFolderId = this.getConfig().getString(Tree.PrivateContactFolder);
        }
        return this.privateContactFolderId;
    }

    public String getPrivateInfostoreFolderId() {
        if (null == this.privateInfostoreFolderId) {
            try {
                this.privateInfostoreFolderId = this.getConfig().getString(Tree.PrivateInfostoreFolder);
            }
            catch (Exception e) {
                this.privateInfostoreFolderId = "";
            }
        }
        return this.privateInfostoreFolderId;
    }

    public boolean hasFullGroupware() {
        if (!this.hasFullGroupwareSet) {
            this.hasFullGroupware = this.getConfig().getBool(Tree.InfostoreEnabled);
            this.hasFullGroupwareSet = true;
        }
        return this.hasFullGroupware;
    }

    public boolean hasActiveSync() {
        if (!this.hasActiveSyncSet) {
            this.hasActiveSync = this.getConfig().getBool(Tree.ActiveSync);
            this.hasActiveSyncSet = true;
        }
        return this.hasActiveSync;
    }

    public boolean hasOXUpdater() {
        if (!this.hasOXUpdaterSet) {
            this.hasOXUpdater = this.getConfig().getBool(Tree.OXUpdater);
            this.hasOXUpdaterSet = true;
        }
        return this.hasOXUpdater;
    }

    public TimeZone getTimeZone() {
        if (null == this.timezone) {
            this.timezone = TimeZone.getTimeZone(this.getConfig().getString(Tree.TimeZone));
        }
        return this.timezone;
    }

    public Locale getLocale() throws FixtureException {
        if (null == this.locale) {
            try {
                String[] language_country = this.getConfig().getString(Tree.Language).split("_");
                this.locale = new Locale(language_country[0], language_country[1]);
            }
            catch (Exception e) {
                throw new FixtureException("Unable to determine locale.", e);
            }
        }
        return this.locale;
    }

    public void resetLocal() {
        this.config = null;
        this.locale = null;
    }

    public Calendar getCalendar() {
        Calendar calendar = Calendar.getInstance(this.getTimeZone());
        calendar.setMinimalDaysInFirstWeek(4);
        calendar.setFirstDayOfWeek(2);
        return calendar;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleCredentials that = (SimpleCredentials)o;
        return (null != this.login ? this.login.equals(that.login) : null == that.login) && (null != this.password ? this.password.equals(that.password) : null == that.password);
    }

    public int hashCode() {
        int result = this.login != null ? this.login.hashCode() : 0;
        return result;
    }

    public String toString() {
        return String.format("SimpleCredentials[%s]", null != this.getLogin() ? this.getLogin() : "");
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

