/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.pubsub;

import com.openexchange.groupware.container.Contact;
import com.openexchange.pubsub.AbstractContactTemplateTest;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.microformats.MicroformatSubscribeService;
import com.openexchange.templating.OXTemplate;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class BasicContactTemplateTest
extends AbstractContactTemplateTest {
    public BasicContactTemplateTest() {
    }

    public BasicContactTemplateTest(String name) {
        super(name);
    }

    protected abstract OXTemplate getTemplate() throws Exception;

    public void testSingle() throws Exception {
        SubscriptionSource source = this.getSubscriptionSource();
        MicroformatSubscribeService service = this.getSubscribeService();
        this.introduceToEachOther(service, source);
        StringWriter writer = new StringWriter();
        Contact expected = this.generateContact("");
        List<Contact> expecteds = Arrays.asList(expected);
        OXTemplate templ = this.getTemplate();
        Map<String, Object> variables = this.getVariables();
        variables.put("contacts", expecteds);
        templ.process(variables, (Writer)writer);
        String htmlData = writer.toString();
        Collection actuals = service.getContent((Reader)new StringReader(htmlData));
        BasicContactTemplateTest.assertEquals((String)"Should return one contact", (int)1, (int)actuals.size());
        Contact actual = (Contact)actuals.iterator().next();
        for (int field : Contact.ALL_COLUMNS) {
            BasicContactTemplateTest.assertEquals((String)("Comparing field #" + field), (Object)expected.get(field), (Object)actual.get(field));
        }
    }

    public void testSeveral() throws Exception {
        SubscriptionSource source = this.getSubscriptionSource();
        MicroformatSubscribeService service = this.getSubscribeService();
        this.introduceToEachOther(service, source);
        StringWriter writer = new StringWriter();
        List<Contact> expecteds = this.getContacts();
        OXTemplate templ = this.getTemplate();
        Map<String, Object> variables = this.getVariables();
        variables.put("contacts", expecteds);
        templ.process(variables, (Writer)writer);
        String htmlData = writer.toString();
        Collection actuals = service.getContent((Reader)new StringReader(htmlData));
        BasicContactTemplateTest.assertEquals((String)"Should return the same amount of contacts as were inserted", (int)expecteds.size(), (int)actuals.size());
        for (Contact expected : expecteds) {
            BasicContactTemplateTest.assertTrue((String)("Should contain the following contact: " + expected), (boolean)actuals.contains(expected));
        }
    }
}

