/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.messagestorage;

import com.openexchange.exception.OXException;
import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.messagestorage.CombinationGenerator;
import com.openexchange.mail.mime.HeaderCollection;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.permission.MailPermission;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import javax.mail.internet.InternetAddress;

public abstract class MessageStorageTest
extends AbstractMailTest {
    public static final String[] NON_MATCHING_HEADERS = new String[]{"From", "To", "Cc", "Bcc", "Disposition-Notification-To", "Reply-To", "Subject", "Date", "Importance", "X-Priority", "Message-ID", "In-Reply-To", "References", "X-OX-VCard-Attached", "X-OX-Notification"};
    protected static final MailField[] FIELDS_ID = new MailField[]{MailField.ID};
    protected static final MailField[] FIELDS_MORE = new MailField[]{MailField.ID, MailField.CONTENT_TYPE, MailField.FLAGS, MailField.BODY};
    protected MailAccess<?, ?> mailAccess = null;
    protected MailMessage[] testmessages = null;

    protected MessageStorageTest() {
    }

    protected MessageStorageTest(String name) {
        super(name);
    }

    protected static MailField[][] generateVariations() {
        MailField[] values = MailField.values();
        int number = 1 << values.length;
        MailField[][] retval = new MailField[number][];
        int t = 0;
        for (int o = 1; o <= values.length; ++o) {
            CombinationGenerator x = new CombinationGenerator(values.length, o);
            while (x.hasMore()) {
                int[] indices = x.getNext();
                retval[t] = new MailField[indices.length];
                for (int i = 0; i < indices.length; ++i) {
                    retval[t][i] = values[indices[i]];
                }
                ++t;
            }
        }
        return retval;
    }

    private static long fac(long l) {
        long retval = 1L;
        for (long i = 1L; i < l; ++i) {
            retval *= i;
        }
        return retval;
    }

    private static boolean isValidAddressHeader(MailMessage mail, String name) {
        String addressStr = mail.getHeader(name, ',');
        if (null == addressStr || addressStr.length() == 0) {
            return true;
        }
        try {
            InternetAddress.parse((String)MimeMessageUtility.decodeMultiEncodedHeader((String)addressStr), (boolean)true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void compareMailMessages(MailMessage mail1, MailMessage mail2, MailField[] fields1, MailField[] fields2, String mail1name, String mail2name, boolean firstvalueParsed) {
        EnumSet<MailField> comparefields;
        EnumSet<MailField> set1 = EnumSet.copyOf(Arrays.asList(fields1));
        EnumSet<MailField> set2 = EnumSet.copyOf(Arrays.asList(fields2));
        this.checkFieldsSet(mail1, set1, mail1name, firstvalueParsed);
        this.checkFieldsSet(mail2, set2, mail2name, false);
        if (set1.contains(MailField.FULL) && !set2.contains(MailField.FULL)) {
            comparefields = set2;
        } else if (set2.contains(MailField.FULL) && !set1.contains(MailField.FULL)) {
            comparefields = set1;
        } else if (set1.size() > set2.size()) {
            comparefields = EnumSet.copyOf(set1);
            comparefields.retainAll(set2);
        } else {
            comparefields = EnumSet.copyOf(set2);
            set2.retainAll(set1);
        }
        if (comparefields.contains(MailField.ID) || comparefields.contains(MailField.FULL)) {
            this.check("Mail ID", mail1.getMailId(), mail2.getMailId(), mail1name, mail2name);
        }
        if (comparefields.contains(MailField.CONTENT_TYPE) || comparefields.contains(MailField.FULL)) {
            this.check("Content type", mail1.getContentType(), mail2.getContentType(), mail1name, mail2name);
        }
        if (comparefields.contains(MailField.FLAGS) || comparefields.contains(MailField.FULL)) {
            this.check("Flags", mail1.getFlags(), mail2.getFlags(), mail1name, mail2name);
        }
        if ((comparefields.contains(MailField.FROM) || comparefields.contains(MailField.FULL)) && MessageStorageTest.isValidAddressHeader(mail1, "From")) {
            this.check("From", mail1.getFrom(), mail2.getFrom(), mail1name, mail2name);
        }
        if ((comparefields.contains(MailField.TO) || comparefields.contains(MailField.FULL)) && MessageStorageTest.isValidAddressHeader(mail1, "To")) {
            this.check("To", mail1.getTo(), mail2.getTo(), mail1name, mail2name);
        }
        if ((comparefields.contains(MailField.DISPOSITION_NOTIFICATION_TO) || comparefields.contains(MailField.FULL)) && MessageStorageTest.isValidAddressHeader(mail1, "Disposition-Notification-To")) {
            this.check("Disposition-Notification-To", mail1.getDispositionNotification(), mail2.getDispositionNotification(), mail1name, mail2name);
        }
        if (comparefields.contains(MailField.COLOR_LABEL) || comparefields.contains(MailField.FULL)) {
            this.check("Color label", mail1.getColorLabel(), mail2.getColorLabel(), mail1name, mail2name);
        }
        if (comparefields.contains(MailField.HEADERS) || comparefields.contains(MailField.FULL)) {
            // empty if block
        }
        if (comparefields.contains(MailField.SUBJECT) || comparefields.contains(MailField.FULL)) {
            this.check("Subject", mail1.getSubject(), mail2.getSubject(), mail1name, mail2name);
        }
        if (comparefields.contains(MailField.THREAD_LEVEL) || comparefields.contains(MailField.FULL)) {
            this.check("Thread level", mail1.getThreadLevel(), mail2.getThreadLevel(), mail1name, mail2name);
        }
        if (comparefields.contains(MailField.PRIORITY) || comparefields.contains(MailField.FULL)) {
            this.check("Priority", mail1.getPriority(), mail2.getPriority(), mail1name, mail2name);
        }
        if (comparefields.contains(MailField.SENT_DATE) || comparefields.contains(MailField.FULL)) {
            this.check("Sent date", mail1.getSentDate(), mail2.getSentDate(), mail1name, mail2name);
        }
        if (comparefields.contains(MailField.RECEIVED_DATE) || comparefields.contains(MailField.FULL)) {
            this.check("Received date", mail1.getReceivedDate(), mail2.getReceivedDate(), mail1name, mail2name);
        }
        if ((comparefields.contains(MailField.CC) || comparefields.contains(MailField.FULL)) && MessageStorageTest.isValidAddressHeader(mail1, "Cc")) {
            this.check("CC", mail1.getCc(), mail2.getCc(), mail1name, mail2name);
        }
        if ((comparefields.contains(MailField.BCC) || comparefields.contains(MailField.FULL)) && MessageStorageTest.isValidAddressHeader(mail1, "Bcc")) {
            this.check("BCC", mail1.getBcc(), mail2.getBcc(), mail1name, mail2name);
        }
        if (comparefields.contains(MailField.FOLDER_ID) || comparefields.contains(MailField.FULL)) {
            this.check("Folder id", mail1.getFolder(), mail2.getFolder(), mail1name, mail2name);
        }
    }

    protected String createTemporaryFolder(SessionObject session, MailAccess<?, ?> mailAccess) throws OXException {
        return this.createTemporaryFolderAndGetFullname(session, mailAccess, "TemporaryFolder");
    }

    protected String createTemporaryFolderAndGetFullname(SessionObject session, MailAccess<?, ?> mailAccess, String tempFolderName) throws OXException {
        String parentFullname;
        String fullname;
        MailFolder inbox = mailAccess.getFolderStorage().getFolder("INBOX");
        if (inbox.isHoldsFolders()) {
            fullname = inbox.getFullname() + inbox.getSeparator() + tempFolderName;
            parentFullname = "INBOX";
        } else {
            fullname = tempFolderName;
            parentFullname = "default";
        }
        MailFolderDescription mfd = new MailFolderDescription();
        mfd.setExists(false);
        mfd.setParentFullname(parentFullname);
        mfd.setSeparator(inbox.getSeparator());
        mfd.setName(tempFolderName);
        mfd.addPermission(this.getPermission(session));
        mailAccess.getFolderStorage().createFolder(mfd);
        return fullname;
    }

    protected MailAccess<?, ?> getMailAccess() throws OXException {
        SessionObject session = this.getSession();
        MailAccess mailAccess = MailAccess.getInstance((Session)session);
        mailAccess.connect();
        return mailAccess;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.testmessages = MessageStorageTest.getMessages(this.getTestMailDir(), -1);
        this.mailAccess = this.getMailAccess();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.mailAccess.close(false);
    }

    private void check(String string, HeaderCollection value1, HeaderCollection value2, String mail1name, String mail2name) {
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        sb.append(" of ");
        sb.append(mail1name);
        sb.append(": ``");
        sb.append(value1);
        sb.append("'' is not equal with ");
        sb.append(mail2name);
        sb.append(": ``");
        sb.append(value2).append("''");
        MessageStorageTest.assertTrue((String)sb.toString(), (boolean)this.equalsCheckWithNull(value1, value2));
    }

    private void check(String string, int value1, int value2, String mail1name, String mail2name) {
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        sb.append(" of ");
        sb.append(mail1name);
        sb.append(": ``");
        sb.append(value1);
        sb.append("'' is not equal with ");
        sb.append(mail2name);
        sb.append(": ``");
        sb.append(value2);
        sb.append("''");
        MessageStorageTest.assertTrue((String)sb.toString(), (value1 == value2 ? 1 : 0) != 0);
    }

    private void check(String string, InternetAddress[] address1, InternetAddress[] address2, String mail1name, String mail2name) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(string);
        sb.append(" of ");
        sb.append(mail1name);
        sb.append(": ``");
        sb.append(Arrays.toString(address1));
        sb.append("'' are not equal with ");
        sb.append(mail2name);
        sb.append(": ``");
        sb.append(Arrays.toString(address2));
        sb.append("''");
        MessageStorageTest.assertTrue((String)sb.toString(), (boolean)this.equals(address1, address2));
    }

    private boolean equals(InternetAddress[] a, InternetAddress[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            InternetAddress o1 = a[i];
            InternetAddress o2 = a2[i];
            if (o1 != null ? o1.getAddress().equals(o2.getAddress()) : o2 == null) continue;
            return false;
        }
        return true;
    }

    private void check(String string, long value1, long value2, String mail1name, String mail2name) {
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        sb.append(" of ");
        sb.append(mail1name);
        sb.append(": ``");
        sb.append(value1);
        sb.append("'' are not equal with ");
        sb.append(mail2name);
        sb.append(": ``");
        sb.append(value2);
        sb.append("''");
        MessageStorageTest.assertTrue((String)sb.toString(), (value1 == value2 ? 1 : 0) != 0);
    }

    private void check(String string, Object value1, Object value2, String mail1name, String mail2name) {
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        sb.append(" of ");
        sb.append(mail1name);
        sb.append(": ``");
        sb.append(value1);
        sb.append("'' is not equal with ");
        sb.append(mail2name);
        sb.append(": ``");
        sb.append(value2).append("''");
        MessageStorageTest.assertTrue((String)sb.toString(), (boolean)this.equalsCheckWithNull(value1, value2));
    }

    private void check(String string, String value1, String value2, String mail1name, String mail2name) {
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        sb.append(" of ");
        sb.append(mail1name);
        sb.append(": ``");
        sb.append(value1);
        sb.append("'' is not equal with ");
        sb.append(mail2name);
        sb.append(": ``");
        sb.append(value2).append("''");
        MessageStorageTest.assertTrue((String)sb.toString(), (boolean)this.equalsCheckWithNull(value1, value2));
    }

    private void checkFieldsSet(MailMessage mail, Set<MailField> set, String mailname, boolean parsed) {
        boolean full = set.contains(MailField.FULL);
        if (full || set.contains(MailField.ID)) {
            MessageStorageTest.assertTrue((String)("Missing mail ID in " + mailname), (mail.getMailId() != null ? 1 : 0) != 0);
        }
        if (full || set.contains(MailField.FLAGS)) {
            MessageStorageTest.assertTrue((String)("Missing flags in " + mailname), (boolean)mail.containsFlags());
        } else if (parsed) {
            MessageStorageTest.assertTrue((String)("Flags set in " + mailname + " although not requested"), (!mail.containsFlags() || mail.containsFlags() && mail.getFlags() == 0 ? 1 : 0) != 0);
        }
        boolean headers = set.contains(MailField.HEADERS);
        if (full || headers) {
            MessageStorageTest.assertTrue((String)("Missing headers in " + mailname), (boolean)mail.containsHeaders());
        }
        if (full || set.contains(MailField.FROM) || headers) {
            MessageStorageTest.assertTrue((String)("Missing From in " + mailname), (boolean)mail.containsFrom());
        }
        if (full || set.contains(MailField.TO) || headers) {
            MessageStorageTest.assertTrue((String)("Missing To in " + mailname), (boolean)mail.containsTo());
        }
        if (!headers) {
            if (full || set.contains(MailField.CC)) {
                MessageStorageTest.assertTrue((String)("Missing Cc in " + mailname), (boolean)mail.containsCc());
            }
            if (full || set.contains(MailField.BCC)) {
                MessageStorageTest.assertTrue((String)("Missing Bcc in " + mailname), (boolean)mail.containsBcc());
            }
            if (full || set.contains(MailField.CONTENT_TYPE)) {
                MessageStorageTest.assertTrue((String)("Missing content type in " + mailname), (boolean)mail.containsContentType());
            }
            if (full || set.contains(MailField.DISPOSITION_NOTIFICATION_TO)) {
                MessageStorageTest.assertTrue((String)("Missing Disposition-Notification-To in " + mailname), (boolean)mail.containsDispositionNotification());
            }
            if (full || set.contains(MailField.PRIORITY)) {
                MessageStorageTest.assertTrue((String)("Missing priority in " + mailname), (boolean)mail.containsPriority());
            }
        }
        if (full || set.contains(MailField.COLOR_LABEL)) {
            MessageStorageTest.assertTrue((String)("Missing color label in " + mailname), (boolean)mail.containsColorLabel());
        }
        if (full || set.contains(MailField.SUBJECT) || headers) {
            MessageStorageTest.assertTrue((String)("Missing subject in " + mailname), (boolean)mail.containsSubject());
        }
        if (full || set.contains(MailField.THREAD_LEVEL)) {
            MessageStorageTest.assertTrue((String)("Missing thread level in " + mailname), (boolean)mail.containsThreadLevel());
        }
        if (full || set.contains(MailField.SIZE)) {
            MessageStorageTest.assertTrue((String)("Missing size in " + mailname), (boolean)mail.containsSize());
        }
        if (full || set.contains(MailField.SENT_DATE) || headers) {
            MessageStorageTest.assertTrue((String)("Missing sent date in " + mailname), (boolean)mail.containsSentDate());
        }
        if (full || set.contains(MailField.RECEIVED_DATE)) {
            MessageStorageTest.assertTrue((String)("Missing received date in " + mailname), (boolean)mail.containsReceivedDate());
        }
        if (full || set.contains(MailField.FOLDER_ID)) {
            MessageStorageTest.assertTrue((String)("Missing folder fullname in " + mailname), (boolean)mail.containsFolder());
        }
    }

    private boolean equalsCheckWithNull(HeaderCollection a, HeaderCollection b) {
        if (null == a) {
            return null == b;
        }
        HeaderCollection headerCollectiona = new HeaderCollection(a);
        HeaderCollection headerCollectionb = new HeaderCollection(b);
        if (a.containsHeader("X-OX-Marker")) {
            headerCollectiona.removeHeader("X-OX-Marker");
        } else if (b.containsHeader("X-OX-Marker")) {
            headerCollectionb.removeHeader("X-OX-Marker");
        }
        return headerCollectiona.equals((Object)headerCollectionb);
    }

    private boolean equalsCheckWithNull(Object a, Object b) {
        if (null == a) {
            return null == b;
        }
        return a.equals(b);
    }

    private boolean equalsCheckWithNull(String a, String b) {
        if (null == a) {
            return null == b;
        }
        return a.trim().equals(b.trim());
    }

    private String getFullFolderName(MailFolder inbox, String tempFolderName) {
        return inbox.getFullname() + inbox.getSeparator() + tempFolderName;
    }

    private MailPermission getPermission(SessionObject session) throws OXException {
        MailPermission p = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
        p.setEntity(this.getUser());
        p.setAllPermission(128, 128, 128, 128);
        p.setFolderAdmin(true);
        p.setGroupPermission(false);
        return p;
    }
}

