/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.UpdateTest;
import com.openexchange.groupware.update.tasks.InfostoreRenamePersonalInfostoreFolders;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class RenamePersonalInfostoreFoldersTest
extends UpdateTest {
    private UpdateTask updateTask = null;
    private final int parent = 9;
    private final int module = 8;
    private final int type = 2;
    private final int start_ids = 2000;
    private int idcount = 2000;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.updateTask = new InfostoreRenamePersonalInfostoreFolders();
    }

    @Override
    public void tearDown() throws Exception {
        this.exec("DELETE FROM oxfolder_tree WHERE cid = ? and fuid >= ?", this.existing_ctx_id, 2000);
        super.tearDown();
    }

    public void createNameCollisions() throws OXException, SQLException {
        int i;
        for (i = 0; i < 3; ++i) {
            this.createFolder("test test");
        }
        this.createFolder("normal folder");
        for (i = 0; i < 2; ++i) {
            this.createFolder("test2 test2");
        }
    }

    public void createSneakyNameCollision() throws OXException, SQLException {
        for (int i = 0; i < 3; ++i) {
            this.createFolder("test test");
        }
        this.createFolder("test test (2)");
    }

    public void createMany() throws OXException, SQLException {
        for (int i = 0; i < 4000; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.createFolder("test test " + i);
            }
        }
    }

    public void testFixSchema() throws OXException, SQLException {
        this.createNameCollisions();
        this.updateTask.perform(this.schema, this.existing_ctx_id);
        this.assertNoCollisions();
        this.assertFolderNames("test test", "test test (1)", "test test (2)", "normal folder", "test2 test2", "test2 test2 (1)");
    }

    public void testNameCollision() throws SQLException, OXException {
        this.createSneakyNameCollision();
        this.updateTask.perform(this.schema, this.existing_ctx_id);
        this.assertNoCollisions();
        this.assertFolderNames("test test", "test test (1)", "test test (2)", "test test (3)");
    }

    public void testRunMultipleTimesNonDestructively() throws OXException, SQLException {
        this.createNameCollisions();
        this.updateTask.perform(this.schema, this.existing_ctx_id);
        this.updateTask.perform(this.schema, this.existing_ctx_id);
        this.updateTask.perform(this.schema, this.existing_ctx_id);
        this.updateTask.perform(this.schema, this.existing_ctx_id);
        this.updateTask.perform(this.schema, this.existing_ctx_id);
        this.updateTask.perform(this.schema, this.existing_ctx_id);
        this.assertNoCollisions();
        this.assertFolderNames("test test", "test test (1)", "test test (2)", "normal folder", "test2 test2", "test2 test2 (1)");
    }

    public void notestManyManyMany() throws OXException, SQLException {
        this.createMany();
        this.updateTask.perform(this.schema, this.existing_ctx_id);
    }

    public void assertNoCollisions() throws OXException, SQLException {
        RenamePersonalInfostoreFoldersTest.assertEquals((int)0, (int)this.countCollisions());
    }

    public void assertFolderNames(String ... expected) throws OXException, SQLException {
        List<String> folders = this.loadFolderNames();
        RenamePersonalInfostoreFoldersTest.assertEquals((String)folders.toString(), (int)expected.length, (int)folders.size());
        for (String fname : expected) {
            RenamePersonalInfostoreFoldersTest.assertTrue((String)(fname + " not found"), (boolean)folders.remove(fname));
        }
    }

    private final void createFolder(String fname) throws OXException, SQLException {
        this.exec("INSERT INTO oxfolder_tree (fuid, cid, parent, fname, module, type, default_flag,creating_date,changing_date,created_from, changed_from, permission_flag, subfolder_flag) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)", this.idcount++, this.existing_ctx_id, 9, fname, 8, 2, 1, 0, 0, this.user_id, this.user_id, 3, 0);
    }

    private int countCollisions() throws OXException, SQLException {
        HashSet<String> seen = new HashSet<String>();
        List<String> folderNames = this.loadFolderNames();
        int collisionCount = 0;
        for (String fname : folderNames) {
            if (seen.add(fname)) continue;
            ++collisionCount;
        }
        return collisionCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadFolderNames() throws OXException, SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            con = Database.get((int)this.existing_ctx_id, (boolean)true);
            stmt = con.prepareStatement("SELECT fname FROM oxfolder_tree WHERE cid = ? and parent = ? and module = ? and fuid >= ?");
            stmt.setInt(1, this.existing_ctx_id);
            stmt.setInt(2, 9);
            stmt.setInt(3, 8);
            stmt.setInt(4, 2000);
            rs = stmt.executeQuery();
            while (rs.next()) {
                names.add(rs.getString(1));
            }
        }
        finally {
            if (null != rs) {
                rs.close();
            }
            if (null != stmt) {
                stmt.close();
            }
            Database.back((int)this.existing_ctx_id, (boolean)true, (Connection)con);
        }
        return names;
    }
}

