/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.results;

import com.openexchange.groupware.results.AbstractTimedResult;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import java.util.ArrayList;
import junit.framework.TestCase;

public class AbstractTimedResultTest
extends TestCase {
    private TestTimedResult results;

    public void testExtractsLargestTimestampAfterIteration() throws Exception {
        this.consume(this.results, 1L, 2L, 6L, 4L, 3L);
        AbstractTimedResultTest.assertEquals((long)6L, (long)this.results.sequenceNumber());
    }

    public void testExtractsTimestampBeforeIteration() throws Exception {
        AbstractTimedResultTest.assertEquals((long)6L, (long)this.results.sequenceNumber());
        this.consume(this.results, 1L, 2L, 6L, 4L, 3L);
    }

    public void testExtractsTimestampInIteration() throws Exception {
        this.consume(this.results, 1L, 2L, 6L);
        AbstractTimedResultTest.assertEquals((long)6L, (long)this.results.sequenceNumber());
        this.consume(this.results, 4L, 3L);
    }

    private void consume(TestTimedResult ttr, long ... values) throws Exception {
        SearchIterator iter = ttr.results();
        for (int i = 0; i < values.length; ++i) {
            long timestamp = values[i];
            AbstractTimedResultTest.assertTrue((boolean)iter.hasNext());
            AbstractTimedResultTest.assertEquals((long)((Thing)iter.next()).getSequenceNumber(), (long)timestamp);
        }
    }

    public void setUp() {
        SearchIteratorAdapter iterator = new SearchIteratorAdapter(new ArrayList<Thing>(){
            {
                this.add(new Thing(1L));
                this.add(new Thing(2L));
                this.add(new Thing(6L));
                this.add(new Thing(4L));
                this.add(new Thing(3L));
            }
        }.iterator());
        this.results = new TestTimedResult((SearchIterator<Thing>)iterator);
    }

    private static class TestTimedResult
    extends AbstractTimedResult<Thing> {
        public TestTimedResult(SearchIterator<Thing> results) {
            super(results);
        }

        protected long extractTimestamp(Thing object) {
            return object.getSequenceNumber();
        }
    }

    private static final class Thing {
        private final long sequenceNumber;

        public Thing(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        private long getSequenceNumber() {
            return this.sequenceNumber;
        }
    }
}

