/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Bug23612Test
extends CalDAVTest {
    public Bug23612Test(String name) {
        super(name);
    }

    public void testUpdateAppointment() throws Exception {
        for (int shownAs : new int[]{4, 2, 1, 3}) {
            this.updateAppointment(shownAs);
        }
    }

    private void updateAppointment(int appointmentShownAs) throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = Bug23612Test.randomUID();
        String summary = "Bug23612Test-" + appointmentShownAs;
        String location = "ja";
        Date start = TimeTools.D("next monday at 5:00");
        Date end = TimeTools.D("next monday at 5:55");
        Appointment appointment = Bug23612Test.generateAppointment(start, end, uid, summary, location);
        appointment.setShownAs(appointmentShownAs);
        super.rememberForCleanUp(super.create(appointment));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Bug23612Test.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug23612Test.assertContains(uid, calendarData);
        Bug23612Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug23612Test.assertEquals((String)"SUMMARY wrong", (String)summary, (String)iCalResource.getVEvent().getSummary());
        Bug23612Test.assertEquals((String)"LOCATION wrong", (String)location, (String)iCalResource.getVEvent().getLocation());
        if (null != iCalResource.getVEvent().getTransp()) {
            Bug23612Test.assertEquals((String)"TRANSP wrong", (String)(4 == appointmentShownAs ? "TRANSPARENT" : "OPAQUE"), (String)iCalResource.getVEvent().getTransp());
        }
        iCalResource.getVEvent().setSummary(appointment.getTitle() + "_edit");
        Bug23612Test.assertEquals((String)"response code wrong", (int)201, (int)super.putICalUpdate(iCalResource));
        appointment = super.getAppointment(uid);
        Bug23612Test.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Bug23612Test.assertEquals((String)"shown as wrong", (int)appointmentShownAs, (int)appointment.getShownAs());
    }
}

