/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.user.actions;

import com.openexchange.ajax.contact.action.ContactSearchJSONWriter;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.user.actions.AbstractUserRequest;
import com.openexchange.ajax.user.actions.SearchParser;
import com.openexchange.ajax.user.actions.SearchResponse;
import com.openexchange.groupware.search.ContactSearchObject;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;

public final class SearchRequest
extends AbstractUserRequest<SearchResponse> {
    public static final int[] DEFAULT_COLUMNS = new int[]{1, 524, 555};
    private final ContactSearchObject search;
    private final int[] columns;
    private final boolean failOnError;
    private final List<AJAXRequest.Parameter> parameters;

    public SearchRequest(ContactSearchObject search, int[] columns) {
        this(search, columns, true);
    }

    public SearchRequest(ContactSearchObject search, int[] columns, boolean failOnError) {
        this(search, columns, failOnError, null);
    }

    public SearchRequest(ContactSearchObject search, int[] columns, boolean failOnError, List<AJAXRequest.Parameter> parameters) {
        this.search = search;
        this.failOnError = failOnError;
        this.columns = columns;
        this.parameters = new ArrayList<AJAXRequest.Parameter>();
        this.parameters.add(new AJAXRequest.Parameter("action", "search"));
        this.parameters.add(new AJAXRequest.Parameter("columns", columns));
        if (parameters != null) {
            this.parameters.addAll(parameters);
        }
    }

    @Override
    public Object getBody() throws JSONException {
        return ContactSearchJSONWriter.write(this.search);
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return this.parameters.toArray(new AJAXRequest.Parameter[this.parameters.size()]);
    }

    public SearchParser getParser() {
        return new SearchParser(this.failOnError, this.columns);
    }
}

