/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mailaccount.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.mailaccount.actions.MailAccountAllParser;
import com.openexchange.ajax.mailaccount.actions.MailAccountAllResponse;

public class MailAccountAllRequest
implements AJAXRequest<MailAccountAllResponse> {
    private final String columns;
    private final boolean failOnError;
    private final int[] cols;

    public MailAccountAllRequest(boolean failOnError, int ... cols) {
        StringBuilder bob = new StringBuilder();
        for (int colId : cols) {
            bob.append(colId).append(',');
        }
        bob.setLength(bob.length() - 1);
        this.columns = bob.toString();
        this.failOnError = failOnError;
        this.cols = cols;
    }

    public MailAccountAllRequest(int ... cols) {
        this(true, cols);
    }

    @Override
    public Object getBody() {
        return null;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "all"), new AJAXRequest.Parameter("columns", this.columns)};
    }

    @Override
    public AbstractAJAXParser<MailAccountAllResponse> getParser() {
        return new MailAccountAllParser(this.failOnError, this.cols);
    }

    @Override
    public String getServletPath() {
        return "/ajax/account";
    }
}

