/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.netsol;

public final class DurationTracker {
    private final long[] durations;
    private boolean full;
    private int pointer;
    private long maxDuration = Long.MIN_VALUE;
    private long minDuration = Long.MAX_VALUE;

    public DurationTracker(int length) {
        this.durations = new long[length];
    }

    public void addDuration(long duration) {
        this.maxDuration = Math.max(duration, this.maxDuration);
        this.minDuration = Math.min(duration, this.minDuration);
        this.durations[this.pointer++] = duration;
        this.pointer %= this.durations.length;
        if (!this.full && this.pointer == 0) {
            this.full = true;
        }
    }

    public long getMaxDuration() {
        return this.maxDuration;
    }

    public long getMinDuration() {
        return this.minDuration;
    }

    public double computeAvgDuration() {
        long avgDuration = 0L;
        int len = this.full ? this.durations.length : this.pointer;
        for (int i = 0; i < len; ++i) {
            avgDuration += this.durations[i];
        }
        return (double)avgDuration / (double)len;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Max. duration=").append(this.maxDuration).append("msec, Min. duration=").append(this.minDuration);
        sb.append("msec, Avg. duration=").append(this.computeAvgDuration()).append("msec");
        return sb.toString();
    }
}

