/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.mail.actions.MailSearchParser;
import com.openexchange.ajax.mail.actions.MailSearchResponse;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;

public class MailSearchRequest
implements AJAXRequest<MailSearchResponse> {
    private final List<AJAXRequest.Parameter> params = new LinkedList<AJAXRequest.Parameter>();
    private JSONArray body;
    private final MailSearchParser searchParser;

    public MailSearchRequest(String folder, int[] columns, int orderBy, String orderDir, boolean failOnError) {
        this.searchParser = new MailSearchParser(failOnError, columns);
        this.param("action", "search");
        this.param("folder", folder);
        this.param("columns", this.join(columns));
        if (orderBy != -1) {
            this.param("sort", String.valueOf(orderBy));
            this.param("order", orderDir);
        }
    }

    public MailSearchRequest(JSONArray body, String folder, int[] columns, int orderBy, String orderDir, boolean failOnError) {
        this(folder, columns, orderBy, orderDir, failOnError);
        this.setBody(body);
    }

    @Override
    public Object getBody() {
        return this.body;
    }

    public void setBody(JSONArray body) {
        this.body = body;
        this.param("data", body.toString());
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return this.params.toArray(new AJAXRequest.Parameter[this.params.size()]);
    }

    public MailSearchParser getParser() {
        return this.searchParser;
    }

    @Override
    public String getServletPath() {
        return "/ajax/mail";
    }

    private void param(String key, String value) {
        if (value != null) {
            this.params.add(new AJAXRequest.Parameter(key, value));
        }
    }

    private String join(int[] values) {
        StringBuilder b = new StringBuilder();
        for (int v : values) {
            b.append(v).append(", ");
        }
        b.setLength(b.length() - 2);
        return b.toString();
    }
}

