/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.DeleteRequest;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.ajax.mail.actions.MultipleAttachmentRequest;
import com.openexchange.ajax.mail.actions.NewMailRequest;
import com.openexchange.ajax.mail.actions.NewMailResponse;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import org.json.JSONArray;
import org.json.JSONObject;

public final class MultipleAttachmentTest
extends AbstractMailTest {
    public MultipleAttachmentTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testGet() throws Throwable {
        String[] folderAndID = null;
        try {
            String eml = "Date: Mon, 19 Nov 2012 21:36:51 +0100 (CET)\nFrom: #ADDR#\nTo: #ADDR#\nMessage-ID: <1508703313.17483.1353357411049>\nSubject: MultipleAttachmentTest\nMIME-Version: 1.0\nContent-Type: multipart/alternative; \n    boundary=\"----=_Part_17482_1388684087.1353357411002\"\n\n------=_Part_17482_1388684087.1353357411002\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 7bit\n\nMultipleAttachmentTest\n------=_Part_17482_1388684087.1353357411002\nMIME-Version: 1.0\nContent-Type: text/html; charset=UTF-8\nContent-Transfer-Encoding: 7bit\n\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"> <head>\n    <meta content=\"text/html; charset=UTF-8\" http-equiv=\"Content-Type\"/>\n </head><body style=\"font-family: verdana,geneva; font-size: 10pt; \">\n \n  <div>\n   MultipleAttachmentTest\n  </div>\n \n</body></html>\n------=_Part_17482_1388684087.1353357411002--\n".replaceAll("#ADDR#", this.getSendAddress());
            NewMailResponse newMailResponse = this.getClient().execute(new NewMailRequest(this.client.getValues().getInboxFolder(), eml, -1, true));
            String folder = newMailResponse.getFolder();
            String id = newMailResponse.getId();
            folderAndID = new String[]{folder, id};
            GetResponse response = Executor.execute(this.getSession(), new GetRequest(folderAndID[0], folderAndID[1]));
            JSONObject mailObject = (JSONObject)response.getResponse().getData();
            MultipleAttachmentTest.assertTrue((String)("Missing field " + MailJSONField.ATTACHMENTS.getKey()), (mailObject.has(MailJSONField.ATTACHMENTS.getKey()) && !mailObject.isNull(MailJSONField.ATTACHMENTS.getKey()) ? 1 : 0) != 0);
            JSONArray attachmentArray = mailObject.getJSONArray(MailJSONField.ATTACHMENTS.getKey());
            int len = attachmentArray.length();
            MultipleAttachmentTest.assertTrue((String)"Missing attachments", (len > 0 ? 1 : 0) != 0);
            String sequenceId = null;
            for (int i = 0; i < len && sequenceId == null; ++i) {
                JSONObject attachmentObject = attachmentArray.getJSONObject(i);
                String contentType = attachmentObject.getString(MailJSONField.CONTENT_TYPE.getKey());
                if (!contentType.regionMatches(true, 0, "text/htm", 0, 8)) continue;
                sequenceId = attachmentObject.getString(MailListField.ID.getKey());
            }
            MultipleAttachmentTest.assertTrue((String)"No HTML part found", (sequenceId != null ? 1 : 0) != 0);
            MultipleAttachmentRequest attachmentRequest = new MultipleAttachmentRequest(folderAndID[0], folderAndID[1], new String[]{sequenceId});
            WebResponse webResponse = Executor.execute4Download(this.getSession(), attachmentRequest, AJAXConfig.getProperty(AJAXConfig.Property.PROTOCOL), AJAXConfig.getProperty(AJAXConfig.Property.HOSTNAME));
            MultipleAttachmentTest.assertFalse((String)"Web response does indicate HTML content", (boolean)webResponse.isHTML());
            MultipleAttachmentTest.assertEquals((String)"No ZIP content", (String)"application/zip", (String)webResponse.getContentType());
            String disp = webResponse.getHeaderField("Content-disposition");
            MultipleAttachmentTest.assertNotNull((String)"No Content-disposition header", (Object)disp);
            MultipleAttachmentTest.assertTrue((String)"Disposition is not set to 'attachment'", (boolean)disp.startsWith("attachment"));
            MultipleAttachmentTest.assertTrue((String)"'filename' parameter not found in Content-disposition", (disp.indexOf("filename=") >= 0 ? 1 : 0) != 0);
            if (folderAndID == null) return;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                MultipleAttachmentTest.fail((String)e.getMessage());
                if (folderAndID == null) return;
            }
            catch (Throwable throwable) {
                if (folderAndID == null) throw throwable;
                String[][] foo = new String[][]{folderAndID};
                Executor.execute(this.getSession(), new DeleteRequest(foo, true));
                throw throwable;
            }
            String[][] foo = new String[][]{folderAndID};
            Executor.execute(this.getSession(), new DeleteRequest(foo, true));
            return;
        }
        String[][] foo = new String[][]{folderAndID};
        Executor.execute(this.getSession(), new DeleteRequest(foo, true));
        return;
    }
}

