/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.eas;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.folder.actions.SubscribeRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.Date;

public class SubscribeTest
extends AbstractAJAXSession {
    private AJAXClient client;

    public SubscribeTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubscribePrivate() throws Throwable {
        block10: {
            String newId;
            block11: {
                SubscribeRequest subscribeRequest;
                String parent = FolderStorage.ROOT_ID;
                newId = null;
                boolean unsubscribe = false;
                try {
                    FolderObject fo = new FolderObject();
                    fo.setParentFolderID(1);
                    fo.setFolderName("testCalendarFolder" + System.currentTimeMillis());
                    fo.setModule(2);
                    OCLPermission oclP = new OCLPermission();
                    oclP.setEntity(this.client.getValues().getUserId());
                    oclP.setGroupPermission(false);
                    oclP.setFolderAdmin(true);
                    oclP.setAllPermission(128, 128, 128, 128);
                    fo.setPermissionsAsArray(new OCLPermission[]{oclP});
                    InsertRequest request = new InsertRequest(EnumAPI.OUTLOOK, fo);
                    InsertResponse response = this.client.execute(request);
                    newId = (String)response.getResponse().getData();
                    SubscribeTest.assertNotNull((String)"New ID must not be null!", (Object)newId);
                    SubscribeRequest subscribeRequest2 = new SubscribeRequest(EnumAPI.EAS_FOLDERS, parent, true);
                    subscribeRequest2.addFolderId(newId, true);
                    this.client.execute(subscribeRequest2);
                    unsubscribe = true;
                    ListRequest listRequest = new ListRequest((API)EnumAPI.EAS_FOLDERS, parent);
                    ListResponse listResponse = this.client.execute(listRequest);
                    boolean found = false;
                    for (Object[] vals : listResponse.getArray()) {
                        if (!newId.equals(vals[0].toString())) continue;
                        found = true;
                        break;
                    }
                    SubscribeTest.assertTrue((String)"Subscribed folder not found.", (boolean)found);
                    subscribeRequest2 = new SubscribeRequest(EnumAPI.EAS_FOLDERS, parent, true);
                    subscribeRequest2.addFolderId(newId, false);
                    this.client.execute(subscribeRequest2);
                    unsubscribe = false;
                    listRequest = new ListRequest((API)EnumAPI.EAS_FOLDERS, parent);
                    listResponse = this.client.execute(listRequest);
                    found = false;
                    for (Object[] vals : listResponse.getArray()) {
                        if (!newId.equals(vals[0].toString())) continue;
                        found = true;
                        break;
                    }
                    SubscribeTest.assertFalse((String)"Unsubscribed folder still available.", (boolean)found);
                    if (null == newId) break block10;
                    if (!unsubscribe) break block11;
                    subscribeRequest = new SubscribeRequest(EnumAPI.EAS_FOLDERS, parent, true);
                    subscribeRequest.addFolderId(newId, false);
                }
                catch (Throwable throwable) {
                    if (null != newId) {
                        if (unsubscribe) {
                            SubscribeRequest subscribeRequest3 = new SubscribeRequest(EnumAPI.EAS_FOLDERS, parent, true);
                            subscribeRequest3.addFolderId(newId, false);
                            this.client.execute(subscribeRequest3);
                        }
                        try {
                            DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OUTLOOK, newId, new Date());
                            this.client.execute(deleteRequest);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                this.client.execute(subscribeRequest);
            }
            try {
                DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OUTLOOK, newId, new Date());
                this.client.execute(deleteRequest);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

