/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.parser.FolderParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public final class Parser {
    private static final Log LOG = LogFactory.getLog(Parser.class);

    private Parser() {
    }

    public static void parse(Object value, int column, FolderObject folder) throws OXException {
        switch (column) {
            case 1: {
                if (value instanceof Integer) {
                    folder.setObjectID(((Number)value).intValue());
                    break;
                }
                if (!(value instanceof String)) break;
                String valueS = (String)value;
                try {
                    folder.setObjectID(Integer.parseInt(valueS));
                }
                catch (NumberFormatException e) {
                    folder.setFullName((String)value);
                }
                break;
            }
            case 301: {
                folder.setModule(FolderParser.getModuleFromString((String)((String)value), (int)(folder.containsObjectID() ? folder.getObjectID() : -1)));
                break;
            }
            case 302: {
                folder.setType(((Integer)value).intValue());
                break;
            }
            case 300: {
                folder.setFolderName((String)value);
                break;
            }
            case 304: {
                folder.setSubfolderFlag(((Boolean)value).booleanValue());
                break;
            }
            case 308: {
                if (null != value && JSONObject.NULL != value) {
                    folder.setDefaultFolder(((Boolean)value).booleanValue());
                    break;
                }
                folder.setDefaultFolder(false);
                break;
            }
            case 2: {
                if (null == value || JSONObject.NULL == value) break;
                folder.setCreatedBy(((Number)value).intValue());
                break;
            }
            case 20: {
                if (null == value || JSONObject.NULL == value) break;
                if (value instanceof Integer) {
                    folder.setParentFolderID(((Number)value).intValue());
                    break;
                }
                if (!(value instanceof String)) break;
                try {
                    folder.setParentFolderID(Integer.valueOf((String)value).intValue());
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            default: {
                LOG.error((Object)("Can't parse column: " + column));
            }
        }
    }
}

