/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.FolderTest;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.AllowedModules;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.Header;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Strings;
import com.openexchange.server.impl.OCLPermission;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class AbstractFolderRequest<T extends AbstractAJAXResponse>
implements AJAXRequest<T> {
    private final API api;
    private AllowedModules[] allowedModules;

    protected AbstractFolderRequest(API api) {
        this.api = api;
    }

    @Override
    public String getServletPath() {
        return this.api.getUrl();
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    protected JSONObject convert(FolderObject folder) throws JSONException {
        JSONObject jsonFolder = new JSONObject();
        if (folder.containsFolderName()) {
            jsonFolder.put("title", (Object)folder.getFolderName());
        }
        JSONArray jsonPerms = new JSONArray();
        for (OCLPermission perm : folder.getPermissions()) {
            JSONObject jsonPermission = new JSONObject();
            jsonPermission.put("entity", perm.getEntity());
            jsonPermission.put("group", perm.isGroupPermission());
            jsonPermission.put("bits", FolderTest.createPermissionBits(perm.getFolderPermission(), perm.getReadPermission(), perm.getWritePermission(), perm.getDeletePermission(), perm.isFolderAdmin()));
            jsonPerms.put((Object)jsonPermission);
        }
        jsonFolder.put("permissions", (Object)jsonPerms);
        if (folder.containsModule()) {
            jsonFolder.put("module", (Object)this.convertModule(folder.getModule()));
        }
        if (folder.containsType()) {
            jsonFolder.put("type", folder.getType());
        }
        return jsonFolder;
    }

    private String convertModule(int module) {
        String retval;
        switch (module) {
            case 1: {
                retval = "tasks";
                break;
            }
            case 2: {
                retval = "calendar";
                break;
            }
            case 3: {
                retval = "contacts";
                break;
            }
            case 7: {
                retval = "mail";
                break;
            }
            case 8: {
                retval = "infostore";
                break;
            }
            default: {
                retval = "";
            }
        }
        return retval;
    }

    public void setAllowedModules(AllowedModules ... allowedModules) {
        this.allowedModules = allowedModules;
    }

    @Override
    public final AJAXRequest.Parameter[] getParameters() {
        ArrayList<AJAXRequest.Parameter> params = new ArrayList<AJAXRequest.Parameter>();
        this.addParameters(params);
        if (this.api.getTreeId() != -1) {
            params.add(new AJAXRequest.Parameter("tree", this.api.getTreeId()));
        }
        if (null != this.allowedModules) {
            Object[] tmp = new String[this.allowedModules.length];
            for (int i = 0; i < this.allowedModules.length; ++i) {
                tmp[i] = this.allowedModules[i].getJSONValue();
            }
            params.add(new AJAXRequest.Parameter("allowed_modules", Strings.join((Object[])tmp, (String)",")));
        }
        return params.toArray(new AJAXRequest.Parameter[params.size()]);
    }

    protected abstract void addParameters(List<AJAXRequest.Parameter> var1);

    protected static String[] i2s(int[] intArr) {
        String[] strArr = new String[intArr.length];
        for (int i = 0; i < intArr.length; ++i) {
            strArr[i] = Integer.valueOf(intArr[i]).toString();
        }
        return strArr;
    }
}

