/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact.action;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.parser.ContactParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class GetResponse
extends AbstractAJAXResponse {
    private Contact contactObj;
    private final TimeZone timeZone;
    private String imageUrl;

    public GetResponse(Response response, TimeZone tz) {
        super(response);
        this.timeZone = tz;
    }

    public Contact getContact() throws OXException, OXException {
        if (null == this.contactObj) {
            this.contactObj = new Contact();
            JSONObject json = (JSONObject)this.getResponse().getData();
            new ContactParser(true, this.timeZone).parse(this.contactObj, json);
        }
        return this.contactObj;
    }

    public void setContact(Contact contactObj) {
        this.contactObj = contactObj;
    }

    public String getImageUrl() throws OXException {
        this.extractImageUrl();
        return this.imageUrl;
    }

    public String getImageUid() throws OXException {
        String imageUrl = this.getImageUrl();
        if (imageUrl == null) {
            return null;
        }
        String path = "/ajax/image?uid=";
        int index = imageUrl.indexOf("/ajax/image?uid=");
        try {
            String uid = URLDecoder.decode(imageUrl.substring(index + "/ajax/image?uid=".length(), imageUrl.length()), "UTF-8");
            return uid;
        }
        catch (UnsupportedEncodingException e) {
            throw OXException.general((String)e.getMessage());
        }
    }

    private void extractImageUrl() throws OXException {
        JSONObject json = (JSONObject)this.getResponse().getData();
        if (this.imageUrl == null && json.hasAndNotNull("image1_url")) {
            try {
                this.imageUrl = json.getString("image1_url");
            }
            catch (JSONException e) {
                throw OXJSONExceptionCodes.JSON_READ_ERROR.create((Throwable)e, new Object[]{json});
            }
        }
    }
}

