/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.action.DeleteRequest;
import com.openexchange.ajax.contact.action.GetRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.ajax.contact.action.InsertRequest;
import com.openexchange.ajax.contact.action.InsertResponse;
import com.openexchange.ajax.contact.action.UpdateRequest;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;
import java.util.Date;

public class YomiTest
extends AbstractAJAXSession {
    private Contact contact;
    private Contact updateContact;

    public YomiTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.contact = new Contact();
        this.contact.setTitle("Herr");
        this.contact.setGivenName("\u660e\u65e5\u9999");
        this.contact.setSurName("\u4f50\u85e4");
        this.contact.setDisplayName("Baab Abba");
        this.contact.setStreetBusiness("Franz-Meier Weg 17");
        this.contact.setCityBusiness("Test Stadt");
        this.contact.setStateBusiness("NRW");
        this.contact.setCountryBusiness("Deutschland");
        this.contact.setTelephoneBusiness1("+49112233445566");
        this.contact.setCompany("Internal Test AG");
        this.contact.setEmail1("baab.abba@open-foobar.com");
        this.contact.setParentFolderID(this.getClient().getValues().getPrivateContactFolder());
        this.contact.setYomiFirstName("\u30a2\u30b9\u30ab");
        this.contact.setYomiLastName("\u30b5\u30c8\u30a6");
        InsertRequest insertRequest = new InsertRequest(this.contact);
        InsertResponse insertResponse = this.getClient().execute(insertRequest);
        insertResponse.fillObject((DataObject)this.contact);
        this.updateContact = new Contact();
        this.updateContact.setYomiFirstName("\u3055\u3068\u3046");
        this.updateContact.setYomiLastName("\u3059\u305a\u304d");
        this.updateContact.setParentFolderID(this.getClient().getValues().getPrivateContactFolder());
    }

    public void testYomiFields() throws Exception {
        GetRequest getRequest = new GetRequest(this.contact, this.getClient().getValues().getTimeZone());
        GetResponse getResponse = this.getClient().execute(getRequest);
        Contact loadedContact = getResponse.getContact();
        YomiTest.assertEquals((String)"Wrong Kanji First name", (String)"\u660e\u65e5\u9999", (String)loadedContact.getGivenName());
        YomiTest.assertEquals((String)"Wrong Kanji Last name", (String)"\u4f50\u85e4", (String)loadedContact.getSurName());
        YomiTest.assertEquals((String)"Wrong Yomi First name", (String)"\u30a2\u30b9\u30ab", (String)loadedContact.getYomiFirstName());
        YomiTest.assertEquals((String)"Wrong Yomi Last name", (String)"\u30b5\u30c8\u30a6", (String)loadedContact.getYomiLastName());
        this.updateContact.setObjectID(this.contact.getObjectID());
        this.updateContact.setLastModified(this.contact.getLastModified());
        UpdateRequest updateRequest = new UpdateRequest(this.updateContact);
        this.getClient().execute(updateRequest);
        this.contact.setLastModified(new Date(Long.MAX_VALUE));
        getRequest = new GetRequest(this.contact, this.getClient().getValues().getTimeZone());
        getResponse = this.getClient().execute(getRequest);
        Contact loadedUpdatedContact = getResponse.getContact();
        YomiTest.assertEquals((String)"Wrong Kanji First name", (String)"\u660e\u65e5\u9999", (String)loadedUpdatedContact.getGivenName());
        YomiTest.assertEquals((String)"Wrong Kanji Last name", (String)"\u4f50\u85e4", (String)loadedUpdatedContact.getSurName());
        YomiTest.assertEquals((String)"Wrong Yomi First name", (String)"\u3055\u3068\u3046", (String)loadedUpdatedContact.getYomiFirstName());
        YomiTest.assertEquals((String)"Wrong Yomi Last name", (String)"\u3059\u305a\u304d", (String)loadedUpdatedContact.getYomiLastName());
    }

    @Override
    protected void tearDown() throws Exception {
        this.getClient().execute(new DeleteRequest(this.contact));
        super.tearDown();
    }
}

