/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.ConflictObject;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import java.util.Calendar;
import java.util.TimeZone;

public class Bug12842Test
extends AbstractAJAXSession {
    public Bug12842Test(String name) {
        super(name);
    }

    public void testConflictBetween() throws Throwable {
        this.rangeTest(8, 12, 9, 11, 1, true);
        this.rangeTest(8, 12, 9, 11, 2, true);
        this.rangeTest(8, 12, 9, 11, 3, true);
        this.rangeTest(8, 12, 9, 11, 4, true);
    }

    public void testConflictOverlappingStartDate() throws Throwable {
        this.rangeTest(8, 12, 7, 9, 1, true);
        this.rangeTest(8, 12, 7, 9, 2, true);
        this.rangeTest(8, 12, 7, 9, 3, true);
        this.rangeTest(8, 12, 7, 9, 4, true);
    }

    public void testConflictOverlappingEndDate() throws Throwable {
        this.rangeTest(8, 12, 11, 13, 1, true);
        this.rangeTest(8, 12, 11, 13, 2, true);
        this.rangeTest(8, 12, 11, 13, 3, true);
        this.rangeTest(8, 12, 11, 13, 4, true);
    }

    public void testConflictOverlapping() throws Throwable {
        this.rangeTest(8, 12, 7, 13, 1, true);
        this.rangeTest(8, 12, 7, 13, 2, true);
        this.rangeTest(8, 12, 7, 13, 3, true);
        this.rangeTest(8, 12, 7, 13, 4, true);
    }

    public void testBoundaryStart() throws Throwable {
        this.rangeTest(8, 12, 6, 8, 1, false);
        this.rangeTest(8, 12, 6, 8, 2, false);
        this.rangeTest(8, 12, 6, 8, 3, false);
        this.rangeTest(8, 12, 6, 8, 4, false);
    }

    public void testBoundaryEnd() throws Throwable {
        this.rangeTest(8, 12, 12, 14, 1, false);
        this.rangeTest(8, 12, 12, 14, 2, false);
        this.rangeTest(8, 12, 12, 14, 3, false);
        this.rangeTest(8, 12, 12, 14, 4, false);
    }

    public void testBeforeStart() throws Throwable {
        this.rangeTest(8, 12, 4, 6, 1, false);
        this.rangeTest(8, 12, 4, 6, 2, false);
        this.rangeTest(8, 12, 4, 6, 3, false);
        this.rangeTest(8, 12, 4, 6, 4, false);
    }

    public void testAfterEnd() throws Throwable {
        this.rangeTest(8, 12, 14, 16, 1, false);
        this.rangeTest(8, 12, 14, 16, 2, false);
        this.rangeTest(8, 12, 14, 16, 3, false);
        this.rangeTest(8, 12, 14, 16, 4, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rangeTest(int start, int end, int conflictStart, int conflictEnd, int type, boolean shouldConflict) throws Throwable {
        Appointment conflictAppointment;
        Appointment appointment;
        AJAXClient client;
        block22: {
            client = null;
            appointment = new Appointment();
            conflictAppointment = new Appointment();
            try {
                client = this.getClient();
                int folderId = client.getValues().getPrivateAppointmentFolder();
                TimeZone tz = client.getValues().getTimeZone();
                appointment = new Appointment();
                appointment.setTitle("Bug12842Test");
                appointment.setParentFolderID(folderId);
                appointment.setIgnoreConflicts(true);
                Calendar calendar = TimeTools.createCalendar(tz);
                calendar.set(5, 28);
                calendar.set(11, start);
                appointment.setStartDate(calendar.getTime());
                calendar.set(11, end);
                appointment.setEndDate(calendar.getTime());
                appointment.setRecurrenceType(type);
                appointment.setInterval(1);
                switch (type) {
                    case 4: {
                        appointment.setMonth(calendar.get(2));
                    }
                    case 3: {
                        appointment.setDayInMonth(calendar.get(5));
                        break;
                    }
                    case 2: {
                        appointment.setDays((int)Math.pow(2.0, calendar.get(7) - 1));
                    }
                    case 1: {
                        break;
                    }
                }
                InsertRequest request = new InsertRequest(appointment, tz);
                CommonInsertResponse response = client.execute(request);
                response.fillObject((DataObject)appointment);
                conflictAppointment.setTitle("conflict");
                conflictAppointment.setParentFolderID(folderId);
                conflictAppointment.setIgnoreConflicts(false);
                calendar = TimeTools.createCalendar(tz);
                calendar.set(5, 28);
                switch (type) {
                    case 4: {
                        calendar.add(1, 1);
                        break;
                    }
                    case 3: {
                        calendar.add(2, 1);
                        break;
                    }
                    case 2: {
                        calendar.add(3, 2);
                        break;
                    }
                    case 1: {
                        calendar.add(5, 8);
                        break;
                    }
                }
                calendar.set(11, conflictStart);
                conflictAppointment.setStartDate(calendar.getTime());
                calendar.set(11, conflictEnd);
                conflictAppointment.setEndDate(calendar.getTime());
                request = new InsertRequest(conflictAppointment, tz, false);
                response = client.execute(request);
                if (shouldConflict) {
                    if (!response.hasConflicts()) {
                        conflictAppointment.setObjectID(response.getId());
                        conflictAppointment.setLastModified(response.getTimestamp());
                        Bug12842Test.fail((String)"Conflict expected.");
                    }
                    break block22;
                }
                if (response.hasConflicts()) {
                    for (ConflictObject conflict : response.getConflicts()) {
                        if (!conflict.getTitle().startsWith("Bug12842Test")) continue;
                        Bug12842Test.fail((String)"No conflict expected.");
                    }
                }
                conflictAppointment.setObjectID(response.getId());
                conflictAppointment.setLastModified(response.getTimestamp());
            }
            catch (Throwable throwable) {
                DeleteRequest deleteRequest;
                if (client != null && conflictAppointment.getObjectID() != 0 && conflictAppointment.getLastModified() != null) {
                    deleteRequest = new DeleteRequest(conflictAppointment.getObjectID(), client.getValues().getPrivateAppointmentFolder(), conflictAppointment.getLastModified());
                    client.execute(deleteRequest);
                }
                if (client != null && appointment.getObjectID() != 0 && appointment.getLastModified() != null) {
                    deleteRequest = new DeleteRequest(appointment.getObjectID(), client.getValues().getPrivateAppointmentFolder(), appointment.getLastModified());
                    client.execute(deleteRequest);
                }
                throw throwable;
            }
        }
        if (client != null && conflictAppointment.getObjectID() != 0 && conflictAppointment.getLastModified() != null) {
            DeleteRequest deleteRequest = new DeleteRequest(conflictAppointment.getObjectID(), client.getValues().getPrivateAppointmentFolder(), conflictAppointment.getLastModified());
            client.execute(deleteRequest);
        }
        if (client != null && appointment.getObjectID() != 0 && appointment.getLastModified() != null) {
            DeleteRequest deleteRequest = new DeleteRequest(appointment.getObjectID(), client.getValues().getPrivateAppointmentFolder(), appointment.getLastModified());
            client.execute(deleteRequest);
        }
    }
}

