/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.ConflictObject;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Bug12432Test
extends AbstractAJAXSession {
    public Bug12432Test(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFirstReservedThenFree() throws Throwable {
        AJAXClient client = null;
        Appointment appointmentReserved = null;
        Appointment appointmentFree = null;
        try {
            client = this.getClient();
            int folderId = client.getValues().getPrivateAppointmentFolder();
            TimeZone tz = client.getValues().getTimeZone();
            appointmentReserved = this.createAppointment("Bug12432Test - reserved", 1, folderId, tz);
            appointmentReserved.setIgnoreConflicts(true);
            appointmentFree = this.createAppointment("Bug12432Test - free", 4, folderId, tz);
            appointmentFree.setIgnoreConflicts(false);
            InsertRequest request = new InsertRequest(appointmentReserved, tz);
            AppointmentInsertResponse response = client.execute(request);
            appointmentReserved.setObjectID(response.getId());
            appointmentReserved.setLastModified(response.getTimestamp());
            request = new InsertRequest(appointmentFree, tz, false);
            response = client.execute(request);
            Bug12432Test.assertFalse((boolean)response.hasConflicts());
            appointmentFree.setObjectID(response.getId());
            appointmentFree.setLastModified(response.getTimestamp());
        }
        catch (Throwable throwable) {
            this.deleteAppointment(appointmentReserved, client);
            this.deleteAppointment(appointmentFree, client);
            throw throwable;
        }
        this.deleteAppointment(appointmentReserved, client);
        this.deleteAppointment(appointmentFree, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFirstFreeThenReserved() throws Throwable {
        AJAXClient client = null;
        Appointment appointmentReserved = null;
        Appointment appointmentFree = null;
        try {
            client = this.getClient();
            int folderId = client.getValues().getPrivateAppointmentFolder();
            TimeZone tz = client.getValues().getTimeZone();
            appointmentReserved = this.createAppointment("Bug12432Test - reserved", 1, folderId, tz);
            appointmentReserved.setIgnoreConflicts(true);
            appointmentFree = this.createAppointment("Bug12432Test - free", 4, folderId, tz);
            appointmentFree.setIgnoreConflicts(false);
            InsertRequest request = new InsertRequest(appointmentFree, tz);
            AppointmentInsertResponse response = client.execute(request);
            appointmentFree.setObjectID(response.getId());
            appointmentFree.setLastModified(response.getTimestamp());
            request = new InsertRequest(appointmentReserved, tz, false);
            response = client.execute(request);
            Bug12432Test.assertFalse((boolean)response.hasConflicts());
            appointmentReserved.setObjectID(response.getId());
            appointmentReserved.setLastModified(response.getTimestamp());
        }
        catch (Throwable throwable) {
            this.deleteAppointment(appointmentReserved, client);
            this.deleteAppointment(appointmentFree, client);
            throw throwable;
        }
        this.deleteAppointment(appointmentReserved, client);
        this.deleteAppointment(appointmentFree, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChangeFree() throws Throwable {
        AJAXClient client = null;
        Appointment appointmentReserved = null;
        Appointment appointmentFree = null;
        try {
            client = this.getClient();
            int folderId = client.getValues().getPrivateAppointmentFolder();
            TimeZone tz = client.getValues().getTimeZone();
            appointmentReserved = this.createAppointment("Bug12432Test - reserved", 1, folderId, tz);
            appointmentReserved.setIgnoreConflicts(true);
            appointmentFree = this.createAppointment("Bug12432Test - free", 4, folderId, tz);
            appointmentFree.setIgnoreConflicts(true);
            InsertRequest request = new InsertRequest(appointmentReserved, tz);
            AppointmentInsertResponse response = client.execute(request);
            appointmentReserved.setObjectID(response.getId());
            appointmentReserved.setLastModified(response.getTimestamp());
            request = new InsertRequest(appointmentFree, tz, false);
            response = client.execute(request);
            appointmentFree.setObjectID(response.getId());
            appointmentFree.setLastModified(response.getTimestamp());
            Appointment updateAppointment = new Appointment();
            updateAppointment.setParentFolderID(folderId);
            updateAppointment.setObjectID(appointmentFree.getObjectID());
            updateAppointment.setLastModified(appointmentFree.getLastModified());
            GregorianCalendar calendar = new GregorianCalendar(tz);
            calendar.setTime(appointmentFree.getStartDate());
            ((Calendar)calendar).add(11, -1);
            updateAppointment.setStartDate(calendar.getTime());
            calendar = new GregorianCalendar(tz);
            calendar.setTime(appointmentFree.getEndDate());
            ((Calendar)calendar).add(11, 1);
            updateAppointment.setEndDate(calendar.getTime());
            updateAppointment.setIgnoreConflicts(false);
            UpdateRequest updateRequest = new UpdateRequest(updateAppointment, tz);
            UpdateResponse updateResponse = client.execute(updateRequest);
            Bug12432Test.assertFalse((String)"Update on free Appointment should not conflict.", (boolean)updateResponse.hasConflicts());
            appointmentFree.setLastModified(updateResponse.getTimestamp());
        }
        catch (Throwable throwable) {
            this.deleteAppointment(appointmentReserved, client);
            this.deleteAppointment(appointmentFree, client);
            throw throwable;
        }
        this.deleteAppointment(appointmentReserved, client);
        this.deleteAppointment(appointmentFree, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChangeReserved() throws Throwable {
        AJAXClient client = null;
        Appointment appointmentReserved = null;
        Appointment appointmentFree = null;
        try {
            client = this.getClient();
            int folderId = client.getValues().getPrivateAppointmentFolder();
            TimeZone tz = client.getValues().getTimeZone();
            appointmentReserved = this.createAppointment("Bug12432Test - reserved", 1, folderId, tz);
            appointmentReserved.setIgnoreConflicts(true);
            appointmentFree = this.createAppointment("Bug12432Test - free", 4, folderId, tz);
            appointmentFree.setIgnoreConflicts(true);
            InsertRequest request = new InsertRequest(appointmentReserved, tz);
            AppointmentInsertResponse response = client.execute(request);
            appointmentReserved.setObjectID(response.getId());
            appointmentReserved.setLastModified(response.getTimestamp());
            request = new InsertRequest(appointmentFree, tz, false);
            response = client.execute(request);
            appointmentFree.setObjectID(response.getId());
            appointmentFree.setLastModified(response.getTimestamp());
            Appointment updateAppointment = new Appointment();
            updateAppointment.setParentFolderID(folderId);
            updateAppointment.setObjectID(appointmentReserved.getObjectID());
            updateAppointment.setLastModified(appointmentReserved.getLastModified());
            GregorianCalendar calendar = new GregorianCalendar(tz);
            calendar.setTime(appointmentReserved.getStartDate());
            ((Calendar)calendar).add(11, -1);
            updateAppointment.setStartDate(calendar.getTime());
            calendar = new GregorianCalendar(tz);
            calendar.setTime(appointmentReserved.getEndDate());
            ((Calendar)calendar).add(11, 1);
            updateAppointment.setEndDate(calendar.getTime());
            updateAppointment.setIgnoreConflicts(false);
            UpdateRequest updateRequest = new UpdateRequest(updateAppointment, tz);
            UpdateResponse updateResponse = client.execute(updateRequest);
            if (updateResponse.hasConflicts()) {
                for (ConflictObject conflict : updateResponse.getConflicts()) {
                    Bug12432Test.assertFalse((String)"Update on Appointment should not conflict with free Appointment.", (conflict.getId() == appointmentFree.getObjectID() ? 1 : 0) != 0);
                }
            }
            appointmentReserved.setLastModified(updateResponse.getTimestamp());
        }
        catch (Throwable throwable) {
            this.deleteAppointment(appointmentReserved, client);
            this.deleteAppointment(appointmentFree, client);
            throw throwable;
        }
        this.deleteAppointment(appointmentReserved, client);
        this.deleteAppointment(appointmentFree, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBugAsWritten() throws Throwable {
        AJAXClient client = null;
        Appointment appointmentA = null;
        Appointment appointmentB = null;
        try {
            client = this.getClient();
            int folderId = client.getValues().getPrivateAppointmentFolder();
            TimeZone tz = client.getValues().getTimeZone();
            appointmentA = this.createAppointment("Just-for-Info", 4, folderId, tz);
            Calendar calendar = TimeTools.createCalendar(tz);
            calendar.set(11, 10);
            appointmentA.setStartDate(calendar.getTime());
            calendar.set(11, 18);
            appointmentA.setEndDate(calendar.getTime());
            appointmentA.setIgnoreConflicts(true);
            InsertRequest request = new InsertRequest(appointmentA, tz, false);
            AppointmentInsertResponse response = client.execute(request);
            appointmentA.setObjectID(response.getId());
            appointmentA.setLastModified(response.getTimestamp());
            appointmentB = this.createAppointment("Conf-Call", 1, folderId, tz);
            calendar = TimeTools.createCalendar(tz);
            calendar.set(11, 12);
            appointmentB.setStartDate(calendar.getTime());
            calendar.set(11, 13);
            appointmentB.setEndDate(calendar.getTime());
            appointmentB.setIgnoreConflicts(true);
            request = new InsertRequest(appointmentB, tz);
            response = client.execute(request);
            appointmentB.setObjectID(response.getId());
            appointmentB.setLastModified(response.getTimestamp());
            Appointment updateAppointmentA = new Appointment();
            updateAppointmentA.setParentFolderID(folderId);
            updateAppointmentA.setObjectID(appointmentA.getObjectID());
            updateAppointmentA.setLastModified(appointmentA.getLastModified());
            calendar = TimeTools.createCalendar(tz);
            calendar.set(11, 16);
            updateAppointmentA.setEndDate(calendar.getTime());
            updateAppointmentA.setIgnoreConflicts(false);
            UpdateRequest updateRequest = new UpdateRequest(updateAppointmentA, tz);
            UpdateResponse updateResponse = client.execute(updateRequest);
            Bug12432Test.assertFalse((String)"Update on free Appointment should not conflict.", (boolean)updateResponse.hasConflicts());
            appointmentA.setLastModified(updateResponse.getTimestamp());
        }
        catch (Throwable throwable) {
            this.deleteAppointment(appointmentB, client);
            this.deleteAppointment(appointmentA, client);
            throw throwable;
        }
        this.deleteAppointment(appointmentB, client);
        this.deleteAppointment(appointmentA, client);
    }

    private Appointment createAppointment(String title, int shownAs, int folderId, TimeZone tz) {
        Appointment appointment = new Appointment();
        appointment.setTitle(title);
        appointment.setParentFolderID(folderId);
        appointment.setShownAs(shownAs);
        Calendar calendar = TimeTools.createCalendar(tz);
        calendar.set(11, 8);
        appointment.setStartDate(calendar.getTime());
        calendar.set(11, 9);
        appointment.setEndDate(calendar.getTime());
        return appointment;
    }

    private void deleteAppointment(Appointment appointment, AJAXClient client) throws Throwable {
        if (client != null && appointment.getObjectID() != 0 && appointment.getLastModified() != null) {
            DeleteRequest deleteRequest = new DeleteRequest(appointment.getObjectID(), client.getValues().getPrivateAppointmentFolder(), appointment.getLastModified());
            client.execute(deleteRequest);
        }
    }
}

