/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.AbstractAJAXTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.resource.Resource;
import com.openexchange.tools.URLParameter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ResourceTest
extends AbstractAJAXTest {
    private static final String RESOURCE_URL = "/ajax/resource";

    public ResourceTest(String name) {
        super(name);
    }

    public void testSearch() throws Exception {
        Resource[] resources = ResourceTest.searchResource(this.getWebConversation(), "*", "http://" + this.getHostName(), this.getSessionId());
        ResourceTest.assertTrue((String)"resource array size is not > 0", (resources.length > 0 ? 1 : 0) != 0);
    }

    public void testList() throws Exception {
        Resource[] resources = ResourceTest.searchResource(this.getWebConversation(), "*", "http://" + this.getHostName(), this.getSessionId());
        ResourceTest.assertTrue((String)"resource array size is not > 0", (resources.length > 0 ? 1 : 0) != 0);
        int[] id = new int[resources.length];
        for (int a = 0; a < id.length; ++a) {
            id[a] = resources[a].getIdentifier();
        }
        resources = ResourceTest.listResource(this.getWebConversation(), id, "http://" + this.getHostName(), this.getSessionId());
        ResourceTest.assertTrue((String)"resource array size is not > 0", (resources.length > 0 ? 1 : 0) != 0);
    }

    public void testGet() throws Exception {
        Resource[] resources = ResourceTest.searchResource(this.getWebConversation(), "*", "http://" + this.getHostName(), this.getSessionId());
        ResourceTest.assertTrue((String)"resource array size is not > 0", (resources.length > 0 ? 1 : 0) != 0);
        ResourceTest.loadResource(this.getWebConversation(), resources[0].getIdentifier(), "http://" + this.getHostName(), this.getSessionId());
    }

    public static Resource[] searchResource(WebConversation webCon, String searchpattern, String host, String session) throws Exception {
        host = ResourceTest.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "search");
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("pattern", (Object)searchpattern);
        ByteArrayInputStream bais = new ByteArrayInputStream(jsonObj.toString().getBytes());
        PutMethodWebRequest req = new PutMethodWebRequest(host + RESOURCE_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
        WebResponse resp = webCon.getResponse((WebRequest)req);
        ResourceTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            ResourceTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        ResourceTest.assertNotNull((String)"timestamp is null", (Object)response.getTimestamp());
        JSONArray jsonArray = (JSONArray)response.getData();
        return ResourceTest.extractResources(jsonArray).toArray(new Resource[0]);
    }

    public static Resource[] listResource(WebConversation webCon, int[] id, String host, String session) throws Exception {
        host = ResourceTest.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "list");
        JSONArray requestArray = new JSONArray();
        for (int a = 0; a < id.length; ++a) {
            JSONObject jData = new JSONObject();
            jData.put("id", id[a]);
            requestArray.put((Object)jData);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(requestArray.toString().getBytes());
        PutMethodWebRequest req = new PutMethodWebRequest(host + RESOURCE_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
        WebResponse resp = webCon.getResponse((WebRequest)req);
        ResourceTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            ResourceTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        ResourceTest.assertNotNull((String)"timestamp", (Object)response.getTimestamp());
        JSONArray jsonArray = (JSONArray)response.getData();
        return ResourceTest.extractResources(jsonArray).toArray(new Resource[0]);
    }

    public static Resource loadResource(WebConversation webCon, int groupId, String host, String session) throws Exception {
        host = ResourceTest.appendPrefix(host);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "get");
        parameter.setParameter("id", Integer.toString(groupId));
        GetMethodWebRequest req = new GetMethodWebRequest(host + RESOURCE_URL + parameter.getURLParameters());
        WebResponse resp = webCon.getResponse((WebRequest)req);
        ResourceTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            ResourceTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        ResourceTest.assertNotNull((String)"timestamp is null", (Object)response.getTimestamp());
        JSONObject jsonObj = (JSONObject)response.getData();
        return ResourceTest.extractResource(jsonObj);
    }

    private static List<Resource> extractResources(JSONArray array) throws JSONException {
        LinkedList<Resource> resources = new LinkedList<Resource>();
        int length = array.length();
        for (int i = 0; i < length; ++i) {
            resources.add(ResourceTest.extractResource(array.getJSONObject(i)));
        }
        return resources;
    }

    private static Resource extractResource(JSONObject jObj) throws JSONException {
        Resource res = new Resource();
        res.setIdentifier(jObj.getInt("id"));
        if (jObj.has("display_name")) {
            res.setDisplayName(jObj.getString("display_name"));
        }
        if (jObj.has("last_modified")) {
            // empty if block
        }
        return res;
    }
}

