/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.comparator;

import com.openexchange.groupware.ldap.User;
import com.openexchange.user.json.Utility;
import com.openexchange.user.json.field.UserField;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Comparators {
    public static final Comparator<User> COMPARATOR_ID = new Comparator<User>(){

        @Override
        public int compare(User o1, User o2) {
            int secondVal;
            int firstVal = o1.getId();
            return firstVal < (secondVal = o2.getId()) ? -1 : (firstVal == secondVal ? 0 : 1);
        }
    };
    private static final ConcurrentMap<Locale, Comparator<User>> LOGIN_INFO_COMPARATORS;
    private static final Map<UserField, Comparator<User>> COMPARATORS;

    private Comparators() {
    }

    public static Comparator<User> getComparator(UserField userField, Locale sessionLocale, boolean descending) {
        InvertedComparator comparator = COMPARATORS.get((Object)userField);
        if (null != comparator) {
            return descending ? new InvertedComparator(comparator) : comparator;
        }
        if (UserField.LOGIN_INFO.equals((Object)userField)) {
            LocalizedComparator newInst;
            LocalizedComparator loginInfoComp = (LocalizedComparator)LOGIN_INFO_COMPARATORS.get(sessionLocale);
            if (null == loginInfoComp && null == (loginInfoComp = LOGIN_INFO_COMPARATORS.putIfAbsent(sessionLocale, newInst = new LocalizedComparator(sessionLocale){

                @Override
                public int compare(User o1, User o2) {
                    return this.collator.compare(o1.getLoginInfo(), o2.getLoginInfo());
                }
            }))) {
                loginInfoComp = newInst;
            }
            return descending ? new InvertedComparator(loginInfoComp) : loginInfoComp;
        }
        return null;
    }

    static {
        EnumMap<UserField, Comparator<User>> enumMap = new EnumMap<UserField, Comparator<User>>(UserField.class);
        enumMap.put(UserField.ID, COMPARATOR_ID);
        enumMap.put(UserField.ALIASES, new Comparator<User>(){

            @Override
            public int compare(User o1, User o2) {
                int secondVal;
                int firstVal = o1.getId();
                return firstVal < (secondVal = o2.getId()) ? -1 : (firstVal == secondVal ? 0 : 1);
            }
        });
        enumMap.put(UserField.GROUPS, new Comparator<User>(){

            @Override
            public int compare(User o1, User o2) {
                int secondVal;
                int firstVal = o1.getId();
                return firstVal < (secondVal = o2.getId()) ? -1 : (firstVal == secondVal ? 0 : 1);
            }
        });
        enumMap.put(UserField.TIME_ZONE, new Comparator<User>(){

            @Override
            public int compare(User o1, User o2) {
                TimeZone timeZone2;
                TimeZone timeZone1 = Utility.getTimeZone(o1.getTimeZone());
                if (timeZone1.equals(timeZone2 = Utility.getTimeZone(o2.getTimeZone()))) {
                    return 0;
                }
                return timeZone1.getID().compareToIgnoreCase(timeZone2.getID());
            }
        });
        enumMap.put(UserField.LOCALE, new Comparator<User>(){

            @Override
            public int compare(User o1, User o2) {
                Locale l2;
                Locale l1 = o1.getLocale();
                if (l1.equals(l2 = o2.getLocale())) {
                    return 0;
                }
                return l1.toString().compareToIgnoreCase(l2.toString());
            }
        });
        enumMap.put(UserField.CONTACT_ID, new Comparator<User>(){

            @Override
            public int compare(User o1, User o2) {
                int secondVal;
                int firstVal = o1.getContactId();
                return firstVal < (secondVal = o2.getContactId()) ? -1 : (firstVal == secondVal ? 0 : 1);
            }
        });
        COMPARATORS = Collections.unmodifiableMap(enumMap);
        LOGIN_INFO_COMPARATORS = new ConcurrentHashMap<Locale, Comparator<User>>();
    }

    private static class InvertedComparator<T>
    implements Comparator<T> {
        private final Comparator<T> comparator;

        public InvertedComparator(Comparator<T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(T o1, T o2) {
            return -1 * this.comparator.compare(o1, o2);
        }
    }

    private static abstract class LocalizedComparator
    implements Comparator<User> {
        protected final Collator collator;

        protected LocalizedComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }
    }
}

